/*
 * Decompiled with CFR 0.152.
 */
package fuzs.enchantinginfuser.client.gui.screens.inventory;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import fuzs.enchantinginfuser.EnchantingInfuser;
import fuzs.enchantinginfuser.client.gui.components.IconButton;
import fuzs.enchantinginfuser.network.client.message.C2SAddEnchantLevelMessage;
import fuzs.enchantinginfuser.world.inventory.InfuserMenu;
import fuzs.puzzleslib.network.v2.message.Message;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FocusableGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.INestedGuiEventHandler;
import net.minecraft.client.gui.IRenderable;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.util.InputMappings;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.EnchantmentNameParts;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.LanguageMap;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class InfuserScreen
extends ContainerScreen<InfuserMenu> {
    private static final ResourceLocation INFUSER_LOCATION = new ResourceLocation("enchantinginfuser", "textures/gui/container/enchanting_infuser.png");
    private final int enchantmentSeed = new Random().nextInt();
    private List<IReorderingProcessor> activeTooltip;
    private float scrollOffs;
    private boolean scrolling;
    private TextFieldWidget searchBox;
    private ScrollingList scrollingList;
    private boolean ignoreTextInput;
    private Button enchantButton;

    public InfuserScreen(InfuserMenu pMenu, PlayerInventory pPlayerInventory, ITextComponent pTitle) {
        super((Container)pMenu, pPlayerInventory, pTitle);
        this.field_146999_f = 220;
        this.field_147000_g = 185;
        this.field_238744_r_ = 30;
        this.field_238745_s_ = this.field_147000_g - 94;
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        this.searchBox.func_146178_a();
        this.updateButtons();
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        this.field_230706_i_.field_195559_v.func_197967_a(true);
        this.searchBox = new TextFieldWidget(this.field_230712_o_, this.field_147003_i + 67, this.field_147009_r + 6, 116, 9, (ITextComponent)new TranslationTextComponent("itemGroup.search")){

            public boolean func_231044_a_(double mouseX, double mouseY, int button) {
                if (this.func_146176_q() && button == 1) {
                    this.func_146180_a("");
                    InfuserScreen.this.refreshSearchResults();
                }
                return super.func_231044_a_(mouseX, mouseY, button);
            }
        };
        this.searchBox.func_146203_f(50);
        this.searchBox.func_146185_a(false);
        this.searchBox.func_146193_g(0xFFFFFF);
        this.func_230481_d_((IGuiEventListener)this.searchBox);
        this.scrollingList = new ScrollingList(this.field_147003_i + 29, this.field_147009_r + 17, 162, 18, 4);
        this.func_230481_d_((IGuiEventListener)this.scrollingList);
        this.enchantButton = (Button)this.func_230480_a_((Widget)new IconButton(this.field_147003_i + 7, this.field_147009_r + 55, 18, 18, 126, 185, INFUSER_LOCATION, button -> {
            if (((InfuserMenu)this.field_147002_h).func_75140_a((PlayerEntity)this.field_230706_i_.field_71439_g, 0)) {
                this.field_230706_i_.field_71442_b.func_78756_a(((InfuserMenu)this.field_147002_h).field_75152_c, 0);
            }
            this.searchBox.func_146180_a("");
        }));
        this.updateButtons();
    }

    private void updateButtons() {
        this.enchantButton.field_230693_o_ = ((InfuserMenu)this.field_147002_h).canEnchant((PlayerEntity)this.field_230706_i_.field_71439_g);
    }

    public void setActiveTooltip(List<IReorderingProcessor> activeTooltip) {
        this.activeTooltip = activeTooltip;
    }

    public void func_231152_a_(Minecraft pMinecraft, int pWidth, int pHeight) {
        String s = this.searchBox.func_146179_b();
        super.func_231152_a_(pMinecraft, pWidth, pHeight);
        this.searchBox.func_146180_a(s);
        this.refreshSearchResults();
    }

    public void func_231164_f_() {
        super.func_231164_f_();
        this.field_230706_i_.field_195559_v.func_197967_a(false);
    }

    public boolean func_231042_a_(char pCodePoint, int pModifiers) {
        if (this.ignoreTextInput) {
            return false;
        }
        String s = this.searchBox.func_146179_b();
        if (this.searchBox.func_231042_a_(pCodePoint, pModifiers)) {
            if (!Objects.equals(s, this.searchBox.func_146179_b())) {
                this.refreshSearchResults();
            }
            return true;
        }
        return false;
    }

    public boolean func_231046_a_(int pKeyCode, int pScanCode, int pModifiers) {
        this.ignoreTextInput = false;
        if (!this.searchBox.func_230999_j_()) {
            if (this.field_230706_i_.field_71474_y.field_74310_D.func_197976_a(pKeyCode, pScanCode)) {
                this.ignoreTextInput = true;
                this.searchBox.func_146195_b(true);
                return true;
            }
            return super.func_231046_a_(pKeyCode, pScanCode, pModifiers);
        }
        boolean flag = this.field_147006_u != null && this.field_147006_u.func_75216_d();
        boolean flag1 = InputMappings.func_197954_a((int)pKeyCode, (int)pScanCode).func_241552_e_().isPresent();
        if (flag && flag1 && this.func_195363_d(pKeyCode, pScanCode)) {
            this.ignoreTextInput = true;
            return true;
        }
        String s = this.searchBox.func_146179_b();
        if (this.searchBox.func_231046_a_(pKeyCode, pScanCode, pModifiers)) {
            if (!Objects.equals(s, this.searchBox.func_146179_b())) {
                this.refreshSearchResults();
            }
            return true;
        }
        return this.searchBox.func_230999_j_() && this.searchBox.func_146176_q() && pKeyCode != 256 || super.func_231046_a_(pKeyCode, pScanCode, pModifiers);
    }

    public boolean func_223281_a_(int pKeyCode, int pScanCode, int pModifiers) {
        this.ignoreTextInput = false;
        return super.func_223281_a_(pKeyCode, pScanCode, pModifiers);
    }

    public void refreshSearchResults() {
        this.scrollingList.clearEntries();
        String s = this.searchBox.func_146179_b().toLowerCase(Locale.ROOT).trim();
        if (s.isEmpty()) {
            ((InfuserMenu)this.field_147002_h).getSortedEntries().stream().map(e -> new EnchantmentListEntry((Enchantment)e.getKey(), (Integer)e.getValue())).forEach(this.scrollingList::addEntry);
        } else {
            ((InfuserMenu)this.field_147002_h).getSortedEntries().stream().filter(e -> new TranslationTextComponent(((Enchantment)e.getKey()).func_77320_a()).getString().toLowerCase(Locale.ROOT).contains(s)).filter(e -> (Integer)((InfuserMenu)this.field_147002_h).getMaxLevel((Enchantment)e.getKey()).getSecond() > 0).map(e -> new EnchantmentListEntry((Enchantment)e.getKey(), (Integer)e.getValue())).forEach(this.scrollingList::addEntry);
        }
        this.scrollOffs = 0.0f;
        this.scrollingList.scrollTo(0.0f);
    }

    public boolean func_231044_a_(double pMouseX, double pMouseY, int pButton) {
        if (pButton == 0 && this.insideScrollbar(pMouseX, pMouseY)) {
            this.scrolling = this.scrollingList.canScroll();
            return true;
        }
        return super.func_231044_a_(pMouseX, pMouseY, pButton);
    }

    protected boolean insideScrollbar(double pMouseX, double pMouseY) {
        int fromX = this.field_147003_i + 197;
        int fromY = this.field_147009_r + 17;
        int toX = fromX + 14;
        int toY = fromY + 72;
        return pMouseX >= (double)fromX && pMouseY >= (double)fromY && pMouseX < (double)toX && pMouseY < (double)toY;
    }

    public boolean func_231048_c_(double pMouseX, double pMouseY, int pButton) {
        if (pButton == 0) {
            this.scrolling = false;
        }
        return super.func_231048_c_(pMouseX, pMouseY, pButton);
    }

    public boolean func_231043_a_(double pMouseX, double pMouseY, double pDelta) {
        if (!this.scrollingList.canScroll()) {
            return false;
        }
        this.scrollOffs = (float)((double)this.scrollOffs - pDelta / (double)(this.scrollingList.getItemCount() - 4));
        this.scrollOffs = MathHelper.func_76131_a((float)this.scrollOffs, (float)0.0f, (float)1.0f);
        this.scrollingList.scrollTo(this.scrollOffs);
        return true;
    }

    public boolean func_231045_a_(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        if (this.scrolling) {
            int i = this.field_147009_r + 17;
            int j = i + 72;
            this.scrollOffs = ((float)pMouseY - (float)i - 7.5f) / ((float)(j - i) - 15.0f);
            this.scrollOffs = MathHelper.func_76131_a((float)this.scrollOffs, (float)0.0f, (float)1.0f);
            this.scrollingList.scrollTo(this.scrollOffs);
            return true;
        }
        return super.func_231045_a_(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    public void func_230430_a_(MatrixStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.activeTooltip = null;
        this.func_230446_a_(poseStack);
        super.func_230430_a_(poseStack, mouseX, mouseY, partialTick);
        this.scrollingList.func_230430_a_(poseStack, mouseX, mouseY, partialTick);
        this.renderEnchantingPower(poseStack, mouseX, mouseY);
        this.renderEnchantingCost(poseStack, mouseX, mouseY);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.activeTooltip != null) {
            this.func_238654_b_(poseStack, this.activeTooltip, mouseX, mouseY);
        } else {
            this.func_230459_a_(poseStack, mouseX, mouseY);
        }
    }

    private void renderEnchantingCost(MatrixStack poseStack, int mouseX, int mouseY) {
        int cost = ((InfuserMenu)this.field_147002_h).getCost();
        if (cost <= 0) {
            return;
        }
        boolean canEnchant = ((InfuserMenu)this.field_147002_h).canEnchant((PlayerEntity)this.field_230706_i_.field_71439_g);
        int costColor = canEnchant ? 8453920 : 0xFF5555;
        int posX = this.field_147003_i + 7;
        int posY = this.field_147009_r + 55;
        this.renderReadableText(poseStack, posX + 1, posY + 1, String.valueOf(cost), costColor);
        if (mouseX >= posX && mouseY >= posY && mouseX < posX + 18 && mouseY < posY + 18) {
            ArrayList list = Lists.newArrayList();
            if (canEnchant) {
                ((InfuserMenu)this.field_147002_h).getValidEnchantments().map(e -> ((Enchantment)e.getKey()).func_200305_d(((Integer)e.getValue()).intValue())).forEach(list::add);
                list.add(StringTextComponent.field_240750_d_);
                TranslationTextComponent mutablecomponent1 = cost == 1 ? new TranslationTextComponent("container.enchant.level.one") : new TranslationTextComponent("container.enchant.level.many", new Object[]{cost});
                list.add(mutablecomponent1.func_240699_a_(TextFormatting.GRAY));
            } else {
                list.add(new TranslationTextComponent("container.enchant.level.requirement", new Object[]{cost}).func_240699_a_(TextFormatting.RED));
            }
            this.setActiveTooltip(LanguageMap.func_74808_a().func_244260_a((List)list));
        }
    }

    private void renderReadableText(MatrixStack poseStack, int posX, int posY, String text, int color) {
        this.field_230712_o_.func_238421_b_(poseStack, text, (float)((posX += 17 - this.field_230712_o_.func_78256_a(text)) - 1), (float)(posY += 9), 0);
        this.field_230712_o_.func_238421_b_(poseStack, text, (float)(posX + 1), (float)posY, 0);
        this.field_230712_o_.func_238421_b_(poseStack, text, (float)posX, (float)(posY - 1), 0);
        this.field_230712_o_.func_238421_b_(poseStack, text, (float)posX, (float)(posY + 1), 0);
        this.field_230712_o_.func_238421_b_(poseStack, text, (float)posX, (float)posY, color);
    }

    private void renderEnchantingPower(MatrixStack poseStack, int mouseX, int mouseY) {
        ItemStack itemstack = new ItemStack((IItemProvider)Items.field_221651_bN);
        this.field_230707_j_.field_77023_b = 100.0f;
        int posX = this.field_147003_i + 196;
        int posY = this.field_147009_r + 161;
        this.field_230707_j_.func_239390_c_(itemstack, posX, posY);
        String power = String.valueOf(((InfuserMenu)this.field_147002_h).getCurrentPower());
        poseStack.func_227860_a_();
        poseStack.func_227861_a_(0.0, 0.0, 300.0);
        this.field_230712_o_.func_238405_a_(poseStack, power, (float)(posX + 19 - 2 - this.field_230712_o_.func_78256_a(power)), (float)(posY + 6 + 3), 0xFFFFFF);
        poseStack.func_227865_b_();
        this.field_230707_j_.field_77023_b = 0.0f;
        if (mouseX >= posX && mouseY >= posY && mouseX < posX + 16 && mouseY < posY + 16) {
            this.setActiveTooltip(Lists.newArrayList((Object[])new IReorderingProcessor[]{new TranslationTextComponent("gui.enchantinginfuser.tooltip.enchanting_power", new Object[]{power}).func_240699_a_(TextFormatting.YELLOW).func_241878_f()}));
        }
    }

    protected void func_230450_a_(MatrixStack pMatrixStack, float pPartialTick, int pMouseX, int pMouseY) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(INFUSER_LOCATION);
        int i = (this.field_230708_k_ - this.field_146999_f) / 2;
        int j = (this.field_230709_l_ - this.field_147000_g) / 2;
        this.func_238474_b_(pMatrixStack, i, j, 0, 0, this.field_146999_f, this.field_147000_g);
        this.searchBox.func_230430_a_(pMatrixStack, pMouseX, pMouseY, pPartialTick);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(INFUSER_LOCATION);
        int sliderX = this.field_147003_i + 197 - 2;
        int sliderY = this.field_147009_r + 17 - 2;
        int sliderRange = sliderY + 72 + 2 + 2;
        this.func_238474_b_(pMatrixStack, sliderX, sliderY + (int)((float)(sliderRange - sliderY - 18) * this.scrollOffs), 220, 54 + (this.scrollingList.canScroll() ? 18 : 0), 18, 18);
    }

    private class EnchantmentListEntry
    implements INestedGuiEventHandler {
        private final ITextComponent UNKNOWN_ENCHANT_COMPONENT = new TranslationTextComponent("gui.enchantinginfuser.tooltip.unknown_enchantment").func_240699_a_(TextFormatting.GRAY);
        private final ITextComponent LOW_POWER_COMPONENT = new TranslationTextComponent("gui.enchantinginfuser.tooltip.low_power").func_240699_a_(TextFormatting.GRAY);
        private final Enchantment enchantment;
        private final int maxLevel;
        private final int requiredPower;
        private final Button decrButton;
        private final Button incrButton;
        private int level;
        private ScrollingList list;
        @Nullable
        private IGuiEventListener focused;
        private boolean dragging;
        private Set<Enchantment> incompatible = Sets.newHashSet();

        public EnchantmentListEntry(Enchantment enchantment, int level) {
            this.enchantment = enchantment;
            Pair<Optional<Integer>, Integer> maxLevelResult = ((InfuserMenu)InfuserScreen.this.field_147002_h).getMaxLevel(enchantment);
            this.maxLevel = (Integer)maxLevelResult.getSecond();
            this.requiredPower = ((Optional)maxLevelResult.getFirst()).orElse(-1);
            this.level = level;
            this.decrButton = new IconButton(0, 0, 18, 18, 220, 0, INFUSER_LOCATION, button -> {
                do {
                    int newLevel;
                    if ((newLevel = ((InfuserMenu)InfuserScreen.this.field_147002_h).clickEnchantmentButton(this.enchantment, false)) == -1) {
                        return;
                    }
                    this.level = newLevel;
                    EnchantingInfuser.NETWORK.sendToServer((Message)new C2SAddEnchantLevelMessage(((InfuserMenu)((InfuserScreen)InfuserScreen.this).field_147002_h).field_75152_c, this.enchantment, false));
                    this.updateButtons();
                    this.list.markOthersIncompatible();
                } while (button.field_230693_o_ && button.field_230694_p_ && Screen.func_231173_s_());
            }){

                @Override
                public void func_230431_b_(MatrixStack poseStack, int mouseX, int mouseY, float partialTicks) {
                    if (this.field_230693_o_ && Screen.func_231173_s_()) {
                        RenderSystem.enableDepthTest();
                        InfuserScreen.this.field_230706_i_.func_110434_K().func_110577_a(this.resourceLocation);
                        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)this.field_230695_q_);
                        int index = this.func_230989_a_(this.func_230449_g_());
                        1.func_238463_a_((MatrixStack)poseStack, (int)(this.field_230690_l_ + 2), (int)this.field_230691_m_, (float)this.xTexStart, (float)(this.yTexStart + index * this.yDiffTex), (int)this.field_230688_j_, (int)this.field_230689_k_, (int)this.textureWidth, (int)this.textureHeight);
                        1.func_238463_a_((MatrixStack)poseStack, (int)(this.field_230690_l_ - 4), (int)this.field_230691_m_, (float)this.xTexStart, (float)(this.yTexStart + index * this.yDiffTex), (int)this.field_230688_j_, (int)this.field_230689_k_, (int)this.textureWidth, (int)this.textureHeight);
                        if (this.func_230449_g_()) {
                            this.func_230443_a_(poseStack, mouseX, mouseY);
                        }
                    } else {
                        super.func_230431_b_(poseStack, mouseX, mouseY, partialTicks);
                    }
                }
            };
            this.incrButton = new IconButton(0, 0, 18, 18, 238, 0, INFUSER_LOCATION, button -> {
                do {
                    int newLevel;
                    if ((newLevel = ((InfuserMenu)InfuserScreen.this.field_147002_h).clickEnchantmentButton(this.enchantment, true)) == -1) {
                        return;
                    }
                    this.level = newLevel;
                    EnchantingInfuser.NETWORK.sendToServer((Message)new C2SAddEnchantLevelMessage(((InfuserMenu)((InfuserScreen)InfuserScreen.this).field_147002_h).field_75152_c, this.enchantment, true));
                    this.updateButtons();
                    this.list.markOthersIncompatible();
                } while (button.field_230693_o_ && button.field_230694_p_ && Screen.func_231173_s_());
            }, (button, matrixStack, mouseX, mouseY) -> {
                if (this.level >= this.maxLevel && !this.isObfuscated()) {
                    InfuserScreen.this.setActiveTooltip(this.getLowPowerComponent(this.LOW_POWER_COMPONENT));
                }
            }){

                @Override
                public void func_230431_b_(MatrixStack poseStack, int mouseX, int mouseY, float partialTicks) {
                    if (this.field_230693_o_ && Screen.func_231173_s_()) {
                        RenderSystem.enableDepthTest();
                        InfuserScreen.this.field_230706_i_.func_110434_K().func_110577_a(this.resourceLocation);
                        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)this.field_230695_q_);
                        int index = this.func_230989_a_(this.func_230449_g_());
                        2.func_238463_a_((MatrixStack)poseStack, (int)(this.field_230690_l_ - 2), (int)this.field_230691_m_, (float)this.xTexStart, (float)(this.yTexStart + index * this.yDiffTex), (int)this.field_230688_j_, (int)this.field_230689_k_, (int)this.textureWidth, (int)this.textureHeight);
                        2.func_238463_a_((MatrixStack)poseStack, (int)(this.field_230690_l_ + 4), (int)this.field_230691_m_, (float)this.xTexStart, (float)(this.yTexStart + index * this.yDiffTex), (int)this.field_230688_j_, (int)this.field_230689_k_, (int)this.textureWidth, (int)this.textureHeight);
                        if (this.func_230449_g_()) {
                            this.func_230443_a_(poseStack, mouseX, mouseY);
                        }
                    } else {
                        super.func_230431_b_(poseStack, mouseX, mouseY, partialTicks);
                    }
                }
            };
            this.updateButtons();
        }

        private List<IReorderingProcessor> getLowPowerComponent(ITextComponent component) {
            ArrayList list = Lists.newArrayList();
            list.add(new TranslationTextComponent("gui.enchantinginfuser.tooltip.required_enchanting_power", new Object[]{new StringTextComponent(String.valueOf(((InfuserMenu)InfuserScreen.this.field_147002_h).getCurrentPower())).func_240699_a_(TextFormatting.RED), new StringTextComponent(String.valueOf(this.requiredPower))}).func_241878_f());
            list.addAll(InfuserScreen.this.field_230712_o_.func_238425_b_((ITextProperties)component, 175));
            return list;
        }

        public void setList(ScrollingList list) {
            this.list = list;
        }

        public void markIncompatible(Collection<EnchantmentListEntry> incompatibleList) {
            this.incompatible = incompatibleList.stream().map(e -> e.enchantment).collect(Collectors.toSet());
            boolean compatible = incompatibleList.isEmpty();
            if (!compatible) {
                this.level = 0;
            }
            this.updateButtons();
            this.decrButton.field_230693_o_ = compatible;
            this.incrButton.field_230693_o_ &= compatible;
        }

        private void updateButtons() {
            this.decrButton.field_230694_p_ = this.level > 0;
            this.incrButton.field_230694_p_ = this.level < this.enchantment.func_77325_b();
            this.incrButton.field_230693_o_ = this.level < this.maxLevel;
        }

        public boolean isActive() {
            return this.level > 0;
        }

        public boolean isIncompatible() {
            return !this.incompatible.isEmpty();
        }

        public boolean isObfuscated() {
            return this.maxLevel == 0;
        }

        private int getYImage() {
            return this.isIncompatible() || this.isObfuscated() ? 0 : (this.isActive() ? 2 : 1);
        }

        public boolean isIncompatibleWith(EnchantmentListEntry other) {
            if (other == this) {
                return false;
            }
            return (this.isActive() || other.isActive()) && !this.enchantment.func_191560_c(other.enchantment);
        }

        public void render(MatrixStack poseStack, int leftPos, int topPos, int width, int height, int mouseX, int mouseY, float partialTicks) {
            InfuserScreen.this.field_230706_i_.func_110434_K().func_110577_a(INFUSER_LOCATION);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            InfuserScreen.this.func_238474_b_(poseStack, leftPos + 18, topPos, 0, 185 + this.getYImage() * 18, 126, 18);
            IReorderingProcessor formattedCharSequence = this.getRenderingName(this.enchantment, width);
            this.drawCenteredString(poseStack, InfuserScreen.this.field_230712_o_, formattedCharSequence, leftPos + width / 2, topPos + 5, this.isIncompatible() || this.isObfuscated() ? 6839882 : -1);
            if (mouseX >= leftPos + 18 && mouseX < leftPos + 18 + 126 && mouseY >= topPos && mouseY < topPos + 18) {
                this.handleTooltip(this.enchantment);
            }
            this.decrButton.field_230690_l_ = leftPos;
            this.decrButton.field_230691_m_ = topPos;
            this.decrButton.func_230430_a_(poseStack, mouseX, mouseY, partialTicks);
            this.incrButton.field_230690_l_ = leftPos + width - 18;
            this.incrButton.field_230691_m_ = topPos;
            this.incrButton.func_230430_a_(poseStack, mouseX, mouseY, partialTicks);
        }

        public void drawCenteredString(MatrixStack pPoseStack, FontRenderer pFont, IReorderingProcessor pText, int pX, int pY, int pColor) {
            pFont.func_238407_a_(pPoseStack, pText, (float)(pX - pFont.func_243245_a(pText) / 2), (float)pY, pColor);
        }

        private IReorderingProcessor getRenderingName(Enchantment enchantment, int maxWidth) {
            IReorderingProcessor formattedCharSequence = null;
            if (this.isObfuscated()) {
                EnchantmentNameParts.func_178176_a().func_148335_a((long)(InfuserScreen.this.enchantmentSeed + ((ForgeRegistry)ForgeRegistries.ENCHANTMENTS).getID((IForgeRegistryEntry)enchantment)));
                ITextProperties formattedtext = EnchantmentNameParts.func_178176_a().func_238816_a_(InfuserScreen.this.field_230712_o_, (int)((float)maxWidth * 0.72f));
                List list = InfuserScreen.this.field_230712_o_.func_238425_b_(formattedtext, (int)((float)maxWidth * 0.72f));
                if (!list.isEmpty()) {
                    formattedCharSequence = (IReorderingProcessor)list.get(0);
                }
            }
            if (formattedCharSequence == null) {
                TranslationTextComponent component = new TranslationTextComponent(enchantment.func_77320_a());
                if (this.isActive()) {
                    component.func_240702_b_(" ").func_230529_a_((ITextComponent)new TranslationTextComponent("enchantment.level." + this.level));
                }
                formattedCharSequence = component.func_241878_f();
            }
            return formattedCharSequence;
        }

        private void handleTooltip(Enchantment enchantment) {
            if (this.isObfuscated()) {
                InfuserScreen.this.setActiveTooltip(this.getLowPowerComponent(this.UNKNOWN_ENCHANT_COMPONENT));
            } else if (this.isIncompatible()) {
                TranslationTextComponent incompatibleComponent = new TranslationTextComponent("gui.enchantinginfuser.tooltip.incompatible", new Object[]{this.incompatible.stream().map(e -> new TranslationTextComponent(e.func_77320_a())).reduce((o1, o2) -> o1.func_240702_b_(", ").func_230529_a_((ITextComponent)o2)).orElse((IFormattableTextComponent)new StringTextComponent("")).func_240699_a_(TextFormatting.GRAY)});
                InfuserScreen.this.setActiveTooltip(InfuserScreen.this.field_230712_o_.func_238425_b_((ITextProperties)incompatibleComponent, 175));
            } else {
                ArrayList list = Lists.newArrayList();
                if (LanguageMap.func_74808_a().func_230506_b_(enchantment.func_77320_a() + ".desc")) {
                    list.addAll(InfuserScreen.this.field_230712_o_.func_238425_b_((ITextProperties)new TranslationTextComponent(enchantment.func_77320_a() + ".desc").func_240699_a_(TextFormatting.GRAY), 175));
                } else if (LanguageMap.func_74808_a().func_230506_b_(enchantment.func_77320_a() + ".description")) {
                    list.addAll(InfuserScreen.this.field_230712_o_.func_238425_b_((ITextProperties)new TranslationTextComponent(enchantment.func_77320_a() + ".description").func_240699_a_(TextFormatting.GRAY), 175));
                }
                if (!list.isEmpty()) {
                    TranslationTextComponent levelsComponent = new TranslationTextComponent("enchantment.level." + enchantment.func_77319_d());
                    if (enchantment.func_77319_d() != enchantment.func_77325_b()) {
                        levelsComponent.func_240702_b_("-").func_230529_a_((ITextComponent)new TranslationTextComponent("enchantment.level." + enchantment.func_77325_b()));
                    }
                    IFormattableTextComponent wrappedComponent = new StringTextComponent("(").func_230529_a_((ITextComponent)levelsComponent).func_240702_b_(")").func_240699_a_(TextFormatting.GRAY);
                    list.add(0, new TranslationTextComponent(enchantment.func_77320_a()).func_240702_b_(" ").func_230529_a_((ITextComponent)wrappedComponent).func_241878_f());
                    InfuserScreen.this.setActiveTooltip(list);
                }
            }
        }

        public boolean func_231047_b_(double pMouseX, double pMouseY) {
            return Objects.equals(this.list.getEntryAtPosition(pMouseX, pMouseY), this);
        }

        public List<? extends IGuiEventListener> func_231039_at__() {
            return ImmutableList.of((Object)this.decrButton, (Object)this.incrButton);
        }

        public boolean func_231041_ay__() {
            return this.dragging;
        }

        public void func_231037_b__(boolean pDragging) {
            this.dragging = pDragging;
        }

        public void func_231035_a_(@Nullable IGuiEventListener pListener) {
            this.focused = pListener;
        }

        @Nullable
        public IGuiEventListener func_241217_q_() {
            return this.focused;
        }
    }

    private class ScrollingList
    extends FocusableGui
    implements IRenderable {
        private final List<EnchantmentListEntry> children = Lists.newArrayList();
        private final int posX;
        private final int posY;
        private final int itemWidth;
        private final int itemHeight;
        private final int length;
        private int scrollPosition;

        public ScrollingList(int posX, int posY, int itemWidth, int itemHeight, int length) {
            this.posX = posX;
            this.posY = posY;
            this.itemWidth = itemWidth;
            this.itemHeight = itemHeight;
            this.length = length;
        }

        public void scrollTo(float pos) {
            if (pos < 0.0f || pos > 1.0f) {
                throw new IllegalArgumentException("pos must be of interval 0 to 1");
            }
            this.scrollPosition = this.canScroll() ? Math.round((float)(this.getItemCount() - this.length) * pos) : 0;
        }

        public boolean canScroll() {
            return this.getItemCount() > this.length;
        }

        protected final void clearEntries() {
            this.children.clear();
        }

        protected void addEntry(EnchantmentListEntry pEntry) {
            this.children.add(pEntry);
            pEntry.setList(this);
            this.markOthersIncompatible();
        }

        protected int getItemCount() {
            return this.children.size();
        }

        public void markOthersIncompatible() {
            List activeEnchants = this.children.stream().filter(EnchantmentListEntry::isActive).collect(Collectors.toList());
            for (EnchantmentListEntry entry : this.children) {
                if (entry.isActive()) continue;
                entry.markIncompatible(activeEnchants.stream().filter(e -> e.isIncompatibleWith(entry)).collect(Collectors.toSet()));
            }
        }

        @Nullable
        protected final EnchantmentListEntry getEntryAtPosition(double mouseX, double mouseY) {
            if (this.func_231047_b_(mouseX, mouseY)) {
                int index = this.scrollPosition + (int)((mouseY - (double)this.posY) / (double)this.itemHeight);
                return index < this.children.size() ? this.children.get(index) : null;
            }
            return null;
        }

        public boolean func_231047_b_(double mouseX, double mouseY) {
            return mouseX >= (double)this.posX && mouseX < (double)(this.posX + this.itemWidth) && mouseY >= (double)this.posY && mouseY < (double)(this.posY + this.itemHeight * this.length);
        }

        public boolean func_231044_a_(double mouseX, double mouseY, int button) {
            if (!this.func_231047_b_(mouseX, mouseY)) {
                return false;
            }
            EnchantmentListEntry entry = this.getEntryAtPosition(mouseX, mouseY);
            if (entry != null && entry.func_231044_a_(mouseX, mouseY, button)) {
                this.func_231035_a_((IGuiEventListener)entry);
                this.func_231037_b__(true);
                return true;
            }
            return false;
        }

        public boolean func_231048_c_(double pMouseX, double pMouseY, int pButton) {
            if (this.func_241217_q_() != null) {
                this.func_241217_q_().func_231048_c_(pMouseX, pMouseY, pButton);
            }
            return false;
        }

        public List<EnchantmentListEntry> func_231039_at__() {
            return this.children;
        }

        public void func_230430_a_(MatrixStack poseStack, int mouseX, int mouseY, float partialTick) {
            for (int i = 0; i < Math.min(this.length, this.getItemCount()); ++i) {
                this.children.get(this.scrollPosition + i).render(poseStack, this.posX, this.posY + this.itemHeight * i, this.itemWidth, this.itemHeight, mouseX, mouseY, partialTick);
            }
        }
    }
}

