/*
 * Decompiled with CFR 0.152.
 */
package fuzs.enchantinginfuser.network.message;

import com.google.common.collect.Lists;
import fuzs.enchantinginfuser.client.gui.screens.inventory.InfuserScreen;
import fuzs.enchantinginfuser.world.inventory.InfuserMenu;
import fuzs.puzzleslib.network.v2.message.Message;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class S2CCompatibleEnchantsMessage
implements Message {
    private int containerId;
    private List<Enchantment> enchantments;

    public S2CCompatibleEnchantsMessage() {
    }

    public S2CCompatibleEnchantsMessage(int containerId, List<Enchantment> enchantments) {
        this.containerId = containerId;
        this.enchantments = enchantments;
    }

    public void write(PacketBuffer buf) {
        buf.writeByte(this.containerId);
        buf.writeInt(this.enchantments.size());
        for (Enchantment enchantment : this.enchantments) {
            buf.writeInt(((ForgeRegistry)ForgeRegistries.ENCHANTMENTS).getID((IForgeRegistryEntry)enchantment));
        }
    }

    public void read(PacketBuffer buf) {
        this.containerId = buf.readByte();
        int size = buf.readInt();
        ArrayList enchantments = Lists.newArrayListWithCapacity((int)size);
        for (int i = 0; i < size; ++i) {
            enchantments.add(((ForgeRegistry)ForgeRegistries.ENCHANTMENTS).getValue(buf.readInt()));
        }
        this.enchantments = enchantments;
    }

    public CompatibleEnchantsHandler makeHandler() {
        return new CompatibleEnchantsHandler();
    }

    private static class CompatibleEnchantsHandler
    extends Message.PacketHandler<S2CCompatibleEnchantsMessage> {
        private CompatibleEnchantsHandler() {
        }

        public void handle(S2CCompatibleEnchantsMessage packet, PlayerEntity player, Object gameInstance) {
            if (player.field_71070_bA.field_75152_c == packet.containerId && player.field_71070_bA instanceof InfuserMenu) {
                ((InfuserMenu)player.field_71070_bA).setEnchantments(packet.enchantments);
                if (((Minecraft)gameInstance).field_71462_r instanceof InfuserScreen) {
                    ((InfuserScreen)((Minecraft)gameInstance).field_71462_r).refreshSearchResults();
                }
            }
        }
    }
}

