/*
 * Decompiled with CFR 0.152.
 */
package fuzs.enchantinginfuser.world.inventory;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import fuzs.enchantinginfuser.EnchantingInfuser;
import fuzs.enchantinginfuser.config.ServerConfig;
import fuzs.enchantinginfuser.network.message.S2CCompatibleEnchantsMessage;
import fuzs.enchantinginfuser.registry.ModRegistry;
import fuzs.enchantinginfuser.world.level.block.InfuserBlock;
import fuzs.puzzleslib.network.v2.message.Message;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.BookItem;
import net.minecraft.item.EnchantedBookItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.stats.Stats;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.IntReferenceHolder;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class InfuserMenu
extends Container
implements IContainerListener {
    private static final ResourceLocation[] TEXTURE_EMPTY_SLOTS = new ResourceLocation[]{PlayerContainer.field_226619_g_, PlayerContainer.field_226618_f_, PlayerContainer.field_226617_e_, PlayerContainer.field_226616_d_};
    private static final EquipmentSlotType[] SLOT_IDS = new EquipmentSlotType[]{EquipmentSlotType.HEAD, EquipmentSlotType.CHEST, EquipmentSlotType.LEGS, EquipmentSlotType.FEET};
    private final IInventory enchantSlots;
    private final IWorldPosCallable levelAccess;
    private final PlayerEntity player;
    private InfuserBlock.InfuserType infuserType;
    private final IntReferenceHolder enchantingPower = IntReferenceHolder.func_221492_a();
    private final IntReferenceHolder enchantingCost = IntReferenceHolder.func_221492_a();
    private Map<Enchantment, Integer> enchantmentsToLevel;

    public InfuserMenu(int id, PlayerInventory playerInventory) {
        this(id, playerInventory, (IInventory)new Inventory(1), IWorldPosCallable.field_221489_a, InfuserBlock.InfuserType.NORMAL);
    }

    public InfuserMenu(int id, final PlayerInventory inventory, IInventory container, IWorldPosCallable levelAccess, InfuserBlock.InfuserType type) {
        super(ModRegistry.INFUSING_MENU_TYPE, id);
        this.enchantSlots = container;
        this.levelAccess = levelAccess;
        this.player = inventory.field_70458_d;
        this.infuserType = type;
        this.func_75146_a(new Slot(container, 0, 8, 34){

            public boolean func_75214_a(ItemStack stack) {
                return stack.func_77956_u() || stack.func_77973_b() instanceof BookItem && !this.func_75216_d();
            }

            public int func_75219_a() {
                return 1;
            }
        });
        for (int k = 0; k < 4; ++k) {
            final EquipmentSlotType equipmentslot = SLOT_IDS[k];
            this.func_75146_a(new Slot((IInventory)inventory, 39 - k, 8 + 188 * (k / 2), 103 + k % 2 * 18){

                public int func_75219_a() {
                    return 1;
                }

                public boolean func_75214_a(ItemStack p_39746_) {
                    return p_39746_.canEquip(equipmentslot, (Entity)inventory.field_70458_d);
                }

                public boolean func_82869_a(PlayerEntity p_39744_) {
                    ItemStack itemstack = this.func_75211_c();
                    return (itemstack.func_190926_b() || p_39744_.func_184812_l_() || !EnchantmentHelper.func_190938_b((ItemStack)itemstack)) && super.func_82869_a(p_39744_);
                }

                public Pair<ResourceLocation, ResourceLocation> func_225517_c_() {
                    return Pair.of((Object)PlayerContainer.field_226615_c_, (Object)TEXTURE_EMPTY_SLOTS[equipmentslot.func_188454_b()]);
                }
            });
        }
        for (int l = 0; l < 3; ++l) {
            for (int j1 = 0; j1 < 9; ++j1) {
                this.func_75146_a(new Slot((IInventory)inventory, j1 + (l + 1) * 9, 30 + j1 * 18, 103 + l * 18));
            }
        }
        for (int i1 = 0; i1 < 9; ++i1) {
            this.func_75146_a(new Slot((IInventory)inventory, i1, 30 + i1 * 18, 161));
        }
        this.func_75146_a(new Slot((IInventory)inventory, 40, 8, 161){

            public Pair<ResourceLocation, ResourceLocation> func_225517_c_() {
                return Pair.of((Object)PlayerContainer.field_226615_c_, (Object)PlayerContainer.field_226620_h_);
            }
        });
        this.func_216958_a(this.enchantingPower);
        this.func_216958_a(this.enchantingCost);
        this.func_75132_a(this);
    }

    public boolean func_75145_c(PlayerEntity pPlayer) {
        return this.enchantSlots.func_70300_a(pPlayer);
    }

    public void func_75130_a(IInventory pInventory) {
        if (pInventory == this.enchantSlots) {
            this.enchantingCost.func_221494_a(0);
            ItemStack itemstack = pInventory.func_70301_a(0);
            if (!itemstack.func_190926_b() && itemstack.func_77956_u()) {
                this.levelAccess.func_221486_a((level, pos) -> {
                    this.setEnchantingPower((World)level, (BlockPos)pos);
                    List<Enchantment> availableEnchantments = InfuserMenu.getAvailableEnchantments(itemstack, ((ServerConfig)EnchantingInfuser.CONFIG.server()).types.treasure, ((ServerConfig)EnchantingInfuser.CONFIG.server()).types.undiscoverable, ((ServerConfig)EnchantingInfuser.CONFIG.server()).types.curses);
                    this.setEnchantments(availableEnchantments);
                });
            } else {
                this.setEnchantments(Lists.newArrayList());
            }
        }
    }

    public void func_71111_a(Container abstractContainerMenu, int i, ItemStack itemStack) {
        if (abstractContainerMenu == this) {
            this.levelAccess.func_221486_a((level, pos) -> {
                if (i == 0) {
                    this.func_75130_a(this.enchantSlots);
                }
            });
        }
    }

    public int setEnchantingPower(World level, BlockPos pos) {
        int power = this.getAvailablePower(level, pos);
        this.enchantingPower.func_221494_a(power);
        return power;
    }

    public void setEnchantingPower(int power) {
        this.enchantingPower.func_221494_a(power);
    }

    public void func_71110_a(Container pContainerToSend, NonNullList<ItemStack> pItemsList) {
    }

    public void func_71112_a(Container pContainer, int pVarToUpdate, int pNewValue) {
    }

    private int getAvailablePower(World world, BlockPos pos) {
        int power = 0;
        for (int k = -1; k <= 1; ++k) {
            for (int l = -1; l <= 1; ++l) {
                if (k == 0 && l == 0 || !InfuserMenu.isBlockEmpty(world, pos.func_177982_a(l, 0, k)) || !InfuserMenu.isBlockEmpty(world, pos.func_177982_a(l, 1, k))) continue;
                power = (int)((float)power + this.getBlockPower(world, pos.func_177982_a(l * 2, 0, k * 2)));
                power = (int)((float)power + this.getBlockPower(world, pos.func_177982_a(l * 2, 1, k * 2)));
                if (l == 0 || k == 0) continue;
                power = (int)((float)power + this.getBlockPower(world, pos.func_177982_a(l * 2, 0, k)));
                power = (int)((float)power + this.getBlockPower(world, pos.func_177982_a(l * 2, 1, k)));
                power = (int)((float)power + this.getBlockPower(world, pos.func_177982_a(l, 0, k * 2)));
                power = (int)((float)power + this.getBlockPower(world, pos.func_177982_a(l, 1, k * 2)));
            }
        }
        return power;
    }

    private float getBlockPower(World world, BlockPos pos) {
        return world.func_180495_p(pos).getEnchantPowerBonus((IWorldReader)world, pos);
    }

    public int clickEnchantmentButton(Enchantment enchantment, boolean increase) {
        boolean incompatible = this.enchantmentsToLevel.entrySet().stream().filter(e -> (Integer)e.getValue() > 0).map(Map.Entry::getKey).filter(e -> e != enchantment).anyMatch(e -> !e.func_191560_c(enchantment));
        if (incompatible) {
            EnchantingInfuser.LOGGER.warn("trying to add incompatible enchantment");
            return -1;
        }
        int level = this.enchantmentsToLevel.get(enchantment) + (increase ? 1 : -1);
        if (level != MathHelper.func_76125_a((int)level, (int)0, (int)enchantment.func_77325_b())) {
            EnchantingInfuser.LOGGER.warn("trying change enchantment level beyond bounds");
            return -1;
        }
        if (level > (Integer)this.getMaxLevel(enchantment).getSecond()) {
            EnchantingInfuser.LOGGER.warn("trying change enchantment level beyond max allowed level");
            return -1;
        }
        this.enchantmentsToLevel.put(enchantment, level);
        this.enchantingCost.func_221494_a(this.getScaledCosts());
        return level;
    }

    public boolean func_75140_a(PlayerEntity player, int id) {
        if (id != 0) {
            return false;
        }
        ItemStack itemstack = this.enchantSlots.func_70301_a(0);
        int cost = this.getScaledCosts();
        if (itemstack.func_190926_b() || cost <= 0 || player.field_71068_ca < cost && !player.field_71075_bZ.field_75098_d) {
            return false;
        }
        this.levelAccess.func_221486_a((level, pos) -> {
            ItemStack itemstack2 = itemstack;
            if (!this.enchantmentsToLevel.isEmpty()) {
                player.func_192024_a(itemstack, cost);
                boolean isBook = itemstack.func_77973_b() instanceof BookItem;
                if (isBook) {
                    itemstack2 = new ItemStack((IItemProvider)Items.field_151134_bR);
                    CompoundNBT compoundtag = itemstack.func_77978_p();
                    if (compoundtag != null) {
                        itemstack2.func_77982_d(compoundtag.func_74737_b());
                    }
                    this.enchantSlots.func_70299_a(0, itemstack2);
                }
                for (Map.Entry<Enchantment, Integer> entry : this.enchantmentsToLevel.entrySet()) {
                    if (entry.getValue() <= 0) continue;
                    if (isBook) {
                        EnchantedBookItem.func_92115_a((ItemStack)itemstack2, (EnchantmentData)new EnchantmentData(entry.getKey(), entry.getValue().intValue()));
                        continue;
                    }
                    itemstack2.func_77966_a(entry.getKey(), entry.getValue().intValue());
                }
                player.func_195066_a(Stats.field_188091_Y);
                if (player instanceof ServerPlayerEntity) {
                    CriteriaTriggers.field_192129_i.func_192190_a((ServerPlayerEntity)player, itemstack2, cost);
                }
                this.enchantSlots.func_70296_d();
                this.func_75130_a(this.enchantSlots);
                level.func_184133_a(null, pos, SoundEvents.field_190021_aL, SoundCategory.BLOCKS, 1.0f, level.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
        });
        return true;
    }

    public Pair<Optional<Integer>, Integer> getMaxLevel(Enchantment enchantment) {
        int maxPower;
        int currentPower = this.getCurrentPower();
        Pair<Optional<Integer>, Integer> maxLevelSpecial = this.getSpecialMaxLevel(enchantment, currentPower, maxPower = this.infuserType.isAdvanced() ? ((ServerConfig)EnchantingInfuser.CONFIG.server()).maximumPowerAdvanced : ((ServerConfig)EnchantingInfuser.CONFIG.server()).maximumPowerNormal);
        if (maxLevelSpecial != null) {
            return maxLevelSpecial;
        }
        int minPowerByRarity = this.getMinPowerByRarity(enchantment, maxPower);
        if (currentPower < minPowerByRarity) {
            return Pair.of(Optional.of(minPowerByRarity), (Object)0);
        }
        int levelRange = (int)Math.round((double)maxPower * ((ServerConfig)EnchantingInfuser.CONFIG.server()).power.levelMultiplier);
        int totalLevels = enchantment.func_77325_b() - enchantment.func_77319_d();
        int levelPercentile = totalLevels > 0 ? levelRange / totalLevels : 0;
        for (int i = 0; i <= totalLevels; ++i) {
            int nextPower = Math.min(maxPower, minPowerByRarity + i * levelPercentile);
            if (currentPower >= nextPower) continue;
            return Pair.of(Optional.of(nextPower), (Object)(enchantment.func_77319_d() + i - 1));
        }
        return Pair.of(Optional.empty(), (Object)enchantment.func_77325_b());
    }

    private Pair<Optional<Integer>, Integer> getSpecialMaxLevel(Enchantment enchantment, int currentPower, int maxPower) {
        double multiplier = -1.0;
        if (enchantment.func_190936_d()) {
            multiplier = ((ServerConfig)EnchantingInfuser.CONFIG.server()).power.curseMultiplier;
        } else if (!enchantment.func_230310_i_()) {
            multiplier = ((ServerConfig)EnchantingInfuser.CONFIG.server()).power.undiscoverableMultiplier;
        } else if (enchantment.func_185261_e()) {
            multiplier = ((ServerConfig)EnchantingInfuser.CONFIG.server()).power.treasureMultiplier;
        }
        if (multiplier != -1.0) {
            int nextPower = (int)Math.round((double)maxPower * multiplier);
            return currentPower < nextPower ? Pair.of(Optional.of(nextPower), (Object)0) : Pair.of(Optional.empty(), (Object)enchantment.func_77325_b());
        }
        return null;
    }

    private int getMinPowerByRarity(Enchantment enchantment, int maxPower) {
        double rarityMultiplier;
        switch (enchantment.func_77324_c()) {
            case COMMON: {
                rarityMultiplier = ((ServerConfig)EnchantingInfuser.CONFIG.server()).power.commonMultiplier;
                break;
            }
            case UNCOMMON: {
                rarityMultiplier = ((ServerConfig)EnchantingInfuser.CONFIG.server()).power.uncommonMultiplier;
                break;
            }
            case RARE: {
                rarityMultiplier = ((ServerConfig)EnchantingInfuser.CONFIG.server()).power.rareMultiplier;
                break;
            }
            case VERY_RARE: {
                rarityMultiplier = ((ServerConfig)EnchantingInfuser.CONFIG.server()).power.veryRareMultiplier;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return (int)Math.round((double)maxPower * rarityMultiplier);
    }

    private int getScaledCosts() {
        int maxCost;
        double totalCosts = this.getTotalCosts();
        int n = maxCost = this.infuserType.isAdvanced() ? ((ServerConfig)EnchantingInfuser.CONFIG.server()).costs.maximumCostAdvanced : ((ServerConfig)EnchantingInfuser.CONFIG.server()).costs.maximumCostNormal;
        if (totalCosts > (double)maxCost && !(this.enchantSlots.func_70301_a(0).func_77973_b() instanceof BookItem)) {
            double ratio = (double)maxCost / totalCosts;
            int minCosts = this.enchantmentsToLevel.values().stream().mapToInt(Integer::intValue).sum();
            return Math.max((int)Math.round((double)this.getAllCosts() * ratio), minCosts);
        }
        return this.getAllCosts();
    }

    public void setType(InfuserBlock.InfuserType type) {
        this.infuserType = type;
    }

    private int getTotalCosts() {
        HashMap map = Maps.newHashMap();
        for (Enchantment enchantment : this.enchantmentsToLevel.keySet()) {
            if (((ServerConfig)EnchantingInfuser.CONFIG.server()).costs.vanillaCostOnly && !ForgeRegistries.ENCHANTMENTS.getKey((IForgeRegistryEntry)enchantment).func_110624_b().equals("minecraft")) continue;
            Pair pair2 = Pair.of((Object)enchantment.func_77324_c(), (Object)enchantment.func_77325_b());
            Optional<Map.Entry> any = map.entrySet().stream().filter(e -> !((Enchantment)e.getKey()).func_191560_c(enchantment)).findAny();
            if (any.isPresent()) {
                Map.Entry enchantmentData = any.get();
                Pair pair1 = (Pair)enchantmentData.getValue();
                map.put(enchantmentData.getKey(), this.compareEnchantmentData((Pair<Enchantment.Rarity, Integer>)pair1, (Pair<Enchantment.Rarity, Integer>)pair2));
                continue;
            }
            map.put(enchantment, pair2);
        }
        return map.values().stream().mapToInt(e -> this.getCostByRarity((Enchantment.Rarity)e.getFirst()) * (Integer)e.getSecond()).sum();
    }

    private Pair<Enchantment.Rarity, Integer> compareEnchantmentData(Pair<Enchantment.Rarity, Integer> pair1, Pair<Enchantment.Rarity, Integer> pair2) {
        int cost1 = this.getCostByRarity((Enchantment.Rarity)pair1.getFirst()) * (Integer)pair1.getSecond();
        int cost2 = this.getCostByRarity((Enchantment.Rarity)pair2.getFirst()) * (Integer)pair2.getSecond();
        return cost2 > cost1 ? pair2 : pair1;
    }

    private int getAllCosts() {
        return this.enchantmentsToLevel.entrySet().stream().filter(entry -> (Integer)entry.getValue() > 0).mapToInt(entry -> this.getCostByRarity((Enchantment)entry.getKey()) * (Integer)entry.getValue()).sum();
    }

    private int getCostByRarity(Enchantment enchantment) {
        int cost = this.getCostByRarity(enchantment.func_77324_c());
        if (((ServerConfig)EnchantingInfuser.CONFIG.server()).costs.doubleUniques && (enchantment.func_185261_e() || !enchantment.func_230310_i_()) && !enchantment.func_190936_d()) {
            cost *= 2;
        }
        return cost;
    }

    private int getCostByRarity(Enchantment.Rarity rarity) {
        switch (rarity) {
            case COMMON: {
                return ((ServerConfig)EnchantingInfuser.CONFIG.server()).costs.commonCost;
            }
            case UNCOMMON: {
                return ((ServerConfig)EnchantingInfuser.CONFIG.server()).costs.uncommonCost;
            }
            case RARE: {
                return ((ServerConfig)EnchantingInfuser.CONFIG.server()).costs.rareCost;
            }
            case VERY_RARE: {
                return ((ServerConfig)EnchantingInfuser.CONFIG.server()).costs.veryRareCost;
            }
        }
        throw new IllegalArgumentException();
    }

    public ItemStack func_82846_b(PlayerEntity pPlayer, int pIndex) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(pIndex);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            EquipmentSlotType equipmentslot = MobEntity.func_184640_d((ItemStack)itemstack);
            if (pIndex == 0) {
                if (equipmentslot.func_188453_a() == EquipmentSlotType.Group.ARMOR && !((Slot)this.field_75151_b.get(4 - equipmentslot.func_188454_b())).func_75216_d()) {
                    int i = 4 - equipmentslot.func_188454_b();
                    if (!this.func_75135_a(itemstack1, i, i + 1, false)) {
                        slot.func_190901_a(pPlayer, itemstack1);
                        return ItemStack.field_190927_a;
                    }
                } else if (equipmentslot == EquipmentSlotType.OFFHAND && !((Slot)this.field_75151_b.get(41)).func_75216_d() && !this.func_75135_a(itemstack1, 41, 42, false)) {
                    slot.func_190901_a(pPlayer, itemstack1);
                    return ItemStack.field_190927_a;
                }
                if (!this.func_75135_a(itemstack1, 5, 41, true)) {
                    slot.func_190901_a(pPlayer, itemstack1);
                    return ItemStack.field_190927_a;
                }
            } else if (itemstack1.func_77956_u() || itemstack1.func_77973_b() instanceof BookItem) {
                if (((Slot)this.field_75151_b.get(0)).func_75216_d()) {
                    return ItemStack.field_190927_a;
                }
                ItemStack itemstack2 = itemstack1.func_77946_l();
                itemstack2.func_190920_e(1);
                itemstack1.func_190918_g(1);
                ((Slot)this.field_75151_b.get(0)).func_75215_d(itemstack2);
            }
            if (itemstack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (itemstack1.func_190916_E() == itemstack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(pPlayer, itemstack1);
        }
        return itemstack;
    }

    public int getCurrentPower() {
        return this.enchantingPower.func_221495_b();
    }

    public int getCost() {
        return this.enchantingCost.func_221495_b();
    }

    public boolean canEnchant(PlayerEntity player) {
        int cost = this.getCost();
        return cost > 0 && (player.field_71068_ca >= cost || player.field_71075_bZ.field_75098_d);
    }

    public Stream<Map.Entry<Enchantment, Integer>> getValidEnchantments() {
        return this.enchantmentsToLevel.entrySet().stream().filter(e -> (Integer)e.getValue() > 0);
    }

    public List<Map.Entry<Enchantment, Integer>> getSortedEntries() {
        return this.enchantmentsToLevel.entrySet().stream().sorted(Comparator.comparingInt(e -> ((Enchantment)e.getKey()).func_77324_c().ordinal()).thenComparing(e -> new TranslationTextComponent(((Enchantment)e.getKey()).func_77320_a()).getString())).collect(Collectors.toList());
    }

    public void setEnchantments(List<Enchantment> enchantments) {
        this.enchantmentsToLevel = enchantments.stream().collect(Collectors.toMap(Function.identity(), enchantment -> 0));
        this.levelAccess.func_221486_a((level, blockPos) -> EnchantingInfuser.NETWORK.sendTo((Message)new S2CCompatibleEnchantsMessage(this.field_75152_c, enchantments), (ServerPlayerEntity)this.player));
    }

    public static List<Enchantment> getAvailableEnchantments(ItemStack stack, boolean allowTreasure, boolean allowUndiscoverable, boolean allowCurse) {
        ArrayList list = Lists.newArrayList();
        boolean isBook = stack.func_77973_b() instanceof BookItem;
        for (Enchantment enchantment : ForgeRegistries.ENCHANTMENTS) {
            if (!enchantment.canApplyAtEnchantingTable(stack) && (!isBook || !enchantment.isAllowedOnBooks()) || (!enchantment.func_230310_i_() ? !allowUndiscoverable : (enchantment.func_190936_d() ? !allowCurse : enchantment.func_185261_e() && !allowTreasure))) continue;
            list.add(enchantment);
        }
        return list;
    }

    public static boolean isBlockEmpty(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_196952_d((IBlockReader)world, pos).func_197766_b();
    }
}

