/*
 * Decompiled with CFR 0.152.
 */
package com.erfurt.magicaljewelry.data.client;

import com.erfurt.magicaljewelry.init.ItemInit;
import com.erfurt.magicaljewelry.util.config.MagicalJewelryConfigBuilder;
import com.erfurt.magicaljewelry.util.enums.JewelRarity;
import java.util.function.Supplier;
import net.minecraft.data.DataGenerator;
import net.minecraftforge.common.data.LanguageProvider;

public class ModLangProvider
extends LanguageProvider {
    public ModLangProvider(DataGenerator gen) {
        super(gen, "magicaljewelry", "en_us");
    }

    protected void addTranslations() {
        this.addItem((Supplier)ItemInit.GOLD_AMULET, "Gold Amulet");
        this.addItem((Supplier)ItemInit.SILVER_AMULET, "Silver Amulet");
        this.addItem((Supplier)ItemInit.GOLD_RING, "Gold Ring");
        this.addItem((Supplier)ItemInit.SILVER_RING, "Silver Ring");
        this.addItem((Supplier)ItemInit.GOLD_BRACELET, "Gold Bracelet");
        this.addItem((Supplier)ItemInit.SILVER_BRACELET, "Silver Bracelet");
        this.addItem((Supplier)ItemInit.THE_ONE_RING, "The One Ring");
        this.add("item.magicaljewelry.tooltip.creative", "This item have no effects or attributes attached to it, and therefore does nothing! This item can't be upgraded!");
        this.add(this.rarity(JewelRarity.UNCOMMON), "Uncommon");
        this.add(this.rarity(JewelRarity.RARE), "Rare");
        this.add(this.rarity(JewelRarity.EPIC), "Epic");
        this.add(this.rarity(JewelRarity.LEGENDARY), "Legendary");
        this.add(this.jewelGiveFailureCommand("exist"), "Item '%s' does not exist?");
        this.add(this.jewelGiveFailureCommand("item"), "Item '%s' is not valid!");
        this.add(this.jewelGiveFailureCommand("rarity"), "Rarity '%s' is not valid!");
        this.add(this.jewelTestLootCommand("settings"), "Rarity Drop Setting for %s");
        this.add(this.jewelTestLootCommand("type.hostile"), "Hostile mobs");
        this.add(this.jewelTestLootCommand("type.boss"), "Boss mobs");
        this.add(this.jewelTestLootCommand("type.chest"), "Chests");
        this.add(this.jewelTestLootCommand("droprate"), "Default drop rate: %s");
        this.add(this.jewelTestLootCommand("dropratewith"), "Default drop rate with %s: %s");
        this.add(this.jewelTestLootCommand("onerarity"), "The only rarity that can drop is: %s");
        this.add(this.jewelTestLootCommand("config1"), "Config option %s is set to %s");
        this.add(this.jewelTestLootCommand("config2"), "Config option %s and %s are both set to %s");
        this.add(this.jewelTestLootCommand("failure"), "Loot Table '%s' is not valid for testing!");
        this.add(MagicalJewelryConfigBuilder.translatable(MagicalJewelryConfigBuilder.UNCOMMON_AMOUNT), "Uncommon effect amount");
        this.add(MagicalJewelryConfigBuilder.translatable(MagicalJewelryConfigBuilder.RARE_AMOUNT), "Rare effect amount");
        this.add(MagicalJewelryConfigBuilder.translatable(MagicalJewelryConfigBuilder.EPIC_AMOUNT), "Epic effect amount");
        this.add(MagicalJewelryConfigBuilder.translatable(MagicalJewelryConfigBuilder.LEGENDARY_AMOUNT), "Legendary effect amount");
        this.add(MagicalJewelryConfigBuilder.translatable(MagicalJewelryConfigBuilder.MAX_EFFECT_LEVEL), "Max stacked effect level");
        this.add(MagicalJewelryConfigBuilder.translatable(MagicalJewelryConfigBuilder.EPIC_LEGENDARY_ATTRIBUTES), "Epic and Legendary have attributes");
        this.add(MagicalJewelryConfigBuilder.translatable(MagicalJewelryConfigBuilder.LEGENDARY_EFFECTS), "Legendary have special effects");
        this.add(MagicalJewelryConfigBuilder.translatable(MagicalJewelryConfigBuilder.REGENERATION_COMBINABLE), "Regeneration is combinable");
        this.add(MagicalJewelryConfigBuilder.translatable(MagicalJewelryConfigBuilder.DURABILITY), "Jewels have durability");
        this.add(MagicalJewelryConfigBuilder.translatable(MagicalJewelryConfigBuilder.UNCOMMON_DURABILITY), "Uncommon durability amount");
        this.add(MagicalJewelryConfigBuilder.translatable(MagicalJewelryConfigBuilder.RARE_DURABILITY), "Rare durability amount");
        this.add(MagicalJewelryConfigBuilder.translatable(MagicalJewelryConfigBuilder.EPIC_DURABILITY), "Epic durability amount");
        this.add(MagicalJewelryConfigBuilder.translatable(MagicalJewelryConfigBuilder.RARITY_TOOLTIPS), "Rarity displayed in tooltip");
        this.add(MagicalJewelryConfigBuilder.translatable(MagicalJewelryConfigBuilder.RARITY_NAME), "Rarity displayed in name");
        this.add(MagicalJewelryConfigBuilder.translatable(MagicalJewelryConfigBuilder.EFFECT_ICON_DISABLED), "Effect icons are disabled");
        this.add(MagicalJewelryConfigBuilder.translatable(MagicalJewelryConfigBuilder.RARE_DROP), "Rare rarity drop rate");
        this.add(MagicalJewelryConfigBuilder.translatable(MagicalJewelryConfigBuilder.EPIC_DROP), "Epic rarity drop rate");
        this.add(MagicalJewelryConfigBuilder.translatable(MagicalJewelryConfigBuilder.LEGENDARY_DROP), "Legendary rarity drop rate");
        this.add(MagicalJewelryConfigBuilder.translatable(MagicalJewelryConfigBuilder.ONE_RARITY_DROP), "Only one rarity drops");
        this.add(MagicalJewelryConfigBuilder.translatable(MagicalJewelryConfigBuilder.RARITY_TO_DROP), "What rarity should drop");
        this.add(MagicalJewelryConfigBuilder.translatable(MagicalJewelryConfigBuilder.LEGENDARY_UPGRADE_ONLY), "Legendary rarity is upgrade only");
        this.add(MagicalJewelryConfigBuilder.translatable(MagicalJewelryConfigBuilder.UPGRADE_DISABLE), "Upgrading is disabled");
        this.add(MagicalJewelryConfigBuilder.translatable(MagicalJewelryConfigBuilder.DROP_IN_CHESTS), "Jewels in chests");
        this.add("itemGroup.magicaljewelryGroup", "Magical Jewelry");
    }

    private String rarity(JewelRarity rarity) {
        return "rarity.magicaljewelry." + rarity.getName();
    }

    private String jewelGiveFailureCommand(String type) {
        return "commands.magicaljewelry.jewelGive.failure." + type;
    }

    private String jewelTestLootCommand(String type) {
        return "commands.magicaljewelry.jewelTestLoot." + type;
    }
}

