/*
 * Decompiled with CFR 0.152.
 */
package com.erfurt.magicaljewelry.data.recipes;

import com.erfurt.magicaljewelry.MagicalJewelry;
import com.erfurt.magicaljewelry.recipes.JewelUpgradeRecipe;
import com.erfurt.magicaljewelry.recipes.UpgradeNBTIngredient;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;

public class JewelUpgradeRecipeBuilder {
    private final Item addition;
    private final Item jewel;
    private final String rarityIn;
    private final String rarityOut;
    private final IRecipeSerializer<?> serializer;

    public JewelUpgradeRecipeBuilder(IRecipeSerializer<?> serializer, Item addition, Item jewel, String rarityIn, String rarityOut) {
        this.serializer = serializer;
        this.addition = addition;
        this.jewel = jewel;
        this.rarityIn = rarityIn;
        this.rarityOut = rarityOut;
    }

    public static JewelUpgradeRecipeBuilder jewelUpgradeRecipe(Item jewel, Item addition, String rarityIn, String rarityOut) {
        return new JewelUpgradeRecipeBuilder(JewelUpgradeRecipe.Serializer.SERIALIZER, addition, jewel, rarityIn, rarityOut);
    }

    public void build(Consumer<IFinishedRecipe> consumer, String id) {
        this.build(consumer, MagicalJewelry.getId(id + "_upgrade_" + this.rarityIn + "_to_" + this.rarityOut));
    }

    public void build(Consumer<IFinishedRecipe> recipe, ResourceLocation id) {
        recipe.accept(new Result(id, this.serializer, this.addition, this.jewel, this.rarityIn, this.rarityOut));
    }

    public static class Result
    implements IFinishedRecipe {
        private final ResourceLocation id;
        private final Ingredient addition;
        private final Item jewel;
        private final String rarityIn;
        private final String rarityOut;
        private final IRecipeSerializer<?> serializer;

        public Result(ResourceLocation id, IRecipeSerializer<?> serializer, Item addition, Item jewel, String rarityIn, String rarityOut) {
            this.id = id;
            this.serializer = serializer;
            this.addition = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{addition});
            this.jewel = jewel;
            this.rarityIn = rarityIn;
            this.rarityOut = rarityOut;
        }

        public void func_218610_a(JsonObject json) {
            JsonObject jsonBase = new JsonObject();
            jsonBase.addProperty("type", CraftingHelper.getID((IIngredientSerializer)UpgradeNBTIngredient.Serializer.INSTANCE).toString());
            jsonBase.addProperty("item", this.jewel.getRegistryName().toString());
            JsonObject jsonNBTin = new JsonObject();
            jsonNBTin.addProperty("Rarity", this.rarityIn);
            jsonBase.add("nbt", (JsonElement)jsonNBTin);
            json.add("base", (JsonElement)jsonBase);
            json.add("addition", this.addition.func_200304_c());
            JsonObject jsonResult = new JsonObject();
            jsonResult.addProperty("item", this.jewel.getRegistryName().toString());
            JsonObject jsonNBTout = new JsonObject();
            jsonNBTout.addProperty("Rarity", this.rarityOut);
            jsonResult.add("nbt", (JsonElement)jsonNBTout);
            json.add("result", (JsonElement)jsonResult);
        }

        public ResourceLocation func_200442_b() {
            return this.id;
        }

        public IRecipeSerializer<?> func_218609_c() {
            return this.serializer;
        }

        @Nullable
        public JsonObject func_200440_c() {
            return null;
        }

        @Nullable
        public ResourceLocation func_200443_d() {
            return null;
        }
    }
}

