/*
 * Decompiled with CFR 0.152.
 */
package com.erfurt.magicaljewelry.recipes;

import com.erfurt.magicaljewelry.MagicalJewelry;
import com.erfurt.magicaljewelry.objects.items.JewelItem;
import com.erfurt.magicaljewelry.recipes.UpgradeNBTIngredient;
import com.erfurt.magicaljewelry.util.config.MagicalJewelryConfigBuilder;
import com.erfurt.magicaljewelry.util.enums.JewelRarity;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.block.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.item.crafting.SmithingRecipe;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class JewelUpgradeRecipe
extends SmithingRecipe
implements IRecipe<IInventory> {
    private final Ingredient base;
    private final Ingredient addition;
    private final ItemStack result;
    private final ResourceLocation recipeId;

    public JewelUpgradeRecipe(ResourceLocation recipeId, Ingredient base, Ingredient addition, ItemStack result) {
        super(recipeId, base, addition, result);
        this.recipeId = recipeId;
        this.base = base;
        this.addition = addition;
        this.result = result;
    }

    public boolean func_77569_a(IInventory inv, World worldIn) {
        ItemStack stackIn = inv.func_70301_a(0);
        ItemStack stackOut = this.result.func_77946_l();
        boolean rarityInCheck = false;
        if (stackIn.func_77973_b() instanceof JewelItem) {
            rarityInCheck = JewelRarity.containsRarity(JewelItem.getJewelRarity(stackIn));
        }
        boolean rarityOutCheck = false;
        if (stackOut.func_77973_b() instanceof JewelItem) {
            rarityOutCheck = JewelRarity.containsRarity(JewelItem.getJewelRarity(stackOut));
        }
        boolean upgradeEnabled = (Boolean)MagicalJewelryConfigBuilder.JEWEL_UPGRADE_DISABLE.get();
        return this.base.test(stackIn) && this.addition.test(inv.func_70301_a(1)) && rarityInCheck && rarityOutCheck && !upgradeEnabled;
    }

    public ItemStack func_77572_b(IInventory inv) {
        ItemStack stackOut = this.result.func_77946_l();
        ItemStack stackIn = inv.func_70301_a(0);
        if (stackIn.func_77942_o() && stackOut.func_77942_o()) {
            String rarityOut = stackOut.func_77978_p().func_74781_a("Rarity").func_150285_a_();
            CompoundNBT nbtIn = stackIn.func_77978_p();
            stackOut.func_77982_d(nbtIn.func_74737_b());
            JewelItem.setJewelRarity(stackOut, rarityOut);
            stackOut.func_77978_p().func_82580_o("Damage");
        }
        return stackOut;
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= 2;
    }

    public ItemStack func_77571_b() {
        return this.result;
    }

    public ItemStack func_222128_h() {
        return new ItemStack((IItemProvider)Blocks.field_222429_lR);
    }

    public ResourceLocation func_199560_c() {
        return this.recipeId;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return Serializer.SERIALIZER;
    }

    public IRecipeType<?> func_222127_g() {
        return IRecipeType.field_234827_g_;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<JewelUpgradeRecipe> {
        public static final Serializer SERIALIZER = new Serializer();

        public JewelUpgradeRecipe read(ResourceLocation recipeId, JsonObject json) {
            Ingredient ingredient = UpgradeNBTIngredient.func_199802_a((JsonElement)JSONUtils.func_152754_s((JsonObject)json, (String)"base"));
            Ingredient ingredient1 = Ingredient.func_199802_a((JsonElement)JSONUtils.func_152754_s((JsonObject)json, (String)"addition"));
            ItemStack stackOut = ShapedRecipe.func_199798_a((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"result"));
            return new JewelUpgradeRecipe(recipeId, ingredient, ingredient1, stackOut);
        }

        public JewelUpgradeRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            Ingredient ingredient = UpgradeNBTIngredient.func_199566_b((PacketBuffer)buffer);
            Ingredient ingredient1 = Ingredient.func_199566_b((PacketBuffer)buffer);
            ItemStack stackOut = buffer.func_150791_c();
            return new JewelUpgradeRecipe(recipeId, ingredient, ingredient1, stackOut);
        }

        public void write(PacketBuffer buffer, JewelUpgradeRecipe recipe) {
            recipe.base.func_199564_a(buffer);
            recipe.addition.func_199564_a(buffer);
            buffer.func_150788_a(recipe.result);
        }

        static {
            SERIALIZER.setRegistryName(MagicalJewelry.getId("jewel_upgrade"));
        }
    }
}

