/*
 * Decompiled with CFR 0.152.
 */
package com.erfurt.magicaljewelry.recipes;

import com.erfurt.magicaljewelry.objects.items.JewelItem;
import com.erfurt.magicaljewelry.util.enums.JewelRarity;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;

public class UpgradeNBTIngredient
extends Ingredient {
    private final ItemStack stack;

    protected UpgradeNBTIngredient(ItemStack stack) {
        super(Stream.of(new Ingredient.SingleItemList(stack)));
        this.stack = stack;
    }

    public boolean test(@Nullable ItemStack input) {
        boolean rarityCheckTemp;
        JsonObject json = this.func_200304_c().getAsJsonObject();
        boolean rarityCheck = false;
        if (input != null && input.func_77942_o() && input.func_77973_b() instanceof JewelItem && (rarityCheckTemp = JewelRarity.containsRarity(JewelItem.getJewelRarity(input)))) {
            String rarityTemp = json.get("nbt").getAsString();
            int stringSize = rarityTemp.length();
            String rarity = rarityTemp.substring(1, stringSize - 1);
            rarityCheck = Objects.requireNonNull(input.func_77978_p().func_74781_a("Rarity")).func_150285_a_().equals(rarity);
        }
        return this.stack.func_77973_b() == input.func_77973_b() && rarityCheck;
    }

    public boolean isSimple() {
        return false;
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    public JsonElement func_200304_c() {
        JsonObject json = new JsonObject();
        json.addProperty("type", CraftingHelper.getID((IIngredientSerializer)Serializer.INSTANCE).toString());
        json.addProperty("item", this.stack.func_77973_b().getRegistryName().toString());
        if (this.stack.func_77942_o()) {
            json.addProperty("nbt", this.stack.func_77978_p().func_74781_a("Rarity").toString());
        }
        return json;
    }

    public static class Serializer
    implements IIngredientSerializer<UpgradeNBTIngredient> {
        public static final Serializer INSTANCE = new Serializer();

        public UpgradeNBTIngredient parse(PacketBuffer buffer) {
            return new UpgradeNBTIngredient(buffer.func_150791_c());
        }

        public UpgradeNBTIngredient parse(JsonObject json) {
            return new UpgradeNBTIngredient(CraftingHelper.getItemStack((JsonObject)json, (boolean)true));
        }

        public void write(PacketBuffer buffer, UpgradeNBTIngredient ingredient) {
            buffer.func_150788_a(ingredient.stack);
        }
    }
}

