/*
 * Decompiled with CFR 0.152.
 */
package com.erfurt.magicaljewelry.util;

import java.util.List;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTableManager;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.loot.conditions.RandomChance;
import net.minecraft.loot.conditions.RandomChanceWithLooting;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class LootTableUtil {
    private static List<LootPool> getPools(LootTable table) {
        return (List)ObfuscationReflectionHelper.getPrivateValue(LootTable.class, (Object)table, (String)"field_186466_c");
    }

    private static List<ILootCondition> getLootConditions(LootPool pool) {
        return (List)ObfuscationReflectionHelper.getPrivateValue(LootPool.class, (Object)pool, (String)"field_186454_b");
    }

    private static float getRandomChanceValue(RandomChance condition) {
        return ((Float)ObfuscationReflectionHelper.getPrivateValue(RandomChance.class, (Object)condition, (String)"field_186630_a")).floatValue();
    }

    private static float getRandomChanceWithLootingValue(RandomChanceWithLooting condition) {
        return ((Float)ObfuscationReflectionHelper.getPrivateValue(RandomChanceWithLooting.class, (Object)condition, (String)"field_186627_a")).floatValue();
    }

    private static float getLootingMultiplierValue(RandomChanceWithLooting condition) {
        return ((Float)ObfuscationReflectionHelper.getPrivateValue(RandomChanceWithLooting.class, (Object)condition, (String)"field_186628_b")).floatValue();
    }

    public static float getChance(ResourceLocation resource, MinecraftServer server) {
        float[] chance = new float[]{-0.1f};
        LootTableManager manager = server.func_200249_aQ();
        LootTable table = manager.func_186521_a(resource);
        for (LootPool pool : LootTableUtil.getPools(table)) {
            for (ILootCondition condition : LootTableUtil.getLootConditions(pool)) {
                if (condition instanceof RandomChance) {
                    chance[0] = LootTableUtil.getRandomChanceValue((RandomChance)condition);
                    continue;
                }
                if (!(condition instanceof RandomChanceWithLooting)) continue;
                chance[0] = LootTableUtil.getRandomChanceWithLootingValue((RandomChanceWithLooting)condition);
            }
        }
        return chance[0];
    }

    public static float getLootingMultiplier(ResourceLocation resource, MinecraftServer server) {
        float[] lootingMultiplier = new float[]{-0.1f};
        LootTableManager manager = server.func_200249_aQ();
        LootTable table = manager.func_186521_a(resource);
        for (LootPool pool : LootTableUtil.getPools(table)) {
            for (ILootCondition condition : LootTableUtil.getLootConditions(pool)) {
                if (!(condition instanceof RandomChanceWithLooting)) continue;
                lootingMultiplier[0] = LootTableUtil.getLootingMultiplierValue((RandomChanceWithLooting)condition);
            }
        }
        return lootingMultiplier[0];
    }
}

