/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila;

import mcp.mobius.waila.Waila;
import mcp.mobius.waila.api.impl.DataAccessor;
import mcp.mobius.waila.api.impl.config.PluginConfig;
import mcp.mobius.waila.api.impl.config.WailaConfig;
import mcp.mobius.waila.gui.GuiConfigHome;
import mcp.mobius.waila.overlay.OverlayRenderer;
import mcp.mobius.waila.overlay.WailaTickHandler;
import mcp.mobius.waila.utils.ModIdentification;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ExtensionPoint;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import snownee.jade.JadePlugin;

@Mod.EventBusSubscriber(modid="waila", value={Dist.CLIENT})
public class WailaClient {
    public static KeyBinding openConfig;
    public static KeyBinding showOverlay;
    public static KeyBinding toggleLiquid;
    public static boolean hideModName;

    public static void initClient() {
        ModLoadingContext.get().registerExtensionPoint(ExtensionPoint.CONFIGGUIFACTORY, () -> (minecraft, screen) -> new GuiConfigHome((Screen)screen));
        openConfig = new KeyBinding("key.waila.config", (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.NONE, InputMappings.Type.KEYSYM.func_197944_a(320), "Waila");
        showOverlay = new KeyBinding("key.waila.show_overlay", (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.NONE, InputMappings.Type.KEYSYM.func_197944_a(321), "Waila");
        toggleLiquid = new KeyBinding("key.waila.toggle_liquid", (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.NONE, InputMappings.Type.KEYSYM.func_197944_a(322), "Waila");
        ClientRegistry.registerKeyBinding((KeyBinding)openConfig.getKeyBinding());
        ClientRegistry.registerKeyBinding((KeyBinding)showOverlay.getKeyBinding());
        ClientRegistry.registerKeyBinding((KeyBinding)toggleLiquid.getKeyBinding());
    }

    @SubscribeEvent
    public static void onKeyPressed(InputEvent.KeyInputEvent event) {
        WailaConfig.DisplayMode mode;
        if (openConfig == null || showOverlay == null || toggleLiquid == null) {
            return;
        }
        if (event.getAction() != 1) {
            return;
        }
        if (openConfig.func_151470_d()) {
            Minecraft.func_71410_x().func_147108_a((Screen)new GuiConfigHome(null));
        }
        if (showOverlay.func_151470_d() && (mode = Waila.CONFIG.get().getGeneral().getDisplayMode()) == WailaConfig.DisplayMode.TOGGLE) {
            Waila.CONFIG.get().getGeneral().setDisplayTooltip(!Waila.CONFIG.get().getGeneral().shouldDisplayTooltip());
        }
        if (toggleLiquid.func_151470_d()) {
            Waila.CONFIG.get().getGeneral().setDisplayFluids(!Waila.CONFIG.get().getGeneral().shouldDisplayFluids());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onTooltip(ItemTooltipEvent event) {
        if (hideModName || PluginConfig.INSTANCE.get(JadePlugin.HIDE_ITEM_MOD_NAME, false)) {
            return;
        }
        String name = String.format(Waila.CONFIG.get().getFormatting().getModName(), ModIdentification.getModName(event.getItemStack()));
        event.getToolTip().add(new StringTextComponent(name));
    }

    @SubscribeEvent
    public static void onRenderTick(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            OverlayRenderer.renderOverlay();
        }
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            WailaTickHandler.instance().tickClient();
        }
    }

    @SubscribeEvent
    public static void onPlayerLeave(ClientPlayerNetworkEvent.LoggedOutEvent event) {
        DataAccessor.INSTANCE.serverConnected = false;
    }
}

