/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.network;

import java.util.function.Supplier;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.api.impl.WailaRegistrar;
import mcp.mobius.waila.network.MessageReceiveData;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageRequestTile {
    public static int MAX_DISTANCE_SQR = 900;
    public BlockPos pos;

    public MessageRequestTile(TileEntity tile) {
        this.pos = tile.func_174877_v();
    }

    private MessageRequestTile(BlockPos pos) {
        this.pos = pos;
    }

    public static MessageRequestTile read(PacketBuffer buffer) {
        return new MessageRequestTile(buffer.func_179259_c());
    }

    public static void write(MessageRequestTile message, PacketBuffer buffer) {
        buffer.func_179255_a(message.pos);
    }

    public static class Handler {
        public static void onMessage(MessageRequestTile message, Supplier<NetworkEvent.Context> context) {
            context.get().enqueueWork(() -> {
                ServerPlayerEntity player = ((NetworkEvent.Context)context.get()).getSender();
                World world = player.field_70170_p;
                if (message.pos.func_177951_i((Vector3i)player.func_233580_cy_()) > (double)MAX_DISTANCE_SQR || !world.func_195588_v(message.pos)) {
                    return;
                }
                TileEntity tile = world.func_175625_s(message.pos);
                BlockState state = world.func_180495_p(message.pos);
                if (tile == null) {
                    return;
                }
                CompoundNBT tag = new CompoundNBT();
                if (WailaRegistrar.INSTANCE.hasNBTProviders(tile) || WailaRegistrar.INSTANCE.hasNBTProviders(state.func_177230_c())) {
                    WailaRegistrar.INSTANCE.getNBTProviders(tile).values().forEach(l -> l.forEach(p -> p.appendServerData(tag, player, world, tile)));
                    WailaRegistrar.INSTANCE.getNBTProviders(state.func_177230_c()).values().forEach(l -> l.forEach(p -> p.appendServerData(tag, player, world, tile)));
                } else {
                    tile.func_189515_b(tag);
                }
                tag.func_74768_a("x", message.pos.func_177958_n());
                tag.func_74768_a("y", message.pos.func_177956_o());
                tag.func_74768_a("z", message.pos.func_177952_p());
                tag.func_74778_a("id", tile.func_200662_C().getRegistryName().toString());
                Waila.NETWORK.sendTo((Object)new MessageReceiveData(tag), player.field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
            });
            context.get().setPacketHandled(true);
        }
    }
}

