/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.mana;

import com.hollingsworth.arsnouveau.api.NbtTags;
import com.hollingsworth.arsnouveau.api.mana.IManaTile;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;

public abstract class AbstractManaTile
extends TileEntity
implements IManaTile,
ITickableTileEntity {
    private int mana = 0;
    private int maxMana = 0;

    public AbstractManaTile(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        this.mana = tag.func_74762_e(NbtTags.MANA_TAG);
        this.maxMana = tag.func_74762_e(NbtTags.MAX_MANA_TAG);
        super.func_230337_a_(state, tag);
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag.func_74768_a(NbtTags.MANA_TAG, this.getCurrentMana());
        tag.func_74768_a(NbtTags.MAX_MANA_TAG, this.getMaxMana());
        return super.func_189515_b(tag);
    }

    @Override
    public int setMana(int mana) {
        this.mana = mana;
        if (this.mana > this.getMaxMana()) {
            this.mana = this.getMaxMana();
        }
        if (this.mana < 0) {
            this.mana = 0;
        }
        this.update();
        return this.mana;
    }

    @Override
    public int addMana(int manaToAdd) {
        return this.setMana(this.getCurrentMana() + manaToAdd);
    }

    @Override
    public int getCurrentMana() {
        return this.mana;
    }

    @Override
    public int removeMana(int manaToRemove) {
        this.setMana(this.getCurrentMana() - manaToRemove);
        this.update();
        return this.getCurrentMana();
    }

    @Override
    public void setMaxMana(int max) {
        this.maxMana = max;
        this.update();
    }

    public boolean update() {
        if (this.field_174879_c != null && this.field_145850_b != null) {
            this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 2);
            return true;
        }
        return false;
    }

    @Override
    public int getMaxMana() {
        return this.maxMana;
    }

    @Override
    public boolean canAcceptMana() {
        return this.getCurrentMana() < this.getMaxMana();
    }

    public int manaCanAccept(IManaTile tile) {
        return tile.getMaxMana() - tile.getCurrentMana();
    }

    public int transferMana(IManaTile from, IManaTile to) {
        int transferRate = this.getTransferRate(from, to);
        from.removeMana(transferRate);
        to.addMana(transferRate);
        return transferRate;
    }

    public int getTransferRate(IManaTile from, IManaTile to) {
        return Math.min(Math.min(from.getTransferRate(), from.getCurrentMana()), to.getMaxMana() - to.getCurrentMana());
    }

    public int transferMana(IManaTile from, IManaTile to, int fromTransferRate) {
        int transferRate = this.getTransferRate(from, to, fromTransferRate);
        if (transferRate == 0) {
            return 0;
        }
        from.removeMana(transferRate);
        to.addMana(transferRate);
        return transferRate;
    }

    public int getTransferRate(IManaTile from, IManaTile to, int fromTransferRate) {
        return Math.min(Math.min(fromTransferRate, from.getCurrentMana()), to.getMaxMana() - to.getCurrentMana());
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 3, this.func_189517_E_());
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        super.onDataPacket(net, pkt);
        this.handleUpdateTag(this.field_145850_b.func_180495_p(this.field_174879_c), pkt.func_148857_g());
    }
}

