/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.ritual;

import com.hollingsworth.arsnouveau.api.ritual.AbstractRitual;
import com.hollingsworth.arsnouveau.api.ritual.IRitualCaster;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;

public class RitualCaster
implements IRitualCaster {
    List<String> ritualIDs = new ArrayList<String>();
    String selectedRitualID = "";
    public ItemStack stack;

    private RitualCaster(ItemStack stack) {
        this.stack = stack;
    }

    @Override
    public List<String> getUnlockedRitualIDs() {
        return this.ritualIDs;
    }

    @Override
    public void unlockRitual(String ritualID) {
        if (!this.ritualIDs.contains(ritualID)) {
            this.ritualIDs.add(ritualID);
        }
        this.write(this.stack);
    }

    @Override
    public String getSelectedRitual() {
        return this.stack.func_196082_o().func_74779_i("selected");
    }

    @Override
    public void setRitual(AbstractRitual ritual) {
        this.setRitual(ritual.getID());
    }

    @Override
    public void setRitual(String ritualID) {
        this.selectedRitualID = ritualID;
        this.write(this.stack);
    }

    public static RitualCaster deserialize(ItemStack stack) {
        RitualCaster instance = new RitualCaster(stack);
        CompoundNBT tag = stack.func_196082_o();
        ArrayList<String> rituals = new ArrayList<String>();
        for (int i = 0; i < tag.func_74762_e("numrituals"); ++i) {
            if (!tag.func_74764_b("ritual_" + i)) continue;
            rituals.add(tag.func_74779_i("ritual_" + i));
        }
        instance.ritualIDs = rituals;
        instance.selectedRitualID = tag.func_74779_i("selected");
        return instance;
    }

    public void write(ItemStack stack) {
        CompoundNBT tag = stack.func_196082_o();
        tag.func_74778_a("selected", this.selectedRitualID);
        tag.func_74768_a("numrituals", this.ritualIDs.size());
        for (int i = 0; i < this.ritualIDs.size(); ++i) {
            tag.func_74778_a("ritual_" + i, this.ritualIDs.get(i));
        }
        stack.func_77982_d(tag);
    }
}

