/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.gui.book;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.api.ArsNouveauAPI;
import com.hollingsworth.arsnouveau.api.familiar.FamiliarCap;
import com.hollingsworth.arsnouveau.api.familiar.IFamiliarCap;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractCastMethod;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.ISpellValidator;
import com.hollingsworth.arsnouveau.api.spell.SpellValidationError;
import com.hollingsworth.arsnouveau.api.util.SpellRecipeUtil;
import com.hollingsworth.arsnouveau.client.gui.NoShadowTextField;
import com.hollingsworth.arsnouveau.client.gui.book.BaseBook;
import com.hollingsworth.arsnouveau.client.gui.book.GuiColorScreen;
import com.hollingsworth.arsnouveau.client.gui.book.GuiFamiliarScreen;
import com.hollingsworth.arsnouveau.client.gui.buttons.CraftingButton;
import com.hollingsworth.arsnouveau.client.gui.buttons.CreateSpellButton;
import com.hollingsworth.arsnouveau.client.gui.buttons.GlyphButton;
import com.hollingsworth.arsnouveau.client.gui.buttons.GuiImageButton;
import com.hollingsworth.arsnouveau.client.gui.buttons.GuiSpellSlot;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.common.items.SpellBook;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketUpdateSpellbook;
import com.hollingsworth.arsnouveau.common.spell.validation.CombinedSpellValidator;
import com.hollingsworth.arsnouveau.common.spell.validation.GlyphMaxTierValidator;
import com.hollingsworth.arsnouveau.setup.ItemsRegistry;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.button.ChangePageButton;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import vazkii.patchouli.api.PatchouliAPI;

public class GuiSpellBook
extends BaseBook {
    public int numLinks = 10;
    public SpellBook spellBook;
    public ArsNouveauAPI api;
    private int selected_cast_slot = 1;
    public TextFieldWidget spell_name;
    public NoShadowTextField searchBar;
    public CompoundNBT spell_book_tag;
    public GuiSpellSlot selected_slot;
    public int max_spell_tier;
    List<CraftingButton> craftingCells = new ArrayList<CraftingButton>();
    public List<AbstractSpellPart> unlockedSpells;
    public List<AbstractSpellPart> castMethods;
    public List<AbstractSpellPart> augments;
    public List<AbstractSpellPart> displayedGlyphs;
    public List<AbstractSpellPart> allEffects;
    public List<GlyphButton> castMethodButtons;
    public List<GlyphButton> augmentButtons;
    public List<GlyphButton> effectButtons;
    public List<GlyphButton> glyphButtons = new ArrayList<GlyphButton>();
    public int page = 0;
    public List<SpellValidationError> validationErrors;
    ChangePageButton nextButton;
    ChangePageButton previousButton;
    ISpellValidator spellValidator;
    public String previousString = "";
    int formTextRow = 0;
    int augmentTextRow = 0;
    int effectTextRow = 0;

    public GuiSpellBook(CompoundNBT tag, int tier, String unlockedSpells) {
        this.api = ArsNouveauAPI.getInstance();
        this.max_spell_tier = tier;
        this.spell_book_tag = tag;
        this.unlockedSpells = SpellRecipeUtil.getSpellsFromString(unlockedSpells);
        this.castMethods = new ArrayList<AbstractSpellPart>();
        this.augments = new ArrayList<AbstractSpellPart>();
        this.displayedGlyphs = new ArrayList<AbstractSpellPart>();
        this.allEffects = new ArrayList<AbstractSpellPart>();
        this.displayedGlyphs = this.unlockedSpells;
        this.castMethodButtons = new ArrayList<GlyphButton>();
        this.augmentButtons = new ArrayList<GlyphButton>();
        this.effectButtons = new ArrayList<GlyphButton>();
        this.validationErrors = new LinkedList<SpellValidationError>();
        this.spellValidator = new CombinedSpellValidator(this.api.getSpellCraftingSpellValidator(), new GlyphMaxTierValidator(tier));
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        int selected_slot_ind = SpellBook.getMode(this.spell_book_tag);
        if (selected_slot_ind == 0) {
            selected_slot_ind = 1;
        }
        if (this.craftingCells.isEmpty()) {
            for (int i = 0; i < this.numLinks; ++i) {
                Object icon = null;
                String spell_id = "";
                int offset = i >= 5 ? 14 : 0;
                CraftingButton cell = new CraftingButton(this, this.bookLeft + 19 + 24 * i + offset, this.bookTop + 194 - 47, i, this::onCraftingSlotClick);
                this.func_230480_a_((Widget)cell);
                this.craftingCells.add(cell);
            }
            this.updateCraftingSlots(selected_slot_ind);
        } else {
            for (int a = 0; a < this.craftingCells.size(); ++a) {
                this.func_230480_a_((Widget)this.craftingCells.get(a));
                int offset = a >= 5 ? 14 : 0;
                this.craftingCells.get((int)a).field_230690_l_ = this.bookLeft + 19 + 24 * a + offset;
                this.craftingCells.get((int)a).field_230691_m_ = this.bookTop + 194 - 47;
            }
        }
        this.layoutAllGlyphs(0);
        this.func_230480_a_((Widget)new CreateSpellButton(this, this.bookRight - 71, this.bookBottom - 13, this::onCreateClick));
        this.func_230480_a_((Widget)new GuiImageButton(this.bookRight - 126, this.bookBottom - 13, 0, 0, 41, 12, 41, 12, "textures/gui/clear_icon.png", this::clear));
        this.spell_name = new NoShadowTextField(this.field_230706_i_.field_71466_p, this.bookLeft + 32, this.bookTop + 194 - 11, 88, 12, null, (ITextComponent)new TranslationTextComponent("ars_nouveau.spell_book_gui.spell_name"));
        this.spell_name.func_146185_a(false);
        this.spell_name.func_146193_g(12694931);
        this.searchBar = new NoShadowTextField(this.field_230706_i_.field_71466_p, this.bookRight - 73, this.bookTop + 2, 54, 12, null, (ITextComponent)new TranslationTextComponent("ars_nouveau.spell_book_gui.search"));
        this.searchBar.func_146185_a(false);
        this.searchBar.func_146193_g(12694931);
        this.searchBar.onClear = val -> {
            this.onSearchChanged("");
            return null;
        };
        int mode = SpellBook.getMode(this.spell_book_tag);
        mode = mode == 0 ? 1 : mode;
        this.spell_name.func_146180_a(SpellBook.getSpellName(this.spell_book_tag, mode));
        if (this.spell_name.func_146179_b().isEmpty()) {
            this.spell_name.func_195612_c(new TranslationTextComponent("ars_nouveau.spell_book_gui.spell_name").getString());
        }
        if (this.searchBar.func_146179_b().isEmpty()) {
            this.searchBar.func_195612_c(new TranslationTextComponent("ars_nouveau.spell_book_gui.search").getString());
        }
        this.searchBar.func_212954_a(this::onSearchChanged);
        this.func_230480_a_((Widget)this.spell_name);
        this.func_230480_a_((Widget)this.searchBar);
        for (int i = 1; i <= 10; ++i) {
            GuiSpellSlot slot = new GuiSpellSlot(this, this.bookLeft + 281, this.bookTop + 1 + 15 * i, i);
            if (i == selected_slot_ind) {
                this.selected_slot = slot;
                this.selected_cast_slot = i;
                slot.isSelected = true;
            }
            this.func_230480_a_((Widget)slot);
        }
        this.func_230480_a_((Widget)new GuiImageButton(this.bookLeft - 15, this.bookTop + 22, 0, 0, 23, 20, 23, 20, "textures/gui/worn_book_bookmark.png", this::onDocumentationClick).withTooltip(this, new TranslationTextComponent("ars_nouveau.gui.notebook")));
        this.func_230480_a_((Widget)new GuiImageButton(this.bookLeft - 15, this.bookTop + 46, 0, 0, 23, 20, 23, 20, "textures/gui/color_wheel_bookmark.png", this::onColorClick).withTooltip(this, new TranslationTextComponent("ars_nouveau.gui.color")));
        this.func_230480_a_((Widget)new GuiImageButton(this.bookLeft - 15, this.bookTop + 70, 0, 0, 23, 20, 23, 20, "textures/gui/summon_circle_bookmark.png", this::onFamiliarClick).withTooltip(this, new TranslationTextComponent("ars_nouveau.gui.familiar")));
        this.func_230480_a_((Widget)new GuiImageButton(this.bookLeft - 15, this.bookTop + 94, 0, 0, 23, 20, 23, 20, "textures/gui/discord_tab.png", b -> {
            try {
                Util.func_110647_a().func_195642_a(new URI("https://discord.com/invite/y7TMXZu"));
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }).withTooltip(this, new TranslationTextComponent("ars_nouveau.gui.discord")));
        this.nextButton = (ChangePageButton)this.func_230480_a_((Widget)new ChangePageButton(this.bookRight - 20, this.bookBottom - 10, true, this::onPageIncrease, true));
        this.previousButton = (ChangePageButton)this.func_230480_a_((Widget)new ChangePageButton(this.bookLeft - 5, this.bookBottom - 10, false, this::onPageDec, true));
        this.updateNextPageButtons();
        this.previousButton.field_230693_o_ = false;
        this.previousButton.field_230694_p_ = false;
        this.validate();
    }

    public void resetPageState() {
        this.updateNextPageButtons();
        this.page = 0;
        this.previousButton.field_230693_o_ = false;
        this.previousButton.field_230694_p_ = false;
        this.layoutAllGlyphs(0);
        this.validate();
    }

    public void onSearchChanged(String str) {
        if (str.equals(this.previousString)) {
            return;
        }
        this.previousString = str;
        if (!str.isEmpty()) {
            this.searchBar.func_195612_c("");
            this.displayedGlyphs = new ArrayList<AbstractSpellPart>();
            for (AbstractSpellPart spellPart : this.unlockedSpells) {
                if (!spellPart.getLocaleName().toLowerCase().contains(str.toLowerCase())) continue;
                this.displayedGlyphs.add(spellPart);
            }
            for (Widget w : this.field_230710_m_) {
                AbstractSpellPart part;
                if (!(w instanceof GlyphButton) || ((GlyphButton)w).spell_id == null || (part = this.api.getSpell_map().get(((GlyphButton)w).spell_id)) == null) continue;
                w.field_230694_p_ = part.getLocaleName().toLowerCase().contains(str.toLowerCase());
            }
        } else {
            this.searchBar.func_195612_c(new TranslationTextComponent("ars_nouveau.spell_book_gui.search").getString());
            this.displayedGlyphs = this.unlockedSpells;
            for (Widget w : this.field_230710_m_) {
                if (!(w instanceof GlyphButton)) continue;
                w.field_230694_p_ = true;
            }
        }
        this.resetPageState();
    }

    public void updateNextPageButtons() {
        if (this.displayedGlyphs.size() < 58) {
            this.nextButton.field_230694_p_ = false;
            this.nextButton.field_230693_o_ = false;
        } else {
            this.nextButton.field_230694_p_ = true;
            this.nextButton.field_230693_o_ = true;
        }
    }

    private void layoutAllGlyphs(int page) {
        this.clearButtons(this.glyphButtons);
        this.formTextRow = 0;
        this.augmentTextRow = 0;
        this.effectTextRow = 0;
        int PER_ROW = 6;
        int MAX_ROWS = 6;
        boolean nextPage = false;
        int xStart = nextPage ? this.bookLeft + 154 : this.bookLeft + 20;
        int adjustedRowsPlaced = 0;
        int yStart = this.bookTop + 20;
        boolean foundForms = false;
        boolean foundAugments = false;
        boolean foundEffects = false;
        List sorted = new ArrayList();
        sorted.addAll(this.displayedGlyphs.stream().filter(s -> s instanceof AbstractCastMethod).collect(Collectors.toList()));
        sorted.addAll(this.displayedGlyphs.stream().filter(s -> s instanceof AbstractAugment).collect(Collectors.toList()));
        sorted.addAll(this.displayedGlyphs.stream().filter(s -> s instanceof AbstractEffect).collect(Collectors.toList()));
        int perPage = 58;
        sorted = sorted.subList(perPage * page, Math.min(sorted.size(), perPage * (page + 1)));
        int adjustedXPlaced = 0;
        int totalRowsPlaced = 0;
        int row_offset = page == 0 ? 2 : 0;
        for (int i = 0; i < sorted.size(); ++i) {
            AbstractSpellPart part = (AbstractSpellPart)sorted.get(i);
            if (!foundForms && part instanceof AbstractCastMethod) {
                foundForms = true;
                ++adjustedRowsPlaced;
                this.formTextRow = page != 0 ? 0 : ++totalRowsPlaced;
                adjustedXPlaced = 0;
            }
            if (!foundAugments && part instanceof AbstractAugment) {
                foundAugments = true;
                adjustedRowsPlaced += row_offset;
                this.augmentTextRow = page != 0 ? 0 : (totalRowsPlaced += row_offset) - 1;
                adjustedXPlaced = 0;
            } else if (!foundEffects && part instanceof AbstractEffect) {
                foundEffects = true;
                adjustedRowsPlaced += row_offset;
                this.effectTextRow = page != 0 ? 0 : (totalRowsPlaced += row_offset) - 1;
                adjustedXPlaced = 0;
            } else if (adjustedXPlaced >= 6) {
                ++adjustedRowsPlaced;
                ++totalRowsPlaced;
                adjustedXPlaced = 0;
            }
            if (adjustedRowsPlaced > 6) {
                if (nextPage) break;
                nextPage = true;
                adjustedXPlaced = 0;
                adjustedRowsPlaced = 0;
            }
            int xOffset = 20 * (adjustedXPlaced % 6) + (nextPage ? 134 : 0);
            int yPlace = adjustedRowsPlaced * 18 + yStart;
            GlyphButton cell = new GlyphButton(this, xStart + xOffset, yPlace, false, part.getIcon(), part.tag);
            this.func_230480_a_((Widget)cell);
            this.glyphButtons.add(cell);
            ++adjustedXPlaced;
        }
    }

    public void clearButtons(List<GlyphButton> glyphButtons) {
        for (GlyphButton b : glyphButtons) {
            this.field_230710_m_.remove((Object)b);
            this.field_230705_e_.remove((Object)b);
        }
        glyphButtons.clear();
    }

    public void onPageIncrease(Button button) {
        ++this.page;
        if (this.displayedGlyphs.size() < 58 * (this.page + 1)) {
            this.nextButton.field_230694_p_ = false;
            this.nextButton.field_230693_o_ = false;
        }
        this.previousButton.field_230693_o_ = true;
        this.previousButton.field_230694_p_ = true;
        this.layoutAllGlyphs(this.page);
        this.validate();
    }

    public void onPageDec(Button button) {
        --this.page;
        if (this.page == 0) {
            this.previousButton.field_230693_o_ = false;
            this.previousButton.field_230694_p_ = false;
        }
        if (this.displayedGlyphs.size() > 58 * (this.page + 1)) {
            this.nextButton.field_230694_p_ = true;
            this.nextButton.field_230693_o_ = true;
        }
        this.layoutAllGlyphs(this.page);
        this.validate();
    }

    public void onDocumentationClick(Button button) {
        PatchouliAPI.get().openBookGUI(Registry.field_212630_s.func_177774_c((Object)ItemsRegistry.wornNotebook));
    }

    public void onColorClick(Button button) {
        ParticleColor.IntWrapper color = SpellBook.getSpellColor(this.spell_book_tag, this.selected_cast_slot);
        Minecraft.func_71410_x().func_147108_a((Screen)new GuiColorScreen(color.r, color.g, color.b, this.selected_cast_slot));
    }

    public void onFamiliarClick(Button button) {
        Collection<Object> familiarHolders = new ArrayList();
        IFamiliarCap cap = (IFamiliarCap)FamiliarCap.getFamiliarCap((LivingEntity)ArsNouveau.proxy.getPlayer()).orElse(null);
        if (cap != null) {
            familiarHolders = cap.getUnlockedFamiliars();
        }
        ArrayList finalFamiliarHolders = familiarHolders;
        Minecraft.func_71410_x().func_147108_a((Screen)new GuiFamiliarScreen(this.api, ArsNouveauAPI.getInstance().getFamiliarHolderMap().values().stream().filter(f -> finalFamiliarHolders.contains(f.id)).collect(Collectors.toList())));
    }

    public void onCraftingSlotClick(Button button) {
        ((CraftingButton)button).clear();
        this.validate();
    }

    public void onGlyphClick(Button button) {
        GlyphButton button1 = (GlyphButton)button;
        if (button1.validationErrors.isEmpty()) {
            for (CraftingButton b : this.craftingCells) {
                if (!b.resourceIcon.equals("")) continue;
                b.resourceIcon = button1.resourceIcon;
                b.spellTag = button1.spell_id;
                this.validate();
                return;
            }
        }
    }

    public void onSlotChange(Button button) {
        this.selected_slot.isSelected = false;
        this.selected_slot = (GuiSpellSlot)button;
        this.selected_slot.isSelected = true;
        this.selected_cast_slot = this.selected_slot.slotNum;
        this.updateCraftingSlots(this.selected_cast_slot);
        this.spell_name.func_146180_a(SpellBook.getSpellName(this.spell_book_tag, this.selected_cast_slot));
        this.validate();
    }

    public void updateCraftingSlots(int bookSlot) {
        List<AbstractSpellPart> spell_recipe = this.spell_book_tag != null ? SpellBook.getRecipeFromTag((CompoundNBT)this.spell_book_tag, (int)bookSlot).recipe : null;
        for (int i = 0; i < this.craftingCells.size(); ++i) {
            CraftingButton slot = this.craftingCells.get(i);
            slot.spellTag = "";
            slot.resourceIcon = "";
            if (spell_recipe == null || i >= spell_recipe.size()) continue;
            slot.spellTag = spell_recipe.get(i).getTag();
            slot.resourceIcon = spell_recipe.get(i).getIcon();
        }
    }

    public void clear(Button button) {
        boolean allWereEmpty = true;
        for (CraftingButton slot : this.craftingCells) {
            if (!slot.spellTag.equals("")) {
                allWereEmpty = false;
            }
            slot.clear();
        }
        if (allWereEmpty) {
            this.spell_name.func_146180_a("");
        }
        this.validate();
    }

    public void onCreateClick(Button button) {
        this.validate();
        if (this.validationErrors.isEmpty()) {
            ArrayList<String> ids = new ArrayList<String>();
            for (CraftingButton slot : this.craftingCells) {
                ids.add(slot.spellTag);
            }
            Networking.INSTANCE.sendToServer((Object)new PacketUpdateSpellbook(((Object)ids).toString(), this.selected_cast_slot, this.spell_name.func_146179_b()));
        }
    }

    public static void open(CompoundNBT spell_book_tag, int tier, String unlockedSpells) {
        Minecraft.func_71410_x().func_147108_a((Screen)new GuiSpellBook(spell_book_tag, tier, unlockedSpells));
    }

    @Override
    public void drawBackgroundElements(MatrixStack stack, int mouseX, int mouseY, float partialTicks) {
        super.drawBackgroundElements(stack, mouseX, mouseY, partialTicks);
        if (this.formTextRow >= 1) {
            this.field_230706_i_.field_71466_p.func_238421_b_(stack, new TranslationTextComponent("ars_nouveau.spell_book_gui.form").getString(), this.formTextRow > 6 ? 154.0f : 20.0f, (float)(5 + 18 * (this.formTextRow + (this.formTextRow == 1 ? 0 : 1))), -8355712);
        }
        if (this.effectTextRow >= 1) {
            this.field_230706_i_.field_71466_p.func_238421_b_(stack, new TranslationTextComponent("ars_nouveau.spell_book_gui.effect").getString(), this.effectTextRow > 6 ? 154.0f : 20.0f, (float)(5 + 18 * (this.effectTextRow + 1)), -8355712);
        }
        if (this.augmentTextRow >= 1) {
            this.field_230706_i_.field_71466_p.func_238421_b_(stack, new TranslationTextComponent("ars_nouveau.spell_book_gui.augment").getString(), this.augmentTextRow > 6 ? 154.0f : 20.0f, (float)(5 + 18 * (this.augmentTextRow + 1)), -8355712);
        }
        GuiSpellBook.drawFromTexture(new ResourceLocation("ars_nouveau", "textures/gui/spell_name_paper.png"), 16, 179, 0, 0, 109, 15, 109, 15, stack);
        GuiSpellBook.drawFromTexture(new ResourceLocation("ars_nouveau", "textures/gui/search_paper.png"), 203, 0, 0, 0, 72, 15, 72, 15, stack);
        GuiSpellBook.drawFromTexture(new ResourceLocation("ars_nouveau", "textures/gui/clear_paper.png"), 161, 179, 0, 0, 47, 15, 47, 15, stack);
        GuiSpellBook.drawFromTexture(new ResourceLocation("ars_nouveau", "textures/gui/create_paper.png"), 216, 179, 0, 0, 56, 15, 56, 15, stack);
        if (this.validationErrors.isEmpty()) {
            this.field_230706_i_.field_71466_p.func_243248_b(stack, (ITextComponent)new TranslationTextComponent("ars_nouveau.spell_book_gui.create"), 233.0f, 183.0f, -8355712);
        } else {
            IFormattableTextComponent textComponent = new TranslationTextComponent("ars_nouveau.spell_book_gui.create").func_240700_a_(s -> s.setStrikethrough(Boolean.valueOf(true)).func_240718_a_(Color.func_240745_a_((String)"#FFB2B2")));
            this.field_230706_i_.field_71466_p.func_243248_b(stack, (ITextComponent)textComponent, 233.0f, 183.0f, -8355712);
        }
        this.field_230706_i_.field_71466_p.func_238421_b_(stack, new TranslationTextComponent("ars_nouveau.spell_book_gui.clear").getString(), 177.0f, 183.0f, -8355712);
    }

    private void validate() {
        AbstractList recipe = new LinkedList<AbstractSpellPart>();
        int firstBlankSlot = -1;
        for (int i = 0; i < this.craftingCells.size(); ++i) {
            CraftingButton b = this.craftingCells.get(i);
            b.validationErrors.clear();
            if (b.spellTag.isEmpty()) {
                recipe.add(null);
                if (firstBlankSlot >= 0) continue;
                firstBlankSlot = i;
                continue;
            }
            recipe.add(this.api.getSpell_map().get(b.spellTag));
        }
        List<SpellValidationError> errors = this.spellValidator.validate(recipe);
        for (SpellValidationError ve : errors) {
            if (ve.getPosition() < 0 || ve.getPosition() > this.craftingCells.size()) continue;
            CraftingButton b = this.craftingCells.get(ve.getPosition());
            b.validationErrors.add(ve);
        }
        this.validationErrors = errors;
        if (firstBlankSlot >= 0) {
            recipe = new ArrayList(recipe.subList(0, firstBlankSlot));
        }
        for (GlyphButton button : this.glyphButtons) {
            this.validateGlyphButton(recipe, button);
        }
    }

    private void validateGlyphButton(List<AbstractSpellPart> recipe, GlyphButton glyphButton) {
        glyphButton.validationErrors.clear();
        recipe.add(this.api.getSpell_map().get(glyphButton.spell_id));
        glyphButton.validationErrors.addAll(this.spellValidator.validate(recipe).stream().filter(ve -> ve.getPosition() >= recipe.size() - 1).collect(Collectors.toList()));
        recipe.remove(recipe.size() - 1);
    }

    @Override
    public void func_230430_a_(MatrixStack ms, int mouseX, int mouseY, float partialTicks) {
        super.func_230430_a_(ms, mouseX, mouseY, partialTicks);
        this.spell_name.func_195612_c(this.spell_name.func_146179_b().isEmpty() ? new TranslationTextComponent("ars_nouveau.spell_book_gui.spell_name").getString() : "");
    }
}

