/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.particle;

import com.hollingsworth.arsnouveau.client.particle.ModParticles;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;

public class ColorParticleTypeData
implements IParticleData {
    private ParticleType<ColorParticleTypeData> type;
    public static final Codec<ColorParticleTypeData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("r").forGetter(d -> Float.valueOf(d.color.getRed())), (App)Codec.FLOAT.fieldOf("g").forGetter(d -> Float.valueOf(d.color.getGreen())), (App)Codec.FLOAT.fieldOf("b").forGetter(d -> Float.valueOf(d.color.getBlue())), (App)Codec.BOOL.fieldOf("disableDepthTest").forGetter(d -> d.disableDepthTest)).apply((Applicative)instance, ColorParticleTypeData::new));
    public ParticleColor color;
    public boolean disableDepthTest;
    static final IParticleData.IDeserializer<ColorParticleTypeData> DESERIALIZER = new IParticleData.IDeserializer<ColorParticleTypeData>(){

        public ColorParticleTypeData fromCommand(ParticleType<ColorParticleTypeData> type, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            return new ColorParticleTypeData(type, ParticleColor.deserialize(reader.readString()), reader.readBoolean());
        }

        public ColorParticleTypeData fromNetwork(ParticleType<ColorParticleTypeData> type, PacketBuffer buffer) {
            return new ColorParticleTypeData(type, ParticleColor.deserialize(buffer.func_218666_n()), buffer.readBoolean());
        }
    };

    public ColorParticleTypeData(float r, float g, float b) {
        this.color = new ParticleColor(r, g, b);
        this.type = ModParticles.GLOW_TYPE;
        this.disableDepthTest = false;
    }

    public ColorParticleTypeData(ParticleType<ColorParticleTypeData> particleTypeData, ParticleColor color, boolean disableDepthTest) {
        this.type = particleTypeData;
        this.color = color;
        this.disableDepthTest = disableDepthTest;
    }

    public ColorParticleTypeData(float r, float g, float b, boolean disableDepthTest) {
        this(r, g, b);
        this.disableDepthTest = disableDepthTest;
    }

    public ParticleType<ColorParticleTypeData> func_197554_b() {
        return this.type;
    }

    public void func_197553_a(PacketBuffer packetBuffer) {
        packetBuffer.func_180714_a(this.color.serialize());
    }

    public String func_197555_a() {
        return this.type.getRegistryName().toString() + " " + this.color.serialize();
    }
}

