/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block;

import com.hollingsworth.arsnouveau.api.enchanting_apparatus.IEnchantingRecipe;
import com.hollingsworth.arsnouveau.api.util.ManaUtil;
import com.hollingsworth.arsnouveau.common.block.ArcaneCore;
import com.hollingsworth.arsnouveau.common.block.ModBlock;
import com.hollingsworth.arsnouveau.common.block.tile.EnchantingApparatusTile;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class EnchantingApparatusBlock
extends ModBlock {
    public EnchantingApparatusBlock() {
        super(ModBlock.defaultProperties().func_226896_b_(), "enchanting_apparatus");
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public void func_196270_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity player) {
        super.func_196270_a(state, worldIn, pos, player);
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (world.field_72995_K || handIn != Hand.MAIN_HAND) {
            return ActionResultType.SUCCESS;
        }
        EnchantingApparatusTile tile = (EnchantingApparatusTile)world.func_175625_s(pos);
        if (tile.isCrafting) {
            return ActionResultType.SUCCESS;
        }
        if (!(world.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof ArcaneCore)) {
            PortUtil.sendMessage((Entity)player, (ITextComponent)new TranslationTextComponent("alert.core"));
            return ActionResultType.SUCCESS;
        }
        if (tile.catalystItem == null || tile.catalystItem.func_190926_b()) {
            IEnchantingRecipe recipe = tile.getRecipe(player.func_184614_ca(), player);
            if (recipe == null) {
                PortUtil.sendMessage((Entity)player, (ITextComponent)new TranslationTextComponent("ars_nouveau.apparatus.norecipe"));
            } else if (recipe.consumesMana() && !ManaUtil.hasManaNearby(tile.func_174877_v(), tile.func_145831_w(), 10, recipe.manaCost())) {
                PortUtil.sendMessage((Entity)player, (ITextComponent)new TranslationTextComponent("ars_nouveau.apparatus.nomana"));
            } else if (tile.attemptCraft(player.func_184614_ca(), player)) {
                tile.catalystItem = player.field_71071_by.func_70298_a(player.field_71071_by.field_70461_c, 1);
            }
        } else {
            ItemEntity item = new ItemEntity(world, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), tile.catalystItem);
            world.func_217376_c((Entity)item);
            tile.catalystItem = ItemStack.field_190927_a;
            if (tile.attemptCraft(player.func_184614_ca(), player)) {
                tile.catalystItem = player.field_71071_by.func_70298_a(player.field_71071_by.field_70461_c, 1);
            }
        }
        world.func_184138_a(pos, state, state, 2);
        return ActionResultType.SUCCESS;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return Block.func_208617_a((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    }

    public void func_176208_a(World worldIn, BlockPos pos, BlockState state, PlayerEntity player) {
        super.func_176208_a(worldIn, pos, state, player);
        if (worldIn.func_175625_s(pos) instanceof EnchantingApparatusTile && ((EnchantingApparatusTile)worldIn.func_175625_s((BlockPos)pos)).catalystItem != null) {
            worldIn.func_217376_c((Entity)new ItemEntity(worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), ((EnchantingApparatusTile)worldIn.func_175625_s((BlockPos)pos)).catalystItem));
        }
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new EnchantingApparatusTile();
    }

    public BlockRenderType func_149645_b(BlockState p_149645_1_) {
        return BlockRenderType.ENTITYBLOCK_ANIMATED;
    }
}

