/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block;

import com.hollingsworth.arsnouveau.common.block.ManaBlock;
import com.hollingsworth.arsnouveau.common.block.ModBlock;
import com.hollingsworth.arsnouveau.common.block.tile.ManaJarTile;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class ManaJar
extends ManaBlock {
    public static final Property<Integer> fill = IntegerProperty.func_177719_a((String)"fill", (int)0, (int)11);

    public ManaJar() {
        super(ModBlock.defaultProperties().func_226896_b_(), "mana_jar");
    }

    public ManaJar(AbstractBlock.Properties properties, String registryName) {
        super(properties, registryName);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new ManaJarTile();
    }

    public BlockRenderType func_149645_b(BlockState p_149645_1_) {
        return BlockRenderType.MODEL;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{fill});
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return super.func_196258_a(context);
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState blockState, World worldIn, BlockPos pos) {
        ManaJarTile tile = (ManaJarTile)worldIn.func_175625_s(pos);
        if (tile == null || tile.getCurrentMana() <= 0) {
            return 0;
        }
        int step = (tile.getMaxMana() - 1) / 14;
        return (tile.getCurrentMana() - 1) / step + 1;
    }

    @Override
    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        return super.func_225533_a_(state, worldIn, pos, player, handIn, hit);
    }

    public void func_190948_a(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_190948_a(stack, worldIn, tooltip, flagIn);
        if (stack.func_77978_p() == null) {
            return;
        }
        int mana = stack.func_77978_p().func_74775_l("BlockEntityTag").func_74762_e("mana");
        tooltip.add((ITextComponent)new StringTextComponent(mana * 100 / 10000 + "% full"));
    }
}

