/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block.tile;

import com.hollingsworth.arsnouveau.api.ArsNouveauAPI;
import com.hollingsworth.arsnouveau.api.enchanting_apparatus.IEnchantingRecipe;
import com.hollingsworth.arsnouveau.api.util.ManaUtil;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.block.tile.AnimatedTile;
import com.hollingsworth.arsnouveau.common.block.tile.ArcanePedestalTile;
import com.hollingsworth.arsnouveau.setup.BlockRegistry;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class EnchantingApparatusTile
extends AnimatedTile
implements IInventory {
    private final LazyOptional<IItemHandler> itemHandler = LazyOptional.of(() -> new InvWrapper((IInventory)this));
    public ItemStack catalystItem = ItemStack.field_190927_a;
    public ItemEntity entity;
    public long frames = 0L;
    private int craftingLength = 100;
    public boolean isCrafting;

    public EnchantingApparatusTile() {
        super(BlockRegistry.ENCHANTING_APP_TILE);
        this.counter = 1;
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.isCrafting) {
            if (this.getRecipe(this.catalystItem, null) == null) {
                this.isCrafting = false;
            }
            ++this.counter;
        }
        if (this.counter > this.craftingLength) {
            this.counter = 1;
            if (this.isCrafting) {
                IEnchantingRecipe recipe = this.getRecipe(this.catalystItem, null);
                List<ItemStack> pedestalItems = this.getPedestalItems();
                if (recipe != null) {
                    pedestalItems.forEach(i -> {
                        i = null;
                    });
                    this.catalystItem = recipe.getResult(pedestalItems, this.catalystItem, this);
                    this.clearItems();
                    ParticleUtil.spawnPoof((ServerWorld)this.field_145850_b, this.field_174879_c);
                }
                this.isCrafting = false;
            }
            this.updateBlock();
        }
    }

    public void clearItems() {
        BlockPos.func_218281_b((BlockPos)this.func_174877_v().func_177982_a(3, -3, 3), (BlockPos)this.func_174877_v().func_177982_a(-3, 3, -3)).forEach(blockPos -> {
            if (this.field_145850_b.func_175625_s(blockPos) instanceof ArcanePedestalTile && ((ArcanePedestalTile)this.field_145850_b.func_175625_s((BlockPos)blockPos)).stack != null) {
                ArcanePedestalTile tile = (ArcanePedestalTile)this.field_145850_b.func_175625_s(blockPos);
                tile.stack = tile.stack == null ? ItemStack.field_190927_a : tile.stack.getContainerItem();
                BlockState state = this.field_145850_b.func_180495_p(blockPos);
                this.field_145850_b.func_184138_a(blockPos, state, state, 3);
            }
        });
    }

    public List<BlockPos> pedestalList() {
        ArrayList<BlockPos> posList = new ArrayList<BlockPos>();
        BlockPos.func_218281_b((BlockPos)this.func_174877_v().func_177982_a(3, -3, 3), (BlockPos)this.func_174877_v().func_177982_a(-3, 3, -3)).forEach(blockPos -> {
            if (this.field_145850_b.func_175625_s(blockPos) instanceof ArcanePedestalTile && ((ArcanePedestalTile)this.field_145850_b.func_175625_s((BlockPos)blockPos)).stack != null && !((ArcanePedestalTile)this.field_145850_b.func_175625_s((BlockPos)blockPos)).stack.func_190926_b()) {
                posList.add(blockPos.func_185334_h());
            }
        });
        return posList;
    }

    public List<ItemStack> getPedestalItems() {
        ArrayList<ItemStack> pedestalItems = new ArrayList<ItemStack>();
        BlockPos.func_218281_b((BlockPos)this.func_174877_v().func_177982_a(3, -3, 3), (BlockPos)this.func_174877_v().func_177982_a(-3, 3, -3)).forEach(blockPos -> {
            if (this.field_145850_b.func_175625_s(blockPos) instanceof ArcanePedestalTile && ((ArcanePedestalTile)this.field_145850_b.func_175625_s((BlockPos)blockPos)).stack != null && !((ArcanePedestalTile)this.field_145850_b.func_175625_s((BlockPos)blockPos)).stack.func_190926_b()) {
                pedestalItems.add(((ArcanePedestalTile)this.field_145850_b.func_175625_s((BlockPos)blockPos)).stack);
            }
        });
        return pedestalItems;
    }

    public IEnchantingRecipe getRecipe(ItemStack stack, @Nullable PlayerEntity playerEntity) {
        List<ItemStack> pedestalItems = this.getPedestalItems();
        return ArsNouveauAPI.getInstance().getEnchantingApparatusRecipes(this.field_145850_b).stream().filter(r -> r.isMatch(pedestalItems, stack, this, playerEntity)).findFirst().orElse(null);
    }

    public boolean attemptCraft(ItemStack catalyst, @Nullable PlayerEntity playerEntity) {
        if (this.isCrafting) {
            return false;
        }
        if (!this.craftingPossible(catalyst, playerEntity)) {
            return false;
        }
        IEnchantingRecipe recipe = this.getRecipe(catalyst, playerEntity);
        ManaUtil.takeManaNearbyWithParticles(this.field_174879_c, this.field_145850_b, 10, recipe.manaCost());
        this.isCrafting = true;
        this.updateBlock();
        return true;
    }

    public boolean craftingPossible(ItemStack stack, PlayerEntity playerEntity) {
        if (this.isCrafting || stack.func_190926_b()) {
            return false;
        }
        IEnchantingRecipe recipe = this.getRecipe(stack, playerEntity);
        return recipe != null && (!recipe.consumesMana() || recipe.consumesMana() && ManaUtil.hasManaNearby(this.field_174879_c, this.field_145850_b, 10, recipe.manaCost()));
    }

    @Override
    public void updateBlock() {
        if (this.counter == 0) {
            this.counter = 1;
        }
        BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 2);
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        this.catalystItem = ItemStack.func_199557_a((CompoundNBT)((CompoundNBT)compound.func_74781_a("itemStack")));
        this.isCrafting = compound.func_74767_n("is_crafting");
        this.counter = compound.func_74762_e("counter");
        super.func_230337_a_(state, compound);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        if (this.catalystItem != null) {
            CompoundNBT reagentTag = new CompoundNBT();
            this.catalystItem.func_77955_b(reagentTag);
            compound.func_218657_a("itemStack", (INBT)reagentTag);
        }
        compound.func_74757_a("is_crafting", this.isCrafting);
        compound.func_74768_a("counter", this.counter);
        return super.func_189515_b(compound);
    }

    @Override
    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 3, this.func_189517_E_());
    }

    @Override
    public CompoundNBT func_189517_E_() {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74768_a("counter", this.counter);
        tag.func_74757_a("is_crafting", this.isCrafting);
        return this.func_189515_b(tag);
    }

    @Override
    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        super.onDataPacket(net, pkt);
        this.handleUpdateTag(this.field_145850_b.func_180495_p(this.field_174879_c), pkt.func_148857_g());
    }

    public int func_70302_i_() {
        return 1;
    }

    public boolean func_191420_l() {
        return this.catalystItem.func_190926_b();
    }

    public ItemStack func_70301_a(int index) {
        if (this.isCrafting) {
            return ItemStack.field_190927_a;
        }
        return this.catalystItem;
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        if (this.isCrafting || stack.func_190926_b()) {
            return false;
        }
        return this.catalystItem.func_190926_b() && this.craftingPossible(stack, null);
    }

    public ItemStack func_70298_a(int index, int count) {
        if (this.isCrafting) {
            return ItemStack.field_190927_a;
        }
        ItemStack stack = this.catalystItem.func_77946_l().func_77979_a(count);
        this.catalystItem.func_190918_g(count);
        this.updateBlock();
        return stack;
    }

    public ItemStack func_70304_b(int index) {
        if (this.isCrafting) {
            return ItemStack.field_190927_a;
        }
        return this.catalystItem;
    }

    public void func_70299_a(int index, ItemStack stack) {
        if (this.isCrafting) {
            return;
        }
        this.catalystItem = stack;
        this.updateBlock();
        this.attemptCraft(this.catalystItem, null);
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_70300_a(PlayerEntity player) {
        return false;
    }

    public void func_174888_l() {
        this.catalystItem = ItemStack.field_190927_a;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.itemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    protected void invalidateCaps() {
        this.itemHandler.invalidate();
        super.invalidateCaps();
    }
}

