/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block.tile;

import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.block.tile.AnimatedTile;
import com.hollingsworth.arsnouveau.setup.BlockRegistry;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class PhantomBlockTile
extends AnimatedTile
implements ITickableTileEntity,
IAnimatable {
    int age;
    public boolean isPermanent;
    public double lengthModifier;
    public ParticleColor color = ParticleUtil.defaultParticleColor();
    AnimationFactory factory = new AnimationFactory((IAnimatable)this);

    public PhantomBlockTile() {
        super(BlockRegistry.PHANTOM_TILE);
    }

    public void func_73660_a() {
        if (this.isPermanent) {
            return;
        }
        if (!this.field_145850_b.field_72995_K) {
            ++this.age;
            if ((double)this.age > 300.0 + 100.0 * this.lengthModifier) {
                this.field_145850_b.func_175655_b(this.func_174877_v(), false);
                this.field_145850_b.func_175713_t(this.func_174877_v());
            }
        }
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.age = compound.func_74762_e("age");
        this.color = ParticleColor.IntWrapper.deserialize(compound.func_74779_i("color")).toParticleColor();
        this.isPermanent = compound.func_74767_n("permanent");
        this.lengthModifier = compound.func_74769_h("modifier");
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_218657_a("age", (INBT)IntNBT.func_229692_a_((int)this.age));
        compound.func_74778_a("color", this.color.toWrapper().serialize());
        compound.func_74757_a("permanent", this.isPermanent);
        compound.func_74780_a("modifier", this.lengthModifier);
        return super.func_189515_b(compound);
    }

    public void registerControllers(AnimationData data) {
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }
}

