/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.crafting.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.crafting.CraftingHelper;

public class RecipeUtil {
    public static NonNullList<Ingredient> parseShapeless(JsonObject json) {
        NonNullList ingredients = NonNullList.func_191196_a();
        for (JsonElement element : JSONUtils.func_151214_t((JsonObject)json, (String)"ingredients")) {
            ingredients.add((Object)CraftingHelper.getIngredient((JsonElement)element));
        }
        if (ingredients.isEmpty()) {
            throw new JsonParseException("No ingredients for shapeless recipe");
        }
        return ingredients;
    }

    public static class ShapedPrimer {
        private final NonNullList<Ingredient> ingredients;
        private final int recipeWidth;
        private final int recipeHeight;

        public ShapedPrimer(NonNullList<Ingredient> ingredients, int recipeWidth, int recipeHeight) {
            this.ingredients = ingredients;
            this.recipeWidth = recipeWidth;
            this.recipeHeight = recipeHeight;
        }

        public NonNullList<Ingredient> getIngredients() {
            return this.ingredients;
        }

        public int getRecipeWidth() {
            return this.recipeWidth;
        }

        public int getRecipeHeight() {
            return this.recipeHeight;
        }
    }
}

