/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.datagen;

import com.hollingsworth.arsnouveau.common.datagen.BaseLootTableProvider;
import com.hollingsworth.arsnouveau.common.entity.ModEntities;
import com.hollingsworth.arsnouveau.setup.BlockRegistry;
import com.hollingsworth.arsnouveau.setup.ItemsRegistry;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.entity.EntityType;
import net.minecraft.loot.ConstantRange;
import net.minecraft.loot.DynamicLootEntry;
import net.minecraft.loot.IRandomRange;
import net.minecraft.loot.ItemLootEntry;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.RandomValueRange;
import net.minecraft.loot.functions.CopyName;
import net.minecraft.loot.functions.CopyNbt;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.loot.functions.LootingEnchantBonus;
import net.minecraft.loot.functions.SetContents;
import net.minecraft.loot.functions.SetCount;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public class LootTables
extends BaseLootTableProvider {
    public LootTables(DataGenerator dataGeneratorIn) {
        super(dataGeneratorIn);
    }

    @Override
    protected void addTables() {
        System.out.println((Object)BlockRegistry.MANA_JAR);
        this.blockTables.put(BlockRegistry.MANA_JAR, this.createManaManchineTable("mana_jar", BlockRegistry.MANA_JAR));
        LootPool.Builder potionJarBuilder = LootPool.func_216096_a().name("potion_jar").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)BlockRegistry.POTION_JAR).func_212841_b_((ILootFunction.IBuilder)CopyName.func_215893_a((CopyName.Source)CopyName.Source.BLOCK_ENTITY)).func_212841_b_((ILootFunction.IBuilder)CopyNbt.func_215881_a((CopyNbt.Source)CopyNbt.Source.BLOCK_ENTITY).func_216055_a("amount", "BlockEntityTag.amount", CopyNbt.Action.REPLACE).func_216055_a("Potion", "BlockEntityTag.Potion", CopyNbt.Action.REPLACE).func_216055_a("CustomPotionEffects", "BlockEntityTag.CustomPotionEffects", CopyNbt.Action.REPLACE)).func_212841_b_((ILootFunction.IBuilder)SetContents.func_215920_b().func_216075_a((LootEntry.Builder)DynamicLootEntry.func_216162_a((ResourceLocation)new ResourceLocation("minecraft", "contents")))));
        this.blockTables.put(BlockRegistry.POTION_JAR, LootTable.func_216119_b().func_216040_a(potionJarBuilder));
        this.putStandardLoot((Block)BlockRegistry.ARCANE_ORE);
        this.putStandardLoot(BlockRegistry.GLYPH_PRESS_BLOCK);
        this.putStandardLoot(BlockRegistry.WARD_BLOCK);
        this.putStandardLoot(BlockRegistry.AGRONOMIC_SOURCELINK);
        this.putStandardLoot(BlockRegistry.ENCHANTING_APP_BLOCK);
        this.putStandardLoot(BlockRegistry.ARCANE_PEDESTAL);
        this.putStandardLoot(BlockRegistry.SCRIBES_BLOCK);
        this.putStandardLoot(BlockRegistry.SUMMONING_CRYSTAL);
        this.putStandardLoot(BlockRegistry.ARCANE_BRICKS);
        this.putStandardLoot(BlockRegistry.ARCANE_ROAD);
        this.putStandardLoot(BlockRegistry.ARCANE_RELAY);
        this.putStandardLoot(BlockRegistry.ARCANE_RELAY_SPLITTER);
        this.putStandardLoot(BlockRegistry.ARCANE_CORE_BLOCK);
        this.putStandardLoot(BlockRegistry.CRYSTALLIZER_BLOCK);
        this.putStandardLoot(BlockRegistry.VOLCANIC_BLOCK);
        this.putStandardLoot((Block)BlockRegistry.LAVA_LILY);
        this.putEntityTable(ModEntities.WILDEN_STALKER, LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ItemsRegistry.WILDEN_WING).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)0.0f, (float)1.0f))).func_212841_b_((ILootFunction.IBuilder)LootingEnchantBonus.func_215915_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.0f, (float)1.0f))))));
        this.putEntityTable(ModEntities.WILDEN_GUARDIAN, LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ItemsRegistry.WILDEN_SPIKE).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)0.0f, (float)1.0f))).func_212841_b_((ILootFunction.IBuilder)LootingEnchantBonus.func_215915_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.0f, (float)1.0f))))));
        this.putEntityTable(ModEntities.WILDEN_HUNTER, LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ItemsRegistry.WILDEN_HORN).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)0.0f, (float)1.0f))).func_212841_b_((ILootFunction.IBuilder)LootingEnchantBonus.func_215915_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.0f, (float)1.0f))))));
        this.putStandardLoot(BlockRegistry.RELAY_WARP);
        this.putStandardLoot(BlockRegistry.RELAY_DEPOSIT);
    }

    public void putStandardLoot(Block block) {
        this.blockTables.put(block, this.createStandardTable(block.getRegistryName().toString().replace("ars_nouveau:", ""), block));
    }

    public void putEntityTable(EntityType e, LootTable.Builder table) {
        this.entityTables.put(e.func_220348_g(), table);
    }
}

