/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity;

import com.hollingsworth.arsnouveau.api.client.ITooltipProvider;
import com.hollingsworth.arsnouveau.api.entity.IDispellable;
import com.hollingsworth.arsnouveau.api.item.IWandable;
import com.hollingsworth.arsnouveau.api.spell.EntitySpellResolver;
import com.hollingsworth.arsnouveau.api.spell.IInteractResponder;
import com.hollingsworth.arsnouveau.api.spell.IPickupResponder;
import com.hollingsworth.arsnouveau.api.spell.IPlaceBlockResponder;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.block.tile.BookwyrmLecternTile;
import com.hollingsworth.arsnouveau.common.entity.ModEntities;
import com.hollingsworth.arsnouveau.common.entity.goal.whelp.PerformTaskGoal;
import com.hollingsworth.arsnouveau.common.items.DominionWand;
import com.hollingsworth.arsnouveau.common.items.SpellParchment;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import com.hollingsworth.arsnouveau.setup.ItemsRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.FlyingEntity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.FlyingMovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.FlyingPathNavigator;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.items.IItemHandler;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class EntityBookwyrm
extends FlyingEntity
implements IPickupResponder,
IPlaceBlockResponder,
IDispellable,
ITooltipProvider,
IWandable,
IInteractResponder,
IAnimatable {
    public static final DataParameter<String> SPELL_STRING = EntityDataManager.func_187226_a(EntityBookwyrm.class, (IDataSerializer)DataSerializers.field_187194_d);
    public static final DataParameter<ItemStack> HELD_ITEM = EntityDataManager.func_187226_a(EntityBookwyrm.class, (IDataSerializer)DataSerializers.field_187196_f);
    public static final DataParameter<Boolean> STRICT_MODE = EntityDataManager.func_187226_a(EntityBookwyrm.class, (IDataSerializer)DataSerializers.field_187198_h);
    public static final DataParameter<String> COLOR = EntityDataManager.func_187226_a(EntityBookwyrm.class, (IDataSerializer)DataSerializers.field_187194_d);
    public BlockPos lecternPos;
    public int ticksSinceLastSpell;
    public Spell spellRecipe;
    private int backoffTicks;
    AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    public static String[] COLORS = new String[]{"purple", "green", "blue", "black", "red", "white"};

    protected EntityBookwyrm(EntityType<? extends FlyingEntity> p_i48568_1_, World p_i48568_2_) {
        super(p_i48568_1_, p_i48568_2_);
        this.field_70765_h = new FlyingMovementController((MobEntity)this, 10, true);
    }

    public EntityBookwyrm setRecipe(Spell spell) {
        this.spellRecipe = spell;
        return this;
    }

    public EntityBookwyrm(World p_i50190_2_) {
        super(ModEntities.ENTITY_BOOKWYRM_TYPE, p_i50190_2_);
        this.field_70765_h = new FlyingMovementController((MobEntity)this, 10, true);
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        if (this.field_70170_p.field_72995_K || hand != Hand.MAIN_HAND) {
            return ActionResultType.SUCCESS;
        }
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_184614_ca().func_77973_b().func_206844_a((ITag)Tags.Items.DYES)) {
            DyeColor color = DyeColor.getColor((ItemStack)stack);
            if (color == null || ((String)this.field_70180_af.func_187225_a(COLOR)).equals(color.func_176762_d()) || !Arrays.asList(COLORS).contains(color.func_176762_d())) {
                return ActionResultType.SUCCESS;
            }
            this.field_70180_af.func_187227_b(COLOR, (Object)color.func_176762_d());
            player.func_184614_ca().func_190918_g(1);
            return ActionResultType.SUCCESS;
        }
        if (stack.func_77973_b() instanceof DominionWand) {
            return ActionResultType.FAIL;
        }
        if (stack.func_77973_b() instanceof SpellParchment) {
            Spell spell = SpellParchment.getSpell(stack);
            if (new EntitySpellResolver(new SpellContext(spell, (LivingEntity)this)).canCast((LivingEntity)this)) {
                this.spellRecipe = spell;
                this.setRecipeString(this.spellRecipe.serialize());
                player.func_145747_a((ITextComponent)new TranslationTextComponent("ars_nouveau.whelp.spell_set"), Util.field_240973_b_);
            } else {
                player.func_145747_a((ITextComponent)new TranslationTextComponent("ars_nouveau.whelp.invalid"), Util.field_240973_b_);
            }
            return ActionResultType.SUCCESS;
        }
        if (stack.func_190926_b()) {
            if (this.spellRecipe == null || this.spellRecipe.recipe.size() == 0) {
                player.func_145747_a((ITextComponent)new TranslationTextComponent("ars_nouveau.whelp.desc"), Util.field_240973_b_);
            } else {
                player.func_145747_a((ITextComponent)new TranslationTextComponent("ars_nouveau.whelp.casting", new Object[]{this.spellRecipe.getDisplayString()}), Util.field_240973_b_);
            }
            return ActionResultType.SUCCESS;
        }
        if (!stack.func_190926_b()) {
            this.setHeldStack(new ItemStack((IItemProvider)stack.func_77973_b()));
            player.func_145747_a((ITextComponent)new TranslationTextComponent("ars_nouveau.whelp.spell_item", new Object[]{stack.func_77973_b().func_200295_i(stack).getString()}), Util.field_240973_b_);
        }
        return super.func_230254_b_(player, hand);
    }

    @Override
    public void onWanded(PlayerEntity playerEntity) {
        this.field_70180_af.func_187227_b(STRICT_MODE, (Object)((Boolean)this.field_70180_af.func_187225_a(STRICT_MODE) == false ? 1 : 0));
        PortUtil.sendMessage((Entity)playerEntity, (ITextComponent)new TranslationTextComponent("ars_nouveau.whelp.strict_mode", new Object[]{this.field_70180_af.func_187225_a(STRICT_MODE)}));
    }

    public EntityBookwyrm(World world, BlockPos lecternPos) {
        this(world);
        this.lecternPos = lecternPos;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p == null || this.field_70729_aU || this.lecternPos == null) {
            return;
        }
        ++this.ticksSinceLastSpell;
        if (!this.field_70170_p.field_72995_K && this.backoffTicks >= 0) {
            --this.backoffTicks;
        }
        if (this.field_70170_p.func_82737_E() % 20L == 0L && !(this.field_70170_p.func_175625_s(this.lecternPos) instanceof BookwyrmLecternTile) && !this.field_70170_p.field_72995_K) {
            this.func_70097_a(DamageSource.func_76365_a((PlayerEntity)FakePlayerFactory.getMinecraft((ServerWorld)((ServerWorld)this.field_70170_p))), 99.0f);
        }
    }

    public boolean func_70097_a(@Nonnull DamageSource source, float p_70097_2_) {
        if (source == DamageSource.field_76369_e || source == DamageSource.field_76368_d || source == DamageSource.field_220302_v || source == DamageSource.field_76367_g) {
            return false;
        }
        return super.func_70097_a(source, p_70097_2_);
    }

    protected PathNavigator func_175447_b(World world) {
        FlyingPathNavigator flyingpathnavigator = new FlyingPathNavigator((MobEntity)this, world);
        flyingpathnavigator.func_192879_a(false);
        flyingpathnavigator.func_212239_d(true);
        flyingpathnavigator.func_192878_b(true);
        return flyingpathnavigator;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(6, (Goal)new PerformTaskGoal(this));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
    }

    public boolean canPerformAnotherTask() {
        return this.ticksSinceLastSpell > 60 && new EntitySpellResolver(new SpellContext(this.spellRecipe, (LivingEntity)this)).canCast((LivingEntity)this);
    }

    @Nullable
    public BlockPos getTaskLoc() {
        BlockPos task;
        BlockPos blockPos = task = this.getTile() != null ? this.getTile().getNextTaskLoc(this.spellRecipe, this) : null;
        if (task == null) {
            this.ticksSinceLastSpell = 0;
        }
        return task;
    }

    public void castSpell(BlockPos target) {
        if (this.field_70170_p.field_72995_K || !(this.field_70170_p.func_175625_s(this.lecternPos) instanceof BookwyrmLecternTile)) {
            return;
        }
        if (((BookwyrmLecternTile)this.field_70170_p.func_175625_s(this.lecternPos)).removeManaAround(this.spellRecipe)) {
            EntitySpellResolver resolver = new EntitySpellResolver(new SpellContext(this.spellRecipe, (LivingEntity)this));
            resolver.onCastOnBlock(new BlockRayTraceResult(new Vector3d((double)target.func_177958_n(), (double)target.func_177956_o(), (double)target.func_177952_p()), Direction.UP, target, false), (LivingEntity)this);
        }
        this.ticksSinceLastSpell = 0;
    }

    public boolean enoughManaForTask() {
        if (!(this.field_70170_p.func_175625_s(this.lecternPos) instanceof BookwyrmLecternTile) || this.spellRecipe == null || this.spellRecipe.isEmpty()) {
            return false;
        }
        return ((BookwyrmLecternTile)this.field_70170_p.func_175625_s(this.lecternPos)).enoughMana(this.spellRecipe);
    }

    @Override
    @Nonnull
    public ItemStack onPickup(ItemStack stack) {
        BookwyrmLecternTile tile = this.getTile();
        return tile == null ? stack : tile.insertItem(stack);
    }

    @Override
    public ItemStack onPlaceBlock() {
        ItemStack heldStack = this.getHeldStack();
        if (heldStack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        BookwyrmLecternTile tile = this.getTile();
        return tile == null ? heldStack : tile.getItem(heldStack.func_77973_b());
    }

    @Override
    public List<String> getTooltip() {
        ArrayList<String> list = new ArrayList<String>();
        Spell spellParts = Spell.deserialize(this.getRecipeString());
        String spellString = spellParts.getDisplayString();
        String itemString = this.getHeldStack() == ItemStack.field_190927_a ? new TranslationTextComponent("ars_nouveau.whelp.no_item").getString() : this.getHeldStack().func_200301_q().getString();
        String itemAction = this.getHeldStack().func_77973_b() instanceof BlockItem ? new TranslationTextComponent("ars_nouveau.whelp.placing").getString() : new TranslationTextComponent("ars_nouveau.whelp.using").getString();
        list.add(new TranslationTextComponent("ars_nouveau.whelp.spell").getString() + spellString);
        list.add(itemAction + itemString);
        list.add(new TranslationTextComponent("ars_nouveau.whelp.strict").getString() + new TranslationTextComponent("ars_nouveau." + this.field_70180_af.func_187225_a(STRICT_MODE)).getString());
        return list;
    }

    @Override
    public boolean onDispel(@Nullable LivingEntity caster) {
        if (this.field_70128_L) {
            return false;
        }
        if (!this.field_70170_p.field_72995_K) {
            ItemStack stack = new ItemStack((IItemProvider)ItemsRegistry.BOOKWYRM_CHARM);
            this.field_70170_p.func_217376_c((Entity)new ItemEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), stack));
            ParticleUtil.spawnPoof((ServerWorld)this.field_70170_p, this.func_233580_cy_());
            this.func_70106_y();
        }
        return true;
    }

    public EntityType<?> func_200600_R() {
        return ModEntities.ENTITY_BOOKWYRM_TYPE;
    }

    public void func_213281_b(CompoundNBT tag) {
        super.func_213281_b(tag);
        if (this.lecternPos != null) {
            tag.func_74768_a("summoner_x", this.lecternPos.func_177958_n());
            tag.func_74768_a("summoner_y", this.lecternPos.func_177956_o());
            tag.func_74768_a("summoner_z", this.lecternPos.func_177952_p());
        }
        tag.func_74768_a("last_spell", this.ticksSinceLastSpell);
        if (this.spellRecipe != null) {
            tag.func_74778_a("spell", this.spellRecipe.serialize());
        }
        if (!this.getHeldStack().func_190926_b()) {
            CompoundNBT itemTag = new CompoundNBT();
            this.getHeldStack().func_77955_b(itemTag);
            tag.func_218657_a("held", (INBT)itemTag);
        }
        tag.func_74768_a("backoff", this.backoffTicks);
        tag.func_74757_a("strict", ((Boolean)this.field_70180_af.func_187225_a(STRICT_MODE)).booleanValue());
        tag.func_74778_a("color", (String)this.field_70180_af.func_187225_a(COLOR));
    }

    public void func_70037_a(CompoundNBT tag) {
        super.func_70037_a(tag);
        if (tag.func_74764_b("summoner_x")) {
            this.lecternPos = new BlockPos(tag.func_74762_e("summoner_x"), tag.func_74762_e("summoner_y"), tag.func_74762_e("summoner_z"));
        }
        this.spellRecipe = Spell.deserialize(tag.func_74779_i("spell"));
        this.ticksSinceLastSpell = tag.func_74762_e("last_spell");
        if (tag.func_74764_b("held")) {
            this.setHeldStack(ItemStack.func_199557_a((CompoundNBT)((CompoundNBT)tag.func_74781_a("held"))));
        }
        this.setRecipeString(this.spellRecipe.serialize());
        this.field_70180_af.func_187227_b(STRICT_MODE, (Object)tag.func_74767_n("strict"));
        this.backoffTicks = tag.func_74762_e("backoff");
        if (tag.func_74764_b("color")) {
            this.field_70180_af.func_187227_b(COLOR, (Object)tag.func_74779_i("color"));
        }
    }

    @Override
    public ItemStack getHeldItem() {
        if (this.lecternPos != null && this.field_70170_p.func_175625_s(this.lecternPos) instanceof BookwyrmLecternTile) {
            BookwyrmLecternTile tile = (BookwyrmLecternTile)this.field_70170_p.func_175625_s(this.lecternPos);
            for (IItemHandler inv : BlockUtil.getAdjacentInventories(this.field_70170_p, tile.func_174877_v())) {
                for (int i = 0; i < inv.getSlots(); ++i) {
                    if (!inv.getStackInSlot(i).func_77969_a((ItemStack)this.field_70180_af.func_187225_a(HELD_ITEM))) continue;
                    return inv.getStackInSlot(i).func_77979_a(1);
                }
            }
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public List<IItemHandler> getInventory() {
        return BlockUtil.getAdjacentInventories(this.field_70170_p, this.lecternPos);
    }

    @Nullable
    public BookwyrmLecternTile getTile() {
        return this.lecternPos == null || !(this.field_70170_p.func_175625_s(this.lecternPos) instanceof BookwyrmLecternTile) ? null : (BookwyrmLecternTile)this.field_70170_p.func_175625_s(this.lecternPos);
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "walkController", 1.0f, this::idle));
    }

    public PlayState idle(AnimationEvent event) {
        event.getController().setAnimation(new AnimationBuilder().addAnimation("idle"));
        return PlayState.CONTINUE;
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    protected int func_70693_a(PlayerEntity player) {
        return 0;
    }

    public boolean func_213397_c(double p_213397_1_) {
        return false;
    }

    public String getRecipeString() {
        return (String)this.field_70180_af.func_187225_a(SPELL_STRING);
    }

    public void setRecipeString(String recipeString) {
        this.field_70180_af.func_187227_b(SPELL_STRING, (Object)recipeString);
    }

    @Nonnull
    public ItemStack getHeldStack() {
        return (ItemStack)this.field_70180_af.func_187225_a(HELD_ITEM);
    }

    public void setHeldStack(ItemStack stack) {
        this.field_70180_af.func_187227_b(HELD_ITEM, (Object)stack);
    }

    public void func_70645_a(DamageSource source) {
        if (!this.field_70170_p.field_72995_K) {
            ItemStack stack = new ItemStack((IItemProvider)ItemsRegistry.BOOKWYRM_CHARM);
            this.field_70170_p.func_217376_c((Entity)new ItemEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), stack));
        }
        super.func_70645_a(source);
    }

    public static AttributeModifierMap.MutableAttribute attributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233822_e_, Attributes.field_233822_e_.func_111110_b()).func_233815_a_(Attributes.field_233818_a_, 6.0).func_233815_a_(Attributes.field_233821_d_, 0.3);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(HELD_ITEM, (Object)ItemStack.field_190927_a);
        this.field_70180_af.func_187214_a(SPELL_STRING, (Object)"");
        this.field_70180_af.func_187214_a(STRICT_MODE, (Object)true);
        this.field_70180_af.func_187214_a(COLOR, (Object)"blue");
    }
}

