/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity;

import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.client.particle.GlowParticleData;
import com.hollingsworth.arsnouveau.common.block.SpellPrismBlock;
import com.hollingsworth.arsnouveau.common.entity.ColoredProjectile;
import com.hollingsworth.arsnouveau.common.entity.ModEntities;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketANEffect;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentPierce;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentSensitive;
import com.hollingsworth.arsnouveau.setup.BlockRegistry;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;

public class EntityProjectileSpell
extends ColoredProjectile {
    public int age;
    public SpellResolver spellResolver;
    public int pierceLeft;
    public int numSensitive;
    public Set<BlockPos> hitList = new HashSet<BlockPos>();

    public EntityProjectileSpell(EntityType<? extends EntityProjectileSpell> entityType, World world) {
        super(entityType, world);
    }

    public EntityProjectileSpell(World world, double x, double y, double z) {
        super(world, x, y, z);
    }

    public EntityProjectileSpell(World world, SpellResolver resolver) {
        super(world, resolver.spellContext.caster);
        this.spellResolver = resolver;
        this.pierceLeft = resolver.spell.getBuffsAtIndex(0, resolver.spellContext.caster, AugmentPierce.INSTANCE);
        this.numSensitive = resolver.spell.getBuffsAtIndex(0, resolver.spellContext.caster, AugmentSensitive.INSTANCE);
        resolver.spellContext.colors.makeVisible();
        this.setColor(resolver.spellContext.colors);
    }

    public EntityProjectileSpell(World world, LivingEntity shooter) {
        super(world, shooter);
    }

    public void func_70071_h_() {
        EntityRayTraceResult entityraytraceresult;
        Vector3d vector3d3;
        Vector3d vector3d2;
        BlockRayTraceResult raytraceresult;
        ++this.age;
        Vector3d vector3d = this.func_213322_ci();
        if (this.age > 1200) {
            this.func_70106_y();
            return;
        }
        this.field_70142_S = this.func_226277_ct_();
        this.field_70137_T = this.func_226278_cu_();
        this.field_70136_U = this.func_226281_cx_();
        if (this.field_70254_i) {
            this.field_70254_i = false;
            this.func_213317_d(this.func_213322_ci());
        }
        if ((raytraceresult = this.field_70170_p.func_217299_a(new RayTraceContext(vector3d2 = this.func_213303_ch(), vector3d3 = vector3d2.func_178787_e(vector3d), this.numSensitive > 0 ? RayTraceContext.BlockMode.OUTLINE : RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this))) != null && raytraceresult.func_216346_c() != RayTraceResult.Type.MISS) {
            vector3d3 = raytraceresult.func_216347_e();
        }
        if ((entityraytraceresult = this.func_213866_a(vector3d2, vector3d3)) != null) {
            raytraceresult = entityraytraceresult;
        }
        if (raytraceresult != null && raytraceresult instanceof EntityRayTraceResult) {
            Entity entity = ((EntityRayTraceResult)raytraceresult).func_216348_a();
            Entity entity1 = this.func_234616_v_();
            if (entity instanceof PlayerEntity && entity1 instanceof PlayerEntity && !((PlayerEntity)entity1).func_96122_a((PlayerEntity)entity)) {
                raytraceresult = null;
            }
        }
        if (raytraceresult != null && raytraceresult.func_216346_c() != RayTraceResult.Type.MISS && !ForgeEventFactory.onProjectileImpact((AbstractArrowEntity)this, (RayTraceResult)raytraceresult)) {
            this.func_70227_a((RayTraceResult)raytraceresult);
            this.field_70160_al = true;
        }
        if (raytraceresult != null && raytraceresult.func_216346_c() == RayTraceResult.Type.MISS && raytraceresult instanceof BlockRayTraceResult) {
            BlockRegistry.PORTAL_BLOCK.func_220066_a(this.field_70170_p, this.field_70170_p.func_180495_p(new BlockPos(raytraceresult.func_216347_e())), raytraceresult, (ProjectileEntity)this);
        }
        Vector3d vec3d = this.func_213322_ci();
        double x = this.func_226277_ct_() + vec3d.field_72450_a;
        double y = this.func_226278_cu_() + vec3d.field_72448_b;
        double z = this.func_226281_cx_() + vec3d.field_72449_c;
        if (!this.func_189652_ae()) {
            Vector3d vec3d1 = this.func_213322_ci();
            this.func_213293_j(vec3d1.field_72450_a, vec3d1.field_72448_b, vec3d1.field_72449_c);
        }
        this.func_70107_b(x, y, z);
        if (this.field_70170_p.field_72995_K && this.age > 2) {
            for (int i = 0; i < 10; ++i) {
                double deltaX = this.func_226277_ct_() - this.field_70142_S;
                double deltaY = this.func_226278_cu_() - this.field_70137_T;
                double deltaZ = this.func_226281_cx_() - this.field_70136_U;
                double dist = Math.ceil(Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ) * 8.0);
                for (double j = 0.0; j < dist; j += 1.0) {
                    double coeff = j / dist;
                    this.field_70170_p.func_195594_a(GlowParticleData.createData(this.getParticleColor()), (double)((float)(this.field_70169_q + deltaX * coeff)), (double)((float)(this.field_70167_r + deltaY * coeff)), (double)((float)(this.field_70166_s + deltaZ * coeff)), (double)(0.0125f * (this.field_70146_Z.nextFloat() - 0.5f)), (double)(0.0125f * (this.field_70146_Z.nextFloat() - 0.5f)), (double)(0.0125f * (this.field_70146_Z.nextFloat() - 0.5f)));
                }
            }
        }
    }

    public void func_70030_z() {
        super.func_70030_z();
    }

    public void shoot(Entity entityThrower, float rotationPitchIn, float rotationYawIn, float pitchOffset, float velocity, float inaccuracy) {
        float f = -MathHelper.func_76126_a((float)(rotationYawIn * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(rotationPitchIn * ((float)Math.PI / 180)));
        float f1 = -MathHelper.func_76126_a((float)((rotationPitchIn + pitchOffset) * ((float)Math.PI / 180)));
        float f2 = MathHelper.func_76134_b((float)(rotationYawIn * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(rotationPitchIn * ((float)Math.PI / 180)));
        this.func_70186_c(f, f1, f2, velocity, inaccuracy);
        Vector3d vec3d = entityThrower.func_70040_Z();
        this.func_213317_d(this.func_213322_ci().func_72441_c(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c));
    }

    public void func_70186_c(double x, double y, double z, float velocity, float inaccuracy) {
        Vector3d vec3d = new Vector3d(x, y, z).func_72432_b().func_72441_c(this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy, this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy, this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy).func_186678_a((double)velocity);
        this.func_213317_d(vec3d);
        float f = MathHelper.func_76133_a((double)EntityProjectileSpell.func_213296_b((Vector3d)vec3d));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)vec3d.field_72450_a, (double)vec3d.field_72449_c) * 57.2957763671875);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)vec3d.field_72448_b, (double)f) * 57.2957763671875);
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
    }

    public boolean func_189652_ae() {
        return true;
    }

    public EntityType<?> func_200600_R() {
        return ModEntities.SPELL_PROJ;
    }

    protected void attemptRemoval() {
        --this.pierceLeft;
        if (this.pierceLeft < 0) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)3);
            this.func_70106_y();
        }
    }

    protected void func_70227_a(RayTraceResult result) {
        if (!this.field_70170_p.field_72995_K && result != null && result.func_216346_c() == RayTraceResult.Type.ENTITY) {
            if (((EntityRayTraceResult)result).func_216348_a().equals((Object)this.func_234616_v_())) {
                return;
            }
            if (this.spellResolver != null) {
                this.spellResolver.onResolveEffect(this.field_70170_p, (LivingEntity)this.func_234616_v_(), result);
                Networking.sendToNearby(this.field_70170_p, new BlockPos(result.func_216347_e()), (Object)new PacketANEffect(PacketANEffect.EffectType.BURST, new BlockPos(result.func_216347_e()), this.getParticleColorWrapper(), new int[0]));
                this.attemptRemoval();
            }
        }
        if (!this.field_70170_p.field_72995_K && result instanceof BlockRayTraceResult && !this.field_70128_L && !this.hitList.contains(((BlockRayTraceResult)result).func_216350_a())) {
            BlockRayTraceResult blockraytraceresult = (BlockRayTraceResult)result;
            BlockState state = this.field_70170_p.func_180495_p(((BlockRayTraceResult)result).func_216350_a());
            if (state.func_177230_c() instanceof SpellPrismBlock) {
                SpellPrismBlock.redirectSpell((ServerWorld)this.field_70170_p, blockraytraceresult.func_216350_a(), this);
                return;
            }
            if (state.func_185904_a() == Material.field_151567_E) {
                state.func_177230_c().func_196262_a(state, this.field_70170_p, ((BlockRayTraceResult)result).func_216350_a(), (Entity)this);
                return;
            }
            if (this.spellResolver != null) {
                this.hitList.add(blockraytraceresult.func_216350_a());
                this.spellResolver.onResolveEffect(this.field_70170_p, (LivingEntity)this.func_234616_v_(), (RayTraceResult)blockraytraceresult);
            }
            Networking.sendToNearby(this.field_70170_p, ((BlockRayTraceResult)result).func_216350_a(), (Object)new PacketANEffect(PacketANEffect.EffectType.BURST, new BlockPos(result.func_216347_e()).func_177977_b(), this.getParticleColorWrapper(), new int[0]));
            this.attemptRemoval();
        }
    }

    public EntityProjectileSpell(FMLPlayMessages.SpawnEntity packet, World world) {
        super(ModEntities.SPELL_PROJ, world);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void func_70037_a(CompoundNBT tag) {
        super.func_70037_a(tag);
        if (tag.func_74764_b("pierce")) {
            this.pierceLeft = tag.func_74762_e("pierce");
        }
    }

    @Override
    public void func_213281_b(CompoundNBT tag) {
        super.func_213281_b(tag);
        tag.func_74768_a("pierce", this.pierceLeft);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
    }
}

