/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity;

import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.common.entity.EntityAllyVex;
import com.hollingsworth.arsnouveau.common.entity.EntityBookwyrm;
import com.hollingsworth.arsnouveau.common.entity.EntityCarbuncle;
import com.hollingsworth.arsnouveau.common.entity.EntityChimera;
import com.hollingsworth.arsnouveau.common.entity.EntityChimeraProjectile;
import com.hollingsworth.arsnouveau.common.entity.EntityDrygmy;
import com.hollingsworth.arsnouveau.common.entity.EntityDummy;
import com.hollingsworth.arsnouveau.common.entity.EntityEarthElemental;
import com.hollingsworth.arsnouveau.common.entity.EntityEvokerFangs;
import com.hollingsworth.arsnouveau.common.entity.EntityFlyingItem;
import com.hollingsworth.arsnouveau.common.entity.EntityFollowProjectile;
import com.hollingsworth.arsnouveau.common.entity.EntityLingeringSpell;
import com.hollingsworth.arsnouveau.common.entity.EntityOrbitProjectile;
import com.hollingsworth.arsnouveau.common.entity.EntityProjectileSpell;
import com.hollingsworth.arsnouveau.common.entity.EntityRitualProjectile;
import com.hollingsworth.arsnouveau.common.entity.EntitySpellArrow;
import com.hollingsworth.arsnouveau.common.entity.EntitySylph;
import com.hollingsworth.arsnouveau.common.entity.EntityWixie;
import com.hollingsworth.arsnouveau.common.entity.LightningEntity;
import com.hollingsworth.arsnouveau.common.entity.SummonHorse;
import com.hollingsworth.arsnouveau.common.entity.SummonWolf;
import com.hollingsworth.arsnouveau.common.entity.WealdWalker;
import com.hollingsworth.arsnouveau.common.entity.WildenGuardian;
import com.hollingsworth.arsnouveau.common.entity.WildenHunter;
import com.hollingsworth.arsnouveau.common.entity.WildenStalker;
import com.hollingsworth.arsnouveau.common.entity.familiar.FamiliarBookwyrm;
import com.hollingsworth.arsnouveau.common.entity.familiar.FamiliarCarbuncle;
import com.hollingsworth.arsnouveau.common.entity.familiar.FamiliarDrygmy;
import com.hollingsworth.arsnouveau.common.entity.familiar.FamiliarEntity;
import com.hollingsworth.arsnouveau.common.entity.familiar.FamiliarJabberwog;
import com.hollingsworth.arsnouveau.common.entity.familiar.FamiliarSylph;
import com.hollingsworth.arsnouveau.common.entity.familiar.FamiliarWixie;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAmplify;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentSensitive;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectColdSnap;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectFlare;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectFreeze;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectHarm;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectHex;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectIgnite;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectSnare;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectWither;
import com.hollingsworth.arsnouveau.common.spell.method.MethodProjectile;
import com.hollingsworth.arsnouveau.setup.Config;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Blocks;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.monster.VexEntity;
import net.minecraft.entity.passive.WolfEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Difficulty;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.LightType;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="ars_nouveau")
public class ModEntities {
    public static EntityType<EntityProjectileSpell> SPELL_PROJ = null;
    public static EntityType<EntityAllyVex> ALLY_VEX = null;
    public static EntityType<EntityEvokerFangs> ENTITY_EVOKER_FANGS_ENTITY_TYPE = null;
    public static EntityType<EntityBookwyrm> ENTITY_BOOKWYRM_TYPE = null;
    public static EntityType<EntityCarbuncle> ENTITY_CARBUNCLE_TYPE = ModEntities.build("carbuncle", EntityType.Builder.func_220322_a(EntityCarbuncle::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(0.6f, 0.63f).setTrackingRange(10).setShouldReceiveVelocityUpdates(true));
    public static EntityType<EntityFollowProjectile> ENTITY_FOLLOW_PROJ = null;
    public static EntityType<EntitySylph> ENTITY_SYLPH_TYPE = ModEntities.build("sylph", EntityType.Builder.func_220322_a(EntitySylph::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(0.6f, 0.98f).setTrackingRange(10).setShouldReceiveVelocityUpdates(true));
    public static EntityType<EntityEarthElemental> ENTITY_EARTH_ELEMENTAL_TYPE = null;
    public static EntityType<EntityWixie> ENTITY_WIXIE_TYPE = null;
    public static EntityType<EntityFlyingItem> ENTITY_FLYING_ITEM = null;
    public static EntityType<EntityRitualProjectile> ENTITY_RITUAL = null;
    public static EntityType<WildenHunter> WILDEN_HUNTER = ModEntities.build("wilden_hunter", EntityType.Builder.func_220322_a(WildenHunter::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(0.6f, 1.95f).setTrackingRange(10).setShouldReceiveVelocityUpdates(true));
    public static EntityType<EntitySpellArrow> ENTITY_SPELL_ARROW = null;
    public static EntityType<SummonWolf> SUMMON_WOLF = null;
    public static EntityType<WildenStalker> WILDEN_STALKER = ModEntities.build("wilden_stalker", EntityType.Builder.func_220322_a(WildenStalker::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(0.6f, 1.95f).setTrackingRange(10).setShouldReceiveVelocityUpdates(true));
    public static EntityType<SummonHorse> SUMMON_HORSE = null;
    public static EntityType<WildenGuardian> WILDEN_GUARDIAN = ModEntities.build("wilden_guardian", EntityType.Builder.func_220322_a(WildenGuardian::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(0.65f, 1.95f).setTrackingRange(10).setShouldReceiveVelocityUpdates(true));
    public static EntityType<EntityChimera> WILDEN_BOSS = ModEntities.build("wilden_boss", EntityType.Builder.func_220322_a(EntityChimera::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(1.5f, 2.5f).setTrackingRange(10).setShouldReceiveVelocityUpdates(true));
    public static EntityType<LightningEntity> LIGHTNING_ENTITY = null;
    public static EntityType<EntityDummy> ENTITY_DUMMY = null;
    public static EntityType<EntityDrygmy> ENTITY_DRYGMY = null;
    public static EntityType<EntityOrbitProjectile> ENTITY_WARD = null;
    public static EntityType<EntityChimeraProjectile> ENTITY_CHIMERA_SPIKE = null;
    public static EntityType<FamiliarCarbuncle> ENTITY_FAMILIAR_CARBUNCLE = null;
    public static EntityType<FamiliarWixie> ENTITY_FAMILIAR_WIXIE = null;
    public static EntityType<FamiliarBookwyrm> ENTITY_FAMILIAR_BOOKWYRM = null;
    public static EntityType<FamiliarDrygmy> ENTITY_FAMILIAR_DRYGMY = null;
    public static EntityType<FamiliarSylph> ENTITY_FAMILIAR_SYLPH = null;
    public static EntityType<FamiliarJabberwog> ENTITY_FAMILIAR_JABBERWOG = null;
    public static EntityType<EntityLingeringSpell> LINGER_SPELL = null;
    public static EntityType<WealdWalker> ENTITY_CASCADING_WEALD = null;
    public static EntityType<WealdWalker> ENTITY_FLOURISHING_WEALD = null;
    public static EntityType<WealdWalker> ENTITY_BLAZING_WEALD = null;
    public static EntityType<WealdWalker> ENTITY_VEXING_WEALD = null;

    public static boolean canMonsterSpawnInLight(EntityType<? extends Entity> type, IServerWorld worldIn, SpawnReason reason, BlockPos pos, Random randomIn) {
        return worldIn.func_175659_aa() != Difficulty.PEACEFUL && ModEntities.isValidLightLevel(worldIn, pos, randomIn) && ModEntities.canSpawnOn(type, (IWorld)worldIn, reason, pos, randomIn) && !((List)Config.DIMENSION_BLACKLIST.get()).contains(worldIn.func_201672_e().func_234923_W_().func_240901_a_().toString());
    }

    public static boolean canSpawnOn(EntityType<? extends Entity> typeIn, IWorld worldIn, SpawnReason reason, BlockPos pos, Random randomIn) {
        BlockPos blockpos = pos.func_177977_b();
        return reason == SpawnReason.SPAWNER || worldIn.func_180495_p(blockpos).func_215688_a((IBlockReader)worldIn, blockpos, typeIn);
    }

    public static boolean genericGroundSpawn(EntityType<? extends Entity> animal, IWorld worldIn, SpawnReason reason, BlockPos pos, Random random) {
        return worldIn.func_180495_p(pos.func_177977_b()).func_203425_a(Blocks.field_196658_i) && worldIn.func_226659_b_(pos, 0) > 8;
    }

    public static boolean isValidLightLevel(IServerWorld worldIn, BlockPos pos, Random randomIn) {
        if (worldIn.func_226658_a_(LightType.SKY, pos) > randomIn.nextInt(32)) {
            return false;
        }
        int i = worldIn.func_201672_e().func_72911_I() ? worldIn.func_205049_d(pos, 10) : worldIn.func_201696_r(pos);
        return i <= randomIn.nextInt(8);
    }

    private static <T extends Entity> EntityType<T> build(String name, EntityType.Builder<T> builder) {
        ResourceLocation registryName = new ResourceLocation("ars_nouveau", name);
        EntityType entityType = builder.func_206830_a(registryName.toString());
        entityType.setRegistryName(registryName);
        return entityType;
    }

    @Mod.EventBusSubscriber(modid="ars_nouveau", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistrationHandler {
        @SubscribeEvent
        public static void registerEntities(RegistryEvent.Register<EntityType<?>> event) {
            SPELL_PROJ = ModEntities.build("spell_proj", EntityType.Builder.func_220322_a(EntityProjectileSpell::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.5f, 0.5f).setTrackingRange(20).func_200706_c().setShouldReceiveVelocityUpdates(true).setUpdateInterval(120).setCustomClientFactory(EntityProjectileSpell::new));
            LINGER_SPELL = ModEntities.build("linger", EntityType.Builder.func_220322_a(EntityLingeringSpell::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.5f, 0.5f).setTrackingRange(20).setShouldReceiveVelocityUpdates(true).setUpdateInterval(120).setCustomClientFactory(EntityLingeringSpell::new));
            ENTITY_EVOKER_FANGS_ENTITY_TYPE = ModEntities.build("fangs", EntityType.Builder.func_220322_a(EntityEvokerFangs::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.5f, 0.8f).setUpdateInterval(60));
            ALLY_VEX = ModEntities.build("ally_vex", EntityType.Builder.func_220322_a(EntityAllyVex::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.4f, 0.8f).func_220320_c());
            ENTITY_BOOKWYRM_TYPE = ModEntities.build("whelp", EntityType.Builder.func_220322_a(EntityBookwyrm::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.7f, 0.9f).setTrackingRange(10).setShouldReceiveVelocityUpdates(true));
            ENTITY_FOLLOW_PROJ = ModEntities.build("follow_proj", EntityType.Builder.func_220322_a(EntityFollowProjectile::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.5f, 0.5f).func_200706_c().setTrackingRange(10).setShouldReceiveVelocityUpdates(true).setCustomClientFactory(EntityFollowProjectile::new));
            ENTITY_WIXIE_TYPE = ModEntities.build("wixie", EntityType.Builder.func_220322_a(EntityWixie::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.6f, 0.98f).setTrackingRange(10).setShouldReceiveVelocityUpdates(true));
            ENTITY_FLYING_ITEM = ModEntities.build("flying_item", EntityType.Builder.func_220322_a(EntityFlyingItem::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.5f, 0.5f).func_200706_c().setTrackingRange(10).setUpdateInterval(60).setShouldReceiveVelocityUpdates(true).setCustomClientFactory(EntityFlyingItem::new));
            ENTITY_RITUAL = ModEntities.build("ritual", EntityType.Builder.func_220322_a(EntityRitualProjectile::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.5f, 0.5f).setTrackingRange(10).setUpdateInterval(60).setShouldReceiveVelocityUpdates(true).setCustomClientFactory(EntityRitualProjectile::new));
            ENTITY_SPELL_ARROW = ModEntities.build("spell_arrow", EntityType.Builder.func_220322_a(EntitySpellArrow::new, (EntityClassification)EntityClassification.MISC).func_233606_a_(20).func_233608_b_(20).setShouldReceiveVelocityUpdates(true).setCustomClientFactory(EntitySpellArrow::new));
            SUMMON_WOLF = ModEntities.build("summon_wolf", EntityType.Builder.func_220322_a(SummonWolf::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(0.6f, 0.85f).func_233606_a_(10));
            SUMMON_HORSE = ModEntities.build("summon_horse", EntityType.Builder.func_220322_a(SummonHorse::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(1.3964844f, 1.6f).func_233606_a_(10));
            ENTITY_DUMMY = ModEntities.build("dummy", EntityType.Builder.func_220322_a(EntityDummy::new, (EntityClassification)EntityClassification.MISC).func_220321_a(1.0f, 2.0f).setTrackingRange(10).setShouldReceiveVelocityUpdates(true));
            LIGHTNING_ENTITY = ModEntities.build("an_lightning", EntityType.Builder.func_220322_a(LightningEntity::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.0f, 0.0f).func_233606_a_(16).func_233608_b_(Integer.MAX_VALUE).setShouldReceiveVelocityUpdates(true).setUpdateInterval(60));
            ENTITY_DRYGMY = ModEntities.build("drygmy", EntityType.Builder.func_220322_a(EntityDrygmy::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(0.6f, 0.85f).func_233606_a_(10));
            ENTITY_WARD = ModEntities.build("ward_entity", EntityType.Builder.func_220322_a(EntityOrbitProjectile::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.5f, 0.5f).func_233606_a_(20).func_233608_b_(20).setShouldReceiveVelocityUpdates(true).setCustomClientFactory(EntityOrbitProjectile::new));
            ENTITY_CHIMERA_SPIKE = ModEntities.build("spike", EntityType.Builder.func_220322_a(EntityChimeraProjectile::new, (EntityClassification)EntityClassification.MISC).func_233606_a_(20).func_233608_b_(20).setShouldReceiveVelocityUpdates(true).setCustomClientFactory(EntityChimeraProjectile::new));
            ENTITY_FAMILIAR_CARBUNCLE = ModEntities.build("familiar_carbuncle", EntityType.Builder.func_220322_a(FamiliarCarbuncle::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(0.7f, 0.63f).setTrackingRange(10));
            ENTITY_FAMILIAR_BOOKWYRM = ModEntities.build("familiar_bookwyrm", EntityType.Builder.func_220322_a(FamiliarBookwyrm::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(0.7f, 0.9f).setTrackingRange(10));
            ENTITY_FAMILIAR_DRYGMY = ModEntities.build("familiar_drygmy", EntityType.Builder.func_220322_a(FamiliarDrygmy::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(0.6f, 0.85f).setTrackingRange(10));
            ENTITY_FAMILIAR_SYLPH = ModEntities.build("familiar_sylph", EntityType.Builder.func_220322_a(FamiliarSylph::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(0.7f, 0.63f).setTrackingRange(10));
            ENTITY_FAMILIAR_JABBERWOG = ModEntities.build("familiar_jabberwog", EntityType.Builder.func_220322_a(FamiliarJabberwog::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(0.7f, 0.63f).setTrackingRange(10));
            ENTITY_FAMILIAR_WIXIE = ModEntities.build("familiar_wixie", EntityType.Builder.func_220322_a(FamiliarWixie::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(0.7f, 0.63f).setTrackingRange(10));
            ENTITY_CASCADING_WEALD = ModEntities.build("cascading_weald_walker", EntityType.Builder.func_220322_a((type, world) -> {
                WealdWalker walker = new WealdWalker((EntityType<? extends AgeableEntity>)type, world);
                walker.spell = new Spell(MethodProjectile.INSTANCE, EffectFreeze.INSTANCE, EffectColdSnap.INSTANCE);
                walker.color = new ParticleColor(50, 50, 250);
                return walker;
            }, (EntityClassification)EntityClassification.CREATURE).func_220321_a(1.4f, 3.0f).setTrackingRange(10));
            ENTITY_FLOURISHING_WEALD = ModEntities.build("flourishing_weald_walker", EntityType.Builder.func_220322_a((type, world) -> {
                WealdWalker walker = new WealdWalker((EntityType<? extends AgeableEntity>)type, world);
                walker.spell = new Spell(MethodProjectile.INSTANCE, EffectHarm.INSTANCE, AugmentAmplify.INSTANCE, AugmentAmplify.INSTANCE, EffectSnare.INSTANCE);
                walker.color = new ParticleColor(50, 250, 55);
                return walker;
            }, (EntityClassification)EntityClassification.CREATURE).func_220321_a(1.4f, 3.0f).setTrackingRange(10));
            ENTITY_BLAZING_WEALD = ModEntities.build("blazing_weald_walker", EntityType.Builder.func_220322_a((type, world) -> {
                WealdWalker walker = new WealdWalker((EntityType<? extends AgeableEntity>)type, world);
                walker.spell = new Spell(MethodProjectile.INSTANCE, EffectIgnite.INSTANCE, AugmentSensitive.INSTANCE, EffectFlare.INSTANCE);
                walker.color = new ParticleColor(250, 15, 15);
                return walker;
            }, (EntityClassification)EntityClassification.CREATURE).func_220321_a(1.4f, 3.0f).setTrackingRange(10));
            ENTITY_VEXING_WEALD = ModEntities.build("vexing_weald_walker", EntityType.Builder.func_220322_a((type, world) -> {
                WealdWalker walker = new WealdWalker((EntityType<? extends AgeableEntity>)type, world);
                walker.spell = new Spell(MethodProjectile.INSTANCE, EffectHex.INSTANCE, EffectWither.INSTANCE, AugmentAmplify.INSTANCE, AugmentAmplify.INSTANCE);
                walker.color = new ParticleColor(250, 50, 250);
                return walker;
            }, (EntityClassification)EntityClassification.CREATURE).func_220321_a(1.4f, 3.0f).setTrackingRange(10));
            event.getRegistry().registerAll((IForgeRegistryEntry[])new EntityType[]{SPELL_PROJ, ENTITY_EVOKER_FANGS_ENTITY_TYPE, ALLY_VEX, ENTITY_BOOKWYRM_TYPE, ENTITY_CARBUNCLE_TYPE, ENTITY_SYLPH_TYPE, ENTITY_FOLLOW_PROJ, ENTITY_WIXIE_TYPE, ENTITY_FLYING_ITEM, ENTITY_RITUAL, WILDEN_HUNTER, ENTITY_SPELL_ARROW, SUMMON_WOLF, WILDEN_STALKER, SUMMON_HORSE, WILDEN_GUARDIAN, LIGHTNING_ENTITY, ENTITY_DUMMY, ENTITY_DRYGMY, ENTITY_WARD, WILDEN_BOSS, ENTITY_CHIMERA_SPIKE, ENTITY_FAMILIAR_CARBUNCLE, ENTITY_FAMILIAR_BOOKWYRM, ENTITY_FAMILIAR_JABBERWOG, ENTITY_FAMILIAR_WIXIE, ENTITY_FAMILIAR_SYLPH, ENTITY_FAMILIAR_DRYGMY, LINGER_SPELL, ENTITY_CASCADING_WEALD, ENTITY_BLAZING_WEALD, ENTITY_VEXING_WEALD, ENTITY_FLOURISHING_WEALD});
            EntitySpawnPlacementRegistry.func_209343_a(ENTITY_CARBUNCLE_TYPE, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, ModEntities::genericGroundSpawn);
            EntitySpawnPlacementRegistry.func_209343_a(ENTITY_SYLPH_TYPE, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, ModEntities::genericGroundSpawn);
            EntitySpawnPlacementRegistry.func_209343_a(ENTITY_DRYGMY, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, ModEntities::genericGroundSpawn);
            EntitySpawnPlacementRegistry.func_209343_a(WILDEN_GUARDIAN, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, ModEntities::canMonsterSpawnInLight);
            EntitySpawnPlacementRegistry.func_209343_a(WILDEN_HUNTER, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, ModEntities::canMonsterSpawnInLight);
            EntitySpawnPlacementRegistry.func_209343_a(WILDEN_STALKER, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, ModEntities::canMonsterSpawnInLight);
        }

        @SubscribeEvent
        public static void registerEntities(EntityAttributeCreationEvent event) {
            event.put(ENTITY_BOOKWYRM_TYPE, EntityBookwyrm.attributes().func_233813_a_());
            event.put(ALLY_VEX, VexEntity.func_234321_m_().func_233813_a_());
            event.put(ENTITY_CARBUNCLE_TYPE, EntityCarbuncle.attributes().func_233813_a_());
            event.put(ENTITY_SYLPH_TYPE, EntitySylph.attributes().func_233813_a_());
            event.put(ENTITY_DRYGMY, EntitySylph.attributes().func_233813_a_());
            event.put(ENTITY_WIXIE_TYPE, EntityWixie.attributes().func_233813_a_());
            event.put(WILDEN_HUNTER, WildenHunter.getModdedAttributes().func_233813_a_());
            event.put(WILDEN_STALKER, WildenStalker.getModdedAttributes().func_233813_a_());
            event.put(SUMMON_WOLF, WolfEntity.func_234233_eS_().func_233813_a_());
            event.put(SUMMON_HORSE, AbstractHorseEntity.func_234237_fg_().func_233813_a_());
            event.put(WILDEN_GUARDIAN, WildenGuardian.getModdedAttributes().func_233813_a_());
            event.put(ENTITY_DUMMY, MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 20.0).func_233815_a_(Attributes.field_233821_d_, 0.25).func_233813_a_());
            event.put(WILDEN_BOSS, EntityChimera.getModdedAttributes().func_233813_a_());
            event.put(ENTITY_FAMILIAR_CARBUNCLE, FamiliarEntity.attributes().func_233813_a_());
            event.put(ENTITY_FAMILIAR_BOOKWYRM, FamiliarEntity.attributes().func_233813_a_());
            event.put(ENTITY_FAMILIAR_JABBERWOG, FamiliarEntity.attributes().func_233813_a_());
            event.put(ENTITY_FAMILIAR_WIXIE, FamiliarEntity.attributes().func_233813_a_());
            event.put(ENTITY_FAMILIAR_SYLPH, FamiliarEntity.attributes().func_233813_a_());
            event.put(ENTITY_FAMILIAR_DRYGMY, FamiliarEntity.attributes().func_233813_a_());
            event.put(ENTITY_CASCADING_WEALD, WealdWalker.attributes().func_233813_a_());
            event.put(ENTITY_BLAZING_WEALD, WealdWalker.attributes().func_233813_a_());
            event.put(ENTITY_FLOURISHING_WEALD, WealdWalker.attributes().func_233813_a_());
            event.put(ENTITY_VEXING_WEALD, WealdWalker.attributes().func_233813_a_());
        }
    }
}

