/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity;

import com.hollingsworth.arsnouveau.api.client.ITooltipProvider;
import com.hollingsworth.arsnouveau.api.item.IWandable;
import com.hollingsworth.arsnouveau.api.spell.EntitySpellResolver;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.util.NBTUtil;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.block.tile.IAnimationListener;
import com.hollingsworth.arsnouveau.common.entity.EntityProjectileSpell;
import com.hollingsworth.arsnouveau.common.entity.goal.GoBackHomeGoal;
import com.hollingsworth.arsnouveau.common.entity.goal.wealdwalker.CastSpellGoal;
import com.hollingsworth.arsnouveau.common.entity.goal.wealdwalker.SmashGoal;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BoneMealItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class WealdWalker
extends AgeableEntity
implements IAnimatable,
IAnimationListener,
IRangedAttackMob,
IWandable,
ITooltipProvider {
    public static final DataParameter<Boolean> SMASHING = EntityDataManager.func_187226_a(WealdWalker.class, (IDataSerializer)DataSerializers.field_187198_h);
    public static final DataParameter<Boolean> CASTING = EntityDataManager.func_187226_a(WealdWalker.class, (IDataSerializer)DataSerializers.field_187198_h);
    public static final DataParameter<Boolean> BABY = EntityDataManager.func_187226_a(WealdWalker.class, (IDataSerializer)DataSerializers.field_187198_h);
    public static final DataParameter<Optional<BlockPos>> HOME = EntityDataManager.func_187226_a(WealdWalker.class, (IDataSerializer)DataSerializers.field_187201_k);
    public int smashCooldown;
    public int castCooldown;
    public Spell spell = Spell.EMPTY;
    public ParticleColor color = ParticleUtil.defaultParticleColor();
    AnimationFactory factory = new AnimationFactory((IAnimatable)this);

    public WealdWalker(EntityType<? extends AgeableEntity> type, World world) {
        super(type, world);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.smashCooldown > 0) {
            --this.smashCooldown;
        }
        if (this.castCooldown > 0) {
            --this.castCooldown;
        }
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_82737_E() % 20L == 0L && !this.func_233643_dh_()) {
            this.func_70691_i(1.0f);
        }
    }

    public ActionResultType func_230254_b_(PlayerEntity p_230254_1_, Hand p_230254_2_) {
        ItemStack itemstack = p_230254_1_.func_184586_b(p_230254_2_);
        if (itemstack.func_77973_b() instanceof BoneMealItem && this.func_70631_g_()) {
            int i = this.func_70874_b();
            if (this.func_70631_g_()) {
                this.usePlayerItem(p_230254_1_, itemstack);
                this.func_175501_a((int)((float)(-i / 20) * 0.1f), true);
                return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
            }
            if (this.field_70170_p.field_72995_K) {
                return ActionResultType.CONSUME;
            }
        }
        return super.func_230254_b_(p_230254_1_, p_230254_2_);
    }

    protected void usePlayerItem(PlayerEntity p_175505_1_, ItemStack p_175505_2_) {
        if (!p_175505_1_.field_71075_bZ.field_75098_d) {
            p_175505_2_.func_190918_g(1);
        }
    }

    @Override
    public void onFinishedConnectionFirst(@Nullable BlockPos storedPos, @Nullable LivingEntity storedEntity, PlayerEntity playerEntity) {
        if (storedPos != null) {
            this.setHome(storedPos);
            PortUtil.sendMessage((Entity)playerEntity, (ITextComponent)new TranslationTextComponent("ars_nouveau.weald_walker.setpos"));
        }
    }

    public EntitySize func_213305_a(Pose p_213305_1_) {
        return this.func_70631_g_() ? new EntitySize(1.0f, 1.0f, true) : super.func_213305_a(p_213305_1_);
    }

    @Nullable
    public AgeableEntity func_241840_a(ServerWorld p_241840_1_, AgeableEntity p_241840_2_) {
        return null;
    }

    public void func_70645_a(DamageSource source) {
        if (!this.func_70631_g_() && !this.field_70170_p.field_72995_K) {
            this.func_82227_f(true);
            this.func_213323_x_();
            this.func_70606_j(60.0f);
            ParticleUtil.spawnPoof((ServerWorld)this.field_70170_p, this.func_233580_cy_().func_177984_a());
            if (source.func_76346_g() != null && source.func_76346_g() instanceof MobEntity) {
                ((MobEntity)source.func_76346_g()).func_70624_b(null);
            }
            return;
        }
        super.func_70645_a(source);
    }

    public void func_82227_f(boolean baby) {
        super.func_82227_f(baby);
        this.field_70180_af.func_187227_b(BABY, (Object)baby);
    }

    public void func_70873_a(int age) {
        this.field_175504_a = age;
        if (this.field_175504_a >= 0 && !this.field_70170_p.field_72995_K) {
            this.func_175500_n();
        }
    }

    public void setHome(BlockPos home) {
        this.field_70180_af.func_187227_b(HOME, Optional.of(home));
    }

    @Nullable
    public BlockPos getHome() {
        return ((Optional)this.field_70180_af.func_187225_a(HOME)).orElse(null);
    }

    protected void func_175500_n() {
        super.func_175500_n();
        if (!this.field_70170_p.field_72995_K) {
            this.field_70180_af.func_187227_b(BABY, (Object)false);
        }
    }

    public boolean func_70631_g_() {
        return (Boolean)this.field_70180_af.func_187225_a(BABY);
    }

    public void func_184206_a(DataParameter<?> p_184206_1_) {
        if (BABY.equals(p_184206_1_)) {
            this.func_213323_x_();
        }
        super.func_184206_a(p_184206_1_);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new GoBackHomeGoal((MobEntity)this, this::getHome, 10, () -> this.func_70638_az() == null || this.func_70631_g_()));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, MobEntity.class, 5, false, false, entity -> entity instanceof IMob));
        this.field_70714_bg.func_75776_a(8, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new SmashGoal(this, true, () -> this.smashCooldown <= 0 && (Boolean)this.field_70180_af.func_187225_a(BABY) == false, Animations.SMASH.ordinal(), 25, 5));
        this.field_70714_bg.func_75776_a(2, (Goal)new CastSpellGoal(this, 1.2, 20, 15.0f, () -> this.castCooldown <= 0 && (Boolean)this.field_70180_af.func_187225_a(BABY) == false, Animations.CAST.ordinal(), 20));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SMASHING, (Object)false);
        this.field_70180_af.func_187214_a(CASTING, (Object)false);
        this.field_70180_af.func_187214_a(BABY, (Object)false);
        this.field_70180_af.func_187214_a(HOME, Optional.empty());
    }

    public void func_213281_b(CompoundNBT tag) {
        super.func_213281_b(tag);
        tag.func_74757_a("isBaby", ((Boolean)this.field_70180_af.func_187225_a(BABY)).booleanValue());
        NBTUtil.storeBlockPos(tag, "home", this.getHome());
        tag.func_74768_a("smash", this.smashCooldown);
        tag.func_74768_a("cast", this.castCooldown);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source == DamageSource.field_76367_g || source == DamageSource.field_220302_v || source == DamageSource.field_76369_e) {
            return false;
        }
        return super.func_70097_a(source, amount);
    }

    public void func_70037_a(CompoundNBT tag) {
        super.func_70037_a(tag);
        this.field_70180_af.func_187227_b(BABY, (Object)tag.func_74767_n("isBaby"));
        if (NBTUtil.hasBlockPos(tag, "home")) {
            this.setHome(NBTUtil.getBlockPos(tag, "home"));
        }
        this.smashCooldown = tag.func_74762_e("smash");
        this.castCooldown = tag.func_74762_e("cast");
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "run_controller", 1.0f, this::runController));
        data.addAnimationController(new AnimationController((IAnimatable)this, "attack_controller", 5.0f, this::attackController));
    }

    private PlayState attackController(AnimationEvent animationEvent) {
        return PlayState.CONTINUE;
    }

    private PlayState runController(AnimationEvent animationEvent) {
        if (((Boolean)this.field_70180_af.func_187225_a(SMASHING)).booleanValue() || ((Boolean)this.field_70180_af.func_187225_a(CASTING)).booleanValue()) {
            return PlayState.STOP;
        }
        if (animationEvent.getController().getCurrentAnimation() != null && !animationEvent.getController().getCurrentAnimation().animationName.equals("run_master")) {
            return PlayState.STOP;
        }
        if (animationEvent.isMoving()) {
            animationEvent.getController().setAnimation(new AnimationBuilder().addAnimation("run_master"));
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    @Override
    public void startAnimation(int arg) {
        try {
            AnimationController controller;
            if (arg == Animations.SMASH.ordinal()) {
                controller = (AnimationController)this.factory.getOrCreateAnimationData(this.hashCode()).getAnimationControllers().get("attack_controller");
                if (controller.getCurrentAnimation() != null && controller.getCurrentAnimation().animationName.equals("smash")) {
                    return;
                }
                controller.markNeedsReload();
                controller.setAnimation(new AnimationBuilder().addAnimation("smash", Boolean.valueOf(false)).addAnimation("idle", Boolean.valueOf(false)));
            }
            if (arg == Animations.CAST.ordinal()) {
                controller = (AnimationController)this.factory.getOrCreateAnimationData(this.hashCode()).getAnimationControllers().get("attack_controller");
                if (controller.getCurrentAnimation() != null && controller.getCurrentAnimation().animationName.equals("cast")) {
                    return;
                }
                controller.markNeedsReload();
                controller.setAnimation(new AnimationBuilder().addAnimation("cast", Boolean.valueOf(false)).addAnimation("idle", Boolean.valueOf(false)));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static AttributeModifierMap.MutableAttribute attributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 60.0).func_233815_a_(Attributes.field_233821_d_, 0.2).func_233815_a_(Attributes.field_233819_b_, 16.0).func_233815_a_(Attributes.field_233823_f_, 10.5);
    }

    public void func_70623_bb() {
        super.func_70623_bb();
    }

    public boolean func_213397_c(double p_213397_1_) {
        return false;
    }

    protected int func_70693_a(PlayerEntity p_70693_1_) {
        return 0;
    }

    public void func_82196_d(LivingEntity p_82196_1_, float p_82196_2_) {
        EntitySpellResolver resolver = new EntitySpellResolver(new SpellContext(this.spell, (LivingEntity)this).withColors(this.color.toWrapper()));
        EntityProjectileSpell projectileSpell = new EntityProjectileSpell(this.field_70170_p, resolver);
        projectileSpell.setColor(this.color.toWrapper());
        projectileSpell.shoot((Entity)this, this.field_70125_A, this.field_70177_z, 0.0f, 1.0f, 0.8f);
        this.field_70170_p.func_217376_c((Entity)projectileSpell);
        this.castCooldown = 40;
    }

    @Override
    public List<String> getTooltip() {
        ArrayList<String> tips = new ArrayList<String>();
        if (this.getHome() != null) {
            String home = this.getHome().func_177958_n() + ", " + this.getHome().func_177956_o() + ", " + this.getHome().func_177952_p();
            tips.add(new TranslationTextComponent("ars_nouveau.weald_walker.home", new Object[]{home}).getString());
        } else {
            tips.add(new TranslationTextComponent("ars_nouveau.weald_walker.home", new Object[]{new TranslationTextComponent("ars_nouveau.nothing").getString()}).getString());
        }
        return tips;
    }

    public static enum Animations {
        CAST,
        SMASH;

    }
}

