/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity.goal.chimera;

import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.entity.EntityChimera;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketAnimEntity;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.pathfinding.Path;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class ChimeraRamGoal
extends Goal {
    EntityChimera boss;
    int timeCharging;
    boolean finished;
    boolean startedCharge;
    boolean isCharging;
    boolean hasHit;

    public ChimeraRamGoal(EntityChimera boss) {
        this.boss = boss;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean func_220685_C_() {
        return false;
    }

    public void func_75249_e() {
        super.func_75249_e();
        this.timeCharging = 0;
        this.finished = false;
        this.startedCharge = false;
        this.isCharging = false;
        this.hasHit = false;
        this.boss.isRamming = true;
    }

    public void func_75246_d() {
        super.func_75246_d();
        if (this.timeCharging >= 105) {
            this.endRam();
        }
        if (this.boss.func_70638_az() == null) {
            this.endRam();
        }
        if (!this.startedCharge) {
            Networking.sendToNearby(this.boss.field_70170_p, (Entity)this.boss, (Object)new PacketAnimEntity(this.boss.func_145782_y(), EntityChimera.Animations.CHARGE.ordinal()));
            this.startedCharge = true;
        }
        ++this.timeCharging;
        if (this.timeCharging <= 25 && !this.isCharging) {
            LivingEntity livingentity = this.boss.func_70638_az();
            if (livingentity != null) {
                this.boss.func_70671_ap().func_75651_a((Entity)livingentity, 30.0f, 30.0f);
            }
            this.boss.func_70661_as().func_75499_g();
        }
        if (this.timeCharging > 25) {
            this.isCharging = true;
        }
        if (this.isCharging) {
            if (this.boss.func_70661_as() == null || this.boss.func_70638_az() == null) {
                this.attack();
                return;
            }
            this.breakBlocks();
            Path path = this.boss.func_70661_as().func_179680_a(this.boss.func_70638_az().func_233580_cy_().func_177984_a(), 1);
            if (path == null) {
                return;
            }
            this.breakBlocks();
            this.boss.func_70661_as().func_75484_a(path, 2.0);
            this.attack();
        }
        if (this.boss != null && this.boss.func_70638_az() != null && this.hasHit && BlockUtil.distanceFrom(this.boss.field_233557_ao_, this.boss.func_70638_az().field_233557_ao_) <= 2.0) {
            this.endRam();
        }
    }

    public void breakBlocks() {
        if (!ForgeEventFactory.getMobGriefingEvent((World)this.boss.field_70170_p, (Entity)this.boss)) {
            return;
        }
        Direction facing = this.boss.func_174811_aO();
        BlockPos facingPos = this.boss.func_233580_cy_().func_177984_a().func_177972_a(facing);
        for (int i = 0; i < 2; ++i) {
            facingPos = facingPos.func_177981_b(i);
            this.destroyBlock(facingPos.func_177984_a());
            this.destroyBlock(facingPos.func_177974_f());
            this.destroyBlock(facingPos.func_177976_e());
            this.destroyBlock(facingPos.func_177968_d());
            this.destroyBlock(facingPos.func_177978_c());
        }
    }

    public void destroyBlock(BlockPos pos) {
        if (this.boss.field_70170_p.func_180495_p(pos).getHarvestLevel() < 9999 && this.boss.field_70170_p.func_180495_p(pos).func_185887_b((IBlockReader)this.boss.field_70170_p, pos) >= 0.0f) {
            this.boss.field_70170_p.func_175655_b(pos, true);
        }
    }

    public void func_75251_c() {
        super.func_75251_c();
        this.boss.isRamming = false;
    }

    public void endRam() {
        this.finished = true;
        if (this.boss.field_70170_p.field_73012_v.nextInt(3) != 0) {
            this.boss.ramCooldown = (int)(400.0 + ParticleUtil.inRange(-100.0, 100 + this.boss.getCooldownModifier()));
        }
        this.boss.isRamming = false;
        Networking.sendToNearby(this.boss.field_70170_p, (Entity)this.boss, (Object)new PacketAnimEntity(this.boss.func_145782_y(), EntityChimera.Animations.ATTACK.ordinal()));
        this.attack();
    }

    protected void attack() {
        List nearbyEntities = this.boss.field_70170_p.func_217357_a(LivingEntity.class, new AxisAlignedBB(this.boss.func_233580_cy_()).func_72314_b(1.0, 1.0, 1.0));
        for (LivingEntity enemy : nearbyEntities) {
            if (enemy.equals((Object)this.boss)) continue;
            this.boss.func_70652_k((Entity)enemy);
            enemy.func_233627_a_(3.0f, (double)MathHelper.func_76126_a((float)(this.boss.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.boss.field_70177_z * ((float)Math.PI / 180)))));
            this.hasHit = true;
        }
    }

    public boolean func_75253_b() {
        return !this.finished && !this.boss.getPhaseSwapping();
    }

    public boolean func_75250_a() {
        return this.boss.func_70638_az() != null && this.boss.ramCooldown <= 0 && this.boss.canRam();
    }
}

