/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.event.timed;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.api.event.ITimedEvent;
import com.hollingsworth.arsnouveau.api.util.NBTUtil;
import com.hollingsworth.arsnouveau.client.particle.GlowParticleData;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;

public class EruptionEvent
implements ITimedEvent {
    int delay;
    BlockPos origin;
    World world;
    int start;
    int particleDelay;
    public static final String ID = "eruption";

    public EruptionEvent(World world, BlockPos origin, int delay, int particleDelay) {
        this.world = world;
        this.origin = origin;
        this.delay = delay;
        this.start = delay;
        this.particleDelay = particleDelay;
    }

    @Override
    public void tick(boolean serverSide) {
        --this.delay;
        if (!serverSide && this.start - this.delay >= this.particleDelay && this.world.field_73012_v.nextInt(5) == 0) {
            int i;
            int intensity = 50;
            ParticleColor centerColor = new ParticleColor(255, 50, 50);
            double xzOffset = 0.25;
            BlockPos pos = this.origin;
            for (i = 0; i < intensity; ++i) {
                this.world.func_195594_a(GlowParticleData.createData(centerColor), (double)pos.func_177958_n() + 0.5 + ParticleUtil.inRange(-xzOffset / 2.0, xzOffset / 2.0), (double)(pos.func_177956_o() + 1) + ParticleUtil.inRange(-0.05, 0.2), (double)pos.func_177952_p() + 0.5 + ParticleUtil.inRange(-xzOffset / 2.0, xzOffset / 2.0), 0.0, ParticleUtil.inRange(0.0, 0.05f), 0.0);
            }
            for (i = 0; i < intensity; ++i) {
                this.world.func_195594_a(GlowParticleData.createData(centerColor), (double)pos.func_177958_n() + 0.5 + ParticleUtil.inRange(-xzOffset, xzOffset), (double)(pos.func_177956_o() + 1) + ParticleUtil.inRange(0.0, 0.7), (double)pos.func_177952_p() + 0.5 + ParticleUtil.inRange(-xzOffset, xzOffset), 0.0, ParticleUtil.inRange(0.0, 0.05f), 0.0);
            }
        }
        if (serverSide && this.delay <= 0) {
            this.world.func_217385_a(null, (double)this.origin.func_177958_n(), (double)this.origin.func_177956_o(), (double)this.origin.func_177952_p(), 5.0f, Explosion.Mode.NONE);
        }
    }

    @Override
    public boolean isExpired() {
        return this.delay <= 0;
    }

    @Override
    public CompoundNBT serialize(CompoundNBT tag) {
        ITimedEvent.super.serialize(tag);
        NBTUtil.storeBlockPos(tag, "pos", this.origin);
        tag.func_74768_a("delay", this.delay);
        tag.func_74768_a("particleDelay", this.particleDelay);
        return tag;
    }

    public static EruptionEvent get(CompoundNBT tag) {
        return new EruptionEvent(ArsNouveau.proxy.getClientWorld(), NBTUtil.getBlockPos(tag, "pos"), tag.func_74762_e("delay"), tag.func_74762_e("particleDelay"));
    }

    @Override
    public String getID() {
        return ID;
    }
}

