/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.items;

import com.hollingsworth.arsnouveau.common.block.tile.PotionJarTile;
import com.hollingsworth.arsnouveau.common.items.ModItem;
import com.hollingsworth.arsnouveau.setup.ItemsRegistry;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DrinkHelper;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public abstract class PotionFlask
extends ModItem {
    public PotionFlask() {
        super(ItemsRegistry.defaultItemProperties().func_200917_a(1));
        this.setRegistryName("potion_flask");
    }

    public PotionFlask(Item.Properties props, String registryName) {
        super(props);
        this.setRegistryName(registryName);
    }

    public PotionFlask(String registryName) {
        super(ItemsRegistry.defaultItemProperties().func_200917_a(1));
        this.setRegistryName(registryName);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        if (context.func_195991_k().field_72995_K) {
            return super.func_195939_a(context);
        }
        ItemStack thisStack = context.func_195996_i();
        if (!thisStack.func_77942_o()) {
            thisStack.func_77982_d(new CompoundNBT());
        }
        Potion potion = PotionUtils.func_185191_c((ItemStack)thisStack);
        PlayerEntity playerEntity = context.func_195999_j();
        if (!(context.func_195991_k().func_175625_s(context.func_195995_a()) instanceof PotionJarTile)) {
            return super.func_195939_a(context);
        }
        PotionJarTile jarTile = (PotionJarTile)context.func_195991_k().func_175625_s(context.func_195995_a());
        int count = thisStack.func_196082_o().func_74762_e("count");
        if (jarTile == null) {
            return ActionResultType.PASS;
        }
        if (playerEntity.func_225608_bj_() && potion != Potions.field_185229_a && count > 0 && jarTile.getMaxFill() - jarTile.getCurrentFill() >= 0 && (jarTile.getPotion() == Potions.field_185229_a || jarTile.isMixEqual(thisStack))) {
            if (jarTile.getPotion() == Potions.field_185229_a) {
                jarTile.setPotion(potion, PotionUtils.func_185189_a((ItemStack)thisStack));
            }
            jarTile.addAmount(100);
            thisStack.func_196082_o().func_74768_a("count", count - 1);
            this.setCount(thisStack, count - 1);
        }
        if (context.func_195991_k().func_175625_s(context.func_195995_a()) instanceof PotionJarTile && !playerEntity.func_225608_bj_() && !this.isMax(thisStack) && jarTile.getPotion() != Potions.field_185229_a && (jarTile.isMixEqual(thisStack) || potion == Potions.field_185229_a) && jarTile.getAmount() >= 100) {
            if (potion == Potions.field_185229_a) {
                PotionUtils.func_185188_a((ItemStack)thisStack, (Potion)jarTile.getPotion());
                PotionUtils.func_185184_a((ItemStack)thisStack, jarTile.getCustomEffects());
            }
            this.setCount(thisStack, 1 + count);
            jarTile.addAmount(-100);
        }
        return super.func_195939_a(context);
    }

    public boolean isMax(ItemStack stack) {
        return stack.func_196082_o().func_74762_e("count") >= this.getMaxCapacity();
    }

    public int getMaxCapacity() {
        return 8;
    }

    public void setCount(ItemStack stack, int count) {
        stack.func_196082_o().func_74768_a("count", count);
        if (count <= 0) {
            PotionUtils.func_185188_a((ItemStack)stack, (Potion)Potions.field_185229_a);
            stack.func_196082_o().func_82580_o("CustomPotionEffects");
        }
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, LivingEntity entityLiving) {
        PlayerEntity playerentity;
        PlayerEntity playerEntity = playerentity = entityLiving instanceof PlayerEntity ? (PlayerEntity)entityLiving : null;
        if (playerentity instanceof ServerPlayerEntity) {
            CriteriaTriggers.field_193138_y.func_193148_a((ServerPlayerEntity)playerentity, stack);
        }
        if (!worldIn.field_72995_K) {
            for (EffectInstance effectinstance : PotionUtils.func_185189_a((ItemStack)stack)) {
                if ((effectinstance = this.getEffectInstance(effectinstance)).func_188419_a().func_76403_b()) {
                    effectinstance.func_188419_a().func_180793_a((Entity)playerentity, (Entity)playerentity, entityLiving, effectinstance.func_76458_c(), 1.0);
                    continue;
                }
                entityLiving.func_195064_c(new EffectInstance(effectinstance));
            }
            int count = stack.func_196082_o().func_74762_e("count") - 1;
            this.setCount(stack, count);
        }
        return stack;
    }

    @Nonnull
    public abstract EffectInstance getEffectInstance(EffectInstance var1);

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
        if (!worldIn.field_72995_K && !stack.func_77942_o()) {
            stack.func_77982_d(new CompoundNBT());
        }
    }

    public int func_77626_a(ItemStack stack) {
        return 32;
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.DRINK;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        return stack.func_196082_o().func_74762_e("count") > 0 ? DrinkHelper.func_234707_a_((World)worldIn, (PlayerEntity)playerIn, (Hand)handIn) : ActionResult.func_226250_c_((Object)playerIn.func_184586_b(handIn));
    }

    @Override
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        if (stack.func_77942_o()) {
            tooltip.add((ITextComponent)new TranslationTextComponent("ars_nouveau.flask.charges", new Object[]{stack.func_196082_o().func_74762_e("count")}));
            PotionUtils.func_185182_a((ItemStack)stack, tooltip, (float)1.0f);
        }
    }
}

