/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.items;

import com.hollingsworth.arsnouveau.api.item.ICasterTool;
import com.hollingsworth.arsnouveau.api.mana.IMana;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.ISpellCaster;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.common.capability.ManaCapability;
import com.hollingsworth.arsnouveau.common.entity.EntitySpellArrow;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentPierce;
import com.hollingsworth.arsnouveau.setup.ItemsRegistry;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.ArrowEntity;
import net.minecraft.item.ArrowItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class SpellArrow
extends ArrowItem {
    public AbstractSpellPart part;
    public int numParts;

    public SpellArrow(String registryName, AbstractAugment augment, int numParts) {
        super(ItemsRegistry.defaultItemProperties());
        this.setRegistryName("ars_nouveau", registryName);
        this.part = augment;
        this.numParts = numParts;
    }

    public void modifySpell(Spell spell) {
        for (int i = 0; i < this.numParts; ++i) {
            spell.recipe.add(this.part);
        }
    }

    public AbstractArrowEntity func_200887_a(World world, ItemStack stack, LivingEntity shooter) {
        IMana mana = (IMana)ManaCapability.getMana(shooter).orElse(null);
        if (mana == null) {
            return new ArrowEntity(world, shooter);
        }
        EntitySpellArrow spellArrow = new EntitySpellArrow(world, shooter);
        if (!(shooter instanceof PlayerEntity) || !(shooter.func_184614_ca().func_77973_b() instanceof ICasterTool)) {
            return super.func_200887_a(world, stack, shooter);
        }
        PlayerEntity entity = (PlayerEntity)shooter;
        ICasterTool caster = (ICasterTool)entity.func_184614_ca().func_77973_b();
        ISpellCaster spellCaster = caster.getSpellCaster(entity.func_184614_ca());
        Spell spell = spellCaster.getSpell();
        this.modifySpell(spell);
        spell.setCost(spell.getCastingCost() - this.part.getManaCost() * this.numParts);
        spellArrow.spellResolver = new SpellResolver(new SpellContext(spell, (LivingEntity)entity)).withSilent(true);
        spellArrow.pierceLeft = spell.getBuffsAtIndex(0, shooter, AugmentPierce.class);
        return spellArrow;
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)new TranslationTextComponent("ars_nouveau.spell_arrow.desc"));
        Spell spell = new Spell();
        for (int i = 0; i < this.numParts; ++i) {
            spell.recipe.add(this.part);
        }
        tooltip.add((ITextComponent)new StringTextComponent(spell.getDisplayString()));
    }
}

