/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.network;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.common.capability.ManaCapability;
import java.util.function.Supplier;
import net.minecraft.entity.LivingEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketUpdateMana {
    public double mana;
    public int maxMana;
    public int glyphBonus;
    public int tierBonus;

    public PacketUpdateMana(PacketBuffer buf) {
        this.mana = buf.readDouble();
        this.maxMana = buf.readInt();
        this.glyphBonus = buf.readInt();
        this.tierBonus = buf.readInt();
    }

    public void toBytes(PacketBuffer buf) {
        buf.writeDouble(this.mana);
        buf.writeInt(this.maxMana);
        buf.writeInt(this.glyphBonus);
        buf.writeInt(this.tierBonus);
    }

    public PacketUpdateMana(double mana, int maxMana, int glyphBonus, int tierBonus) {
        this.mana = mana;
        this.maxMana = maxMana;
        this.glyphBonus = glyphBonus;
        this.tierBonus = tierBonus;
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (ArsNouveau.proxy.getPlayer() == null) {
                return;
            }
            ManaCapability.getMana((LivingEntity)ArsNouveau.proxy.getPlayer()).ifPresent(mana -> {
                mana.setMana(this.mana);
                mana.setMaxMana(this.maxMana);
                mana.setGlyphBonus(this.glyphBonus);
                mana.setBookTier(this.tierBonus);
            });
        });
        ctx.get().setPacketHandled(true);
    }
}

