/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.ritual;

import com.hollingsworth.arsnouveau.api.ritual.AbstractRitual;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.common.entity.EntityChimera;
import com.hollingsworth.arsnouveau.common.entity.WildenGuardian;
import com.hollingsworth.arsnouveau.common.entity.WildenHunter;
import com.hollingsworth.arsnouveau.common.entity.WildenStalker;
import com.hollingsworth.arsnouveau.setup.ItemsRegistry;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;

public class RitualWildenSummoning
extends AbstractRitual {
    @Override
    protected void tick() {
        EntityChimera.spawnPhaseParticles(this.getPos().func_177984_a(), this.getWorld(), 1);
        if (this.getWorld().func_82737_E() % 20L == 0L) {
            this.incrementProgress();
        }
        if (this.getWorld().func_82737_E() % 60L == 0L && !this.getWorld().field_72995_K) {
            if (!this.isBossSpawn()) {
                MonsterEntity mobEntity;
                int wild = this.rand.nextInt(3);
                BlockPos summonPos = this.getPos().func_177984_a().func_177965_g(this.rand.nextInt(3) - this.rand.nextInt(6)).func_177964_d(this.rand.nextInt(3) - this.rand.nextInt(6));
                switch (wild) {
                    case 0: {
                        mobEntity = new WildenStalker(this.getWorld());
                        break;
                    }
                    case 1: {
                        mobEntity = new WildenGuardian(this.getWorld());
                        break;
                    }
                    default: {
                        mobEntity = new WildenHunter(this.getWorld());
                    }
                }
                this.summon((MobEntity)mobEntity, summonPos);
                if (this.getProgress() >= 15) {
                    this.setFinished();
                }
            } else if (this.getProgress() >= 8) {
                BlockPos.func_218281_b((BlockPos)this.getPos().func_177965_g(5).func_177964_d(5).func_177984_a(), (BlockPos)this.getPos().func_177985_f(5).func_177970_e(5).func_177981_b(5)).forEach(p -> BlockUtil.destroyBlockSafelyWithoutSound(this.getWorld(), p, true));
                EntityChimera chimera = new EntityChimera(this.getWorld());
                this.summon((MobEntity)chimera, this.getPos().func_177984_a());
                this.setFinished();
            }
        }
    }

    public boolean isBossSpawn() {
        return this.didConsumeItem(ItemsRegistry.WILDEN_HORN) && this.didConsumeItem(ItemsRegistry.WILDEN_WING) && this.didConsumeItem(ItemsRegistry.WILDEN_SPIKE);
    }

    public void summon(MobEntity mob, BlockPos pos) {
        mob.func_70107_b((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        mob.field_70170_p.func_217376_c((Entity)mob);
    }

    @Override
    public String getLangName() {
        return "Summon Wilden";
    }

    @Override
    public String getLangDescription() {
        return "Without augments, this ritual will summon a random variety of Wilden monsters for a short duration. When augmented with a Wilden Spike, Wilden Horn, and a Wilden Wing, this ritual will summon the Wilden Chimera, a challenging and destructive monster. Note: If summoning the chimera, this ritual will destroy blocks around the brazier.";
    }

    @Override
    public boolean canConsumeItem(ItemStack stack) {
        Item item = stack.func_77973_b();
        return item == ItemsRegistry.WILDEN_SPIKE || item == ItemsRegistry.WILDEN_WING || item == ItemsRegistry.WILDEN_HORN;
    }

    @Override
    public String getID() {
        return "wilden_summon";
    }
}

