/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.util;

import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraftforge.common.ForgeConfigSpec;

public class SpellPartConfigUtil {
    private static final Pattern AUGMENT_LIMITS_PATTERN = Pattern.compile("([^/=]+)=(\\p{Digit}+)");

    public static AugmentLimits buildAugmentLimitsConfig(ForgeConfigSpec.Builder builder, Map<String, Integer> defaults) {
        ForgeConfigSpec.ConfigValue configValue = builder.comment(new String[]{"Limits the number of times a given augment may be applied to a given effect", "Example entry: \"amplify=5\""}).defineList("augment_limits", SpellPartConfigUtil.writeConfig(defaults), SpellPartConfigUtil::validateAugmentLimits);
        return new AugmentLimits(configValue);
    }

    private static List<String> writeConfig(Map<String, Integer> augmentLimits) {
        return augmentLimits.entrySet().stream().map(e -> (String)e.getKey() + "=" + ((Integer)e.getValue()).toString()).collect(Collectors.toList());
    }

    private static boolean validateAugmentLimits(Object rawConfig) {
        if (rawConfig instanceof CharSequence) {
            return AUGMENT_LIMITS_PATTERN.matcher((CharSequence)rawConfig).matches();
        }
        return false;
    }

    public static class AugmentLimits {
        private Map<String, Integer> limits = null;
        private ForgeConfigSpec.ConfigValue<List<? extends String>> configValue;

        private AugmentLimits(ForgeConfigSpec.ConfigValue<List<? extends String>> configValue) {
            this.configValue = configValue;
        }

        public int getAugmentLimit(String augmentTag) {
            if (this.limits == null) {
                this.limits = this.parseAugmentLimits();
            }
            return this.limits.getOrDefault(augmentTag, Integer.MAX_VALUE);
        }

        public void setAugmentLimit(String augmentTag, int limit) {
            if (this.limits == null) {
                this.limits = this.parseAugmentLimits();
            }
            this.limits.put(augmentTag, limit);
            this.configValue.set((Object)SpellPartConfigUtil.writeConfig(this.limits));
        }

        private Map<String, Integer> parseAugmentLimits() {
            return ((List)this.configValue.get()).stream().map(AUGMENT_LIMITS_PATTERN::matcher).filter(Matcher::matches).collect(Collectors.toMap(m -> m.group(1), m -> Integer.valueOf(m.group(2))));
        }
    }
}

