/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.chunk;

import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.server.ServerWorld;
import org.jetbrains.annotations.Nullable;

public class SafeBlockGetter
implements IBlockReader {
    private final ServerWorld wrapped;
    private final Thread mainThread;

    public SafeBlockGetter(ServerWorld wrapped) {
        this.wrapped = wrapped;
        this.mainThread = Thread.currentThread();
    }

    public boolean shouldUse() {
        return Thread.currentThread() != this.mainThread;
    }

    @Nullable
    private IBlockReader getChunkSafe(BlockPos pos) {
        IBlockReader access = this.wrapped.func_72863_F().func_217202_b(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
        if (!(access instanceof IChunk)) {
            return null;
        }
        IChunk chunk = (IChunk)access;
        if (!chunk.func_201589_g().func_209003_a(ChunkStatus.field_222617_m)) {
            return null;
        }
        return chunk;
    }

    public int func_217301_I() {
        return this.wrapped.func_217301_I();
    }

    public int func_201572_C() {
        return this.wrapped.func_201572_C();
    }

    @Nullable
    public TileEntity func_175625_s(BlockPos pos) {
        IBlockReader g = this.getChunkSafe(pos);
        return g == null ? null : g.func_175625_s(pos);
    }

    public BlockState func_180495_p(BlockPos pos) {
        IBlockReader g = this.getChunkSafe(pos);
        return g == null ? Blocks.field_150350_a.func_176223_P() : g.func_180495_p(pos);
    }

    public FluidState func_204610_c(BlockPos pos) {
        IBlockReader g = this.getChunkSafe(pos);
        return g == null ? Fluids.field_204541_a.func_207188_f() : g.func_204610_c(pos);
    }
}

