/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.common.mixin.perf.faster_item_rendering;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemTransformVec3f;
import net.minecraft.client.renderer.model.SimpleBakedModel;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import org.embeddedt.modernfix.annotation.ClientOnlyMixin;
import org.embeddedt.modernfix.forge.shadow.mixinextras.sugar.Local;
import org.embeddedt.modernfix.render.FastItemRenderType;
import org.embeddedt.modernfix.render.RenderState;
import org.embeddedt.modernfix.render.SimpleItemModelView;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemRenderer.class}, priority=600)
@ClientOnlyMixin
public abstract class ItemRendererMixin {
    private ItemCameraTransforms.TransformType transformType;
    private final SimpleItemModelView modelView = new SimpleItemModelView();

    @Inject(method={"render"}, at={@At(value="HEAD")})
    private void markRenderingType(ItemStack itemStack, ItemCameraTransforms.TransformType transformType, boolean leftHand, MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay, IBakedModel model, CallbackInfo ci) {
        this.transformType = transformType;
    }

    @ModifyArg(method={"render"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/entity/ItemRenderer;renderModelLists(Lnet/minecraft/client/resources/model/BakedModel;Lnet/minecraft/world/item/ItemStack;IILcom/mojang/blaze3d/vertex/PoseStack;Lcom/mojang/blaze3d/vertex/VertexConsumer;)V"), index=0)
    private IBakedModel useSimpleWrappedItemModel(IBakedModel model, ItemStack stack, int combinedLight, int combinedOverlay, MatrixStack matrixStack, IVertexBuilder buffer, @Local(ordinal=0) IBakedModel originalModel) {
        if (originalModel != null && originalModel.getClass() != SimpleBakedModel.class) {
            return model;
        }
        if (!RenderState.IS_RENDERING_LEVEL && !stack.func_190926_b() && model.getClass() == SimpleBakedModel.class && this.transformType == ItemCameraTransforms.TransformType.GUI) {
            FastItemRenderType type;
            ItemTransformVec3f transform = model.func_177552_f().field_178354_e;
            if (transform == ItemTransformVec3f.field_178366_a) {
                type = FastItemRenderType.SIMPLE_ITEM;
            } else if (stack.func_77973_b() instanceof BlockItem && this.isBlockTransforms(transform)) {
                type = FastItemRenderType.SIMPLE_BLOCK;
            } else {
                return model;
            }
            this.modelView.setItem(model);
            this.modelView.setType(type);
            return this.modelView;
        }
        return model;
    }

    private boolean isBlockTransforms(ItemTransformVec3f transform) {
        return transform.field_178364_b.func_195899_a() == 30.0f && transform.field_178364_b.func_195900_b() == 225.0f && transform.field_178364_b.func_195902_c() == 0.0f;
    }
}

