/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.common.mixin.perf.faster_texture_stitching;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.client.renderer.StitcherException;
import net.minecraft.client.renderer.texture.Stitcher;
import org.embeddedt.modernfix.ModernFix;
import org.embeddedt.modernfix.annotation.ClientOnlyMixin;
import org.embeddedt.modernfix.platform.ModernFixPlatformHooks;
import org.embeddedt.modernfix.textures.StbStitcher;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Stitcher.class})
@ClientOnlyMixin
public class StitcherMixin {
    @Shadow
    @Final
    private Set<Stitcher.Holder> field_94319_a;
    @Shadow
    private int field_94318_c;
    @Shadow
    private int field_94315_d;
    @Shadow
    @Final
    private static Comparator<Stitcher.Holder> field_217797_a;
    @Shadow
    @Final
    private int field_94316_e;
    @Shadow
    @Final
    private int field_94313_f;
    private List<StbStitcher.LoadableSpriteInfo> loadableSpriteInfos;

    @Inject(method={"stitch"}, at={@At(value="HEAD")}, cancellable=true)
    private void stitchFast(CallbackInfo ci) {
        this.loadableSpriteInfos = null;
        if (!ModernFixPlatformHooks.INSTANCE.isLoadingNormally()) {
            ModernFix.LOGGER.error("Using vanilla stitcher implementation due to invalid loading state");
            return;
        }
        if (this.field_94319_a.size() < 100) {
            return;
        }
        ci.cancel();
        ObjectArrayList holderList = new ObjectArrayList(this.field_94319_a);
        holderList.sort(field_217797_a);
        Stitcher.Holder[] aholder = (Stitcher.Holder[])holderList.toArray((Object[])new Stitcher.Holder[0]);
        Pair<Pair<Integer, Integer>, List<StbStitcher.LoadableSpriteInfo>> packingInfo = StbStitcher.packRects(aholder);
        this.field_94318_c = (Integer)((Pair)packingInfo.getFirst()).getFirst();
        this.field_94315_d = (Integer)((Pair)packingInfo.getFirst()).getSecond();
        if (this.field_94318_c > this.field_94316_e || this.field_94315_d > this.field_94313_f) {
            ModernFix.LOGGER.error("Requested atlas size {}x{} exceeds maximum of {}x{}", (Object)this.field_94318_c, (Object)this.field_94315_d, (Object)this.field_94316_e, (Object)this.field_94313_f);
            throw new StitcherException(aholder[0].field_229213_a_, (Collection)Stream.of(aholder).map(arg -> arg.field_229213_a_).collect(ImmutableList.toImmutableList()));
        }
        this.loadableSpriteInfos = (List)packingInfo.getSecond();
    }

    @Inject(method={"gatherSprites"}, at={@At(value="HEAD")}, cancellable=true)
    private void gatherSpritesFast(Stitcher.ISpriteLoader spriteLoader, CallbackInfo ci) {
        if (this.loadableSpriteInfos == null) {
            return;
        }
        ci.cancel();
        for (StbStitcher.LoadableSpriteInfo info : this.loadableSpriteInfos) {
            spriteLoader.load(info.info, info.width, info.height, info.x, info.y);
        }
    }
}

