/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.forge.mixin.bugfix.entity_load_deadlock;

import net.minecraft.world.chunk.Chunk;
import org.embeddedt.modernfix.forge.ducks.ILevelChunk;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Chunk.class})
public class LevelChunkMixin
implements ILevelChunk {
    private Runnable entityLoadHook;
    private boolean entitiesWereLoaded = false;

    @Override
    public void setEntityLoadHook(@Nullable Runnable loadHook) {
        this.entityLoadHook = loadHook;
    }

    @Inject(method={"setLoaded"}, at={@At(value="RETURN")})
    private void clearLoadHook(boolean bl, CallbackInfo ci) {
        if (!bl) {
            this.entityLoadHook = null;
        }
    }

    @Override
    public void runEntityLoadHook() {
        if (this.entityLoadHook != null) {
            this.entityLoadHook.run();
            this.entitiesWereLoaded = true;
            this.entityLoadHook = null;
        }
    }

    @Override
    public boolean getEntitiesWereLoaded() {
        return this.entitiesWereLoaded;
    }
}

