/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.forge.mixin.bugfix.model_data_manager_cme;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelDataManager;
import org.embeddedt.modernfix.annotation.ClientOnlyMixin;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={ModelDataManager.class})
@ClientOnlyMixin
public abstract class ModelDataManagerMixin {
    @Shadow
    @Final
    private static Map<ChunkPos, Set<BlockPos>> needModelDataRefresh;

    @Shadow
    protected static void refreshModelData(World world, ChunkPos chunk) {
        throw new AssertionError();
    }

    @ModifyArg(method={"requestModelDataRefresh"}, at=@At(value="INVOKE", target="Ljava/util/Map;computeIfAbsent(Ljava/lang/Object;Ljava/util/function/Function;)Ljava/lang/Object;", ordinal=0), index=1)
    private static Function<ChunkPos, Set<BlockPos>> changeTypeOfSetUsed(Function<ChunkPos, Set<BlockPos>> mappingFunction) {
        return pos -> Collections.newSetFromMap(new ConcurrentHashMap());
    }

    @Redirect(method={"getModelData(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/level/ChunkPos;)Ljava/util/Map;"}, at=@At(value="INVOKE", target="Lnet/minecraftforge/client/model/ModelDataManager;refreshModelData(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/level/ChunkPos;)V"))
    private static void onlyRefreshOnMainThread(World toUpdate, ChunkPos pos) {
        if (Minecraft.func_71410_x().func_213162_bc() && !needModelDataRefresh.isEmpty()) {
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    ModelDataManagerMixin.refreshModelData(toUpdate, new ChunkPos(pos.field_77276_a + x, pos.field_77275_b + z));
                }
            }
        }
    }
}

