/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.forge.mixin.perf.async_jei;

import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.helpers.IModIdHelper;
import mezz.jei.config.BookmarkConfig;
import mezz.jei.config.IClientConfig;
import mezz.jei.config.IEditModeConfig;
import mezz.jei.config.IIngredientFilterConfig;
import mezz.jei.config.IWorldConfig;
import mezz.jei.config.IngredientFilterConfig;
import mezz.jei.config.WorldConfig;
import mezz.jei.config.sorting.RecipeCategorySortingConfig;
import mezz.jei.events.EventBusHelper;
import mezz.jei.events.PlayerJoinedWorldEvent;
import mezz.jei.gui.textures.Textures;
import mezz.jei.ingredients.IIngredientSorter;
import mezz.jei.startup.ClientLifecycleHandler;
import mezz.jei.startup.JeiStarter;
import mezz.jei.startup.NetworkHandler;
import net.minecraft.client.Minecraft;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.eventbus.api.Event;
import org.embeddedt.modernfix.ModernFix;
import org.embeddedt.modernfix.annotation.ClientOnlyMixin;
import org.embeddedt.modernfix.annotation.RequiresMod;
import org.embeddedt.modernfix.forge.util.JEIUtil;
import org.embeddedt.modernfix.jei.async.JEILoadingInterruptedException;
import org.embeddedt.modernfix.jei.async.JEIReloadThread;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ClientLifecycleHandler.class})
@RequiresMod(value="jei")
@ClientOnlyMixin
public class ClientLifecycleHandlerMixin {
    @Shadow(remap=false)
    @Final
    private JeiStarter starter;
    @Shadow(remap=false)
    @Final
    private List<IModPlugin> plugins;
    @Shadow(remap=false)
    @Final
    private Textures textures;
    @Shadow(remap=false)
    @Final
    private IClientConfig clientConfig;
    @Shadow(remap=false)
    @Final
    private IEditModeConfig editModeConfig;
    @Shadow(remap=false)
    @Final
    private IngredientFilterConfig ingredientFilterConfig;
    @Shadow(remap=false)
    @Final
    private WorldConfig worldConfig;
    @Shadow(remap=false)
    @Final
    private BookmarkConfig bookmarkConfig;
    @Shadow(remap=false)
    @Final
    private IModIdHelper modIdHelper;
    @Shadow(remap=false)
    @Final
    private RecipeCategorySortingConfig recipeCategorySortingConfig;
    @Shadow(remap=false)
    @Final
    private IIngredientSorter ingredientSorter;
    private volatile JEIReloadThread reloadThread = null;
    private static int numReloads = 1;

    @Inject(method={"setupJEI"}, at={@At(value="INVOKE", target="Lmezz/jei/startup/ClientLifecycleHandler;startJEI()V")}, cancellable=true, remap=false)
    private void startAsync(CallbackInfo ci) {
        ci.cancel();
        this.startJEIAsync(() -> Minecraft.func_71410_x().execute(() -> EventBusHelper.post((Event)new PlayerJoinedWorldEvent())));
    }

    @Overwrite(remap=false)
    public void startJEI() {
        this.startJEIAsync(() -> {});
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void setupCancellationHandler(NetworkHandler networkHandler, Textures textures, CallbackInfo ci) {
        EventBusHelper.addListener((Object)this, ClientPlayerNetworkEvent.LoggedOutEvent.class, event -> this.cancelPreviousStart());
        JEIUtil.registerLoadingRenderer(() -> this.reloadThread != null);
    }

    private void cancelPreviousStart() {
        JEIReloadThread currentReloadThread = this.reloadThread;
        if (currentReloadThread != null) {
            currentReloadThread.requestStop();
            if (currentReloadThread.isAlive()) {
                ModernFix.LOGGER.warn("Blocking until JEI thread terminates");
                Minecraft.func_71410_x().func_213161_c(() -> !currentReloadThread.isAlive());
            }
            this.reloadThread = null;
        }
    }

    private void startJEIAsync(Runnable whenFinishedCb) {
        this.cancelPreviousStart();
        if (Minecraft.func_71410_x().field_71441_e == null) {
            return;
        }
        ModernFix.LOGGER.info("Starting new JEI thread.");
        JEIReloadThread newThread = new JEIReloadThread(() -> {
            if (((JEIReloadThread)Thread.currentThread()).isStopRequested()) {
                return;
            }
            try {
                this.starter.start(this.plugins, this.textures, this.clientConfig, this.editModeConfig, (IIngredientFilterConfig)this.ingredientFilterConfig, (IWorldConfig)this.worldConfig, this.bookmarkConfig, this.modIdHelper, this.recipeCategorySortingConfig, this.ingredientSorter);
            }
            catch (JEILoadingInterruptedException e) {
                ModernFix.LOGGER.warn("JEI loading interrupted prematurely (this is normal)");
            }
            whenFinishedCb.run();
            this.reloadThread = null;
        }, "ModernFix JEI Reload Thread " + numReloads++);
        newThread.setPriority(1);
        this.reloadThread = newThread;
        newThread.start();
    }
}

