/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.forge.mixin.perf.kubejs;

import dev.latvian.kubejs.item.ItemStackJS;
import dev.latvian.kubejs.item.ingredient.IngredientJS;
import dev.latvian.kubejs.item.ingredient.TagIngredientJS;
import java.util.Set;
import net.minecraft.item.Item;
import net.minecraft.tags.ITag;
import org.embeddedt.modernfix.annotation.RequiresMod;
import org.embeddedt.modernfix.duck.ICachedIngredientJS;
import org.embeddedt.modernfix.forge.util.KubeUtil;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={TagIngredientJS.class})
@RequiresMod(value="kubejs")
public abstract class TagIngredientJSMixin
implements ICachedIngredientJS {
    @Shadow
    public abstract ITag<Item> getActualTag();

    @Shadow(remap=false)
    public abstract Set<ItemStackJS> getStacks();

    @Inject(method={"anyStackMatches"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void checkItemOnly(IngredientJS ingredient, CallbackInfoReturnable<Boolean> cir) {
        if (ingredient instanceof ItemStackJS) {
            cir.setReturnValue((Object)((ItemStackJS)ingredient).getItem().func_206844_a(this.getActualTag()));
        }
    }

    @Override
    public Set<ItemStackJS> getCachedStacks() {
        ITag<Item> ourTag = this.getActualTag();
        Set<ItemStackJS> itemSet = KubeUtil.tagItemCache.get(ourTag);
        if (itemSet == null) {
            itemSet = this.getStacks();
            KubeUtil.tagItemCache.put(ourTag, itemSet);
        }
        return itemSet;
    }
}

