/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.forge.mixin.safety;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import org.embeddedt.modernfix.ModernFix;
import org.embeddedt.modernfix.annotation.ClientOnlyMixin;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EntityRendererManager.class}, priority=1500)
@ClientOnlyMixin
public class EntityRenderDispatcherMixin {
    @Shadow
    @Final
    @Mutable
    private Map<EntityType<?>, EntityRenderer<?>> field_78729_o;
    private static Map<EntityType<? extends Entity>, IRenderFactory<? extends Entity>> RENDER_FACTORIES;

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void makeRenderersConcurrent(CallbackInfo ci) {
        this.field_78729_o = new ConcurrentHashMap(this.field_78729_o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Inject(method={"getRenderer"}, at={@At(value="RETURN")}, cancellable=true)
    private <T extends Entity> void checkRenderer(T entity, CallbackInfoReturnable<EntityRenderer<?>> cir) {
        if (cir.getReturnValue() != null) return;
        Class<EntityRendererManager> clazz = EntityRendererManager.class;
        synchronized (EntityRendererManager.class) {
            IRenderFactory<? extends Entity> factory;
            EntityType type = entity.func_200600_R();
            if (type == null) {
                throw new IllegalStateException("Entity with class " + entity.getClass().getName() + " UUID " + entity.func_200200_C_() + " has no type???");
            }
            ResourceLocation key = Registry.field_212629_r.func_177774_c((Object)type);
            EntityRenderer renderer = null;
            if (RENDER_FACTORIES != null && (factory = RENDER_FACTORIES.get(type)) != null) {
                try {
                    renderer = factory.createRenderFor((EntityRendererManager)this);
                }
                catch (RuntimeException e) {
                    ModernFix.LOGGER.error("Failed to create fallback renderer", (Throwable)e);
                }
                if (renderer != null) {
                    this.field_78729_o.put(type, renderer);
                    ModernFix.LOGGER.warn("Entity renderer for {} was somehow not registered, injecting.", (Object)key);
                    cir.setReturnValue((Object)renderer);
                }
            }
            if (cir.getReturnValue() != null) return;
            ModernFix.LOGGER.error("Backing renderer map is a " + this.field_78729_o.getClass().getName());
            throw new IllegalStateException("No renderer for entity with type " + key);
        }
    }

    static {
        RenderingRegistry instance = (RenderingRegistry)ObfuscationReflectionHelper.getPrivateValue(RenderingRegistry.class, null, (String)"INSTANCE");
        RENDER_FACTORIES = (Map)ObfuscationReflectionHelper.getPrivateValue(RenderingRegistry.class, (Object)instance, (String)"entityRenderers");
    }
}

