/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.forge.searchtree;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.client.gui.recipebook.RecipeList;
import net.minecraft.client.util.ISearchTree;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import org.embeddedt.modernfix.searchtree.DummySearchTree;

public class RecipeBookSearchTree
extends DummySearchTree<RecipeList> {
    private final ISearchTree<ItemStack> stackCollector;
    private Map<Item, List<RecipeList>> collectionsByItem = null;
    private final List<RecipeList> allCollections = new ArrayList<RecipeList>();

    public RecipeBookSearchTree(ISearchTree<ItemStack> stackCollector) {
        this.stackCollector = stackCollector;
    }

    private Map<Item, List<RecipeList>> populateCollectionMap() {
        Object2ObjectOpenHashMap collections = this.collectionsByItem;
        if (collections == null) {
            Object2ObjectOpenHashMap finalCollection = collections = new Object2ObjectOpenHashMap();
            for (RecipeList collection : this.allCollections) {
                collection.func_192711_b().stream().map(recipe -> recipe.func_77571_b().func_77973_b()).distinct().forEach(arg_0 -> RecipeBookSearchTree.lambda$populateCollectionMap$2((Map)finalCollection, collection, arg_0));
            }
            this.collectionsByItem = collections;
        }
        return collections;
    }

    public void add(RecipeList pObj) {
        this.allCollections.add(pObj);
    }

    @Override
    public void func_217871_a() {
        this.allCollections.clear();
    }

    @Override
    public void func_194040_a() {
        this.collectionsByItem = null;
    }

    @Override
    public List<RecipeList> func_194038_a(String pSearchText) {
        if (pSearchText.trim().length() == 0) {
            return this.allCollections;
        }
        List stacks = this.stackCollector.func_194038_a(pSearchText);
        Map<Item, List<RecipeList>> collections = this.populateCollectionMap();
        return stacks.stream().map(ItemStack::func_77973_b).distinct().flatMap(item -> collections.getOrDefault(item, Collections.emptyList()).stream()).collect(Collectors.toList());
    }

    private static /* synthetic */ void lambda$populateCollectionMap$2(Map finalCollection, RecipeList collection, Item item) {
        finalCollection.computeIfAbsent(item, k -> new ArrayList()).add(collection);
    }
}

