/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.world;

import java.lang.ref.WeakReference;
import java.util.OptionalLong;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.DefaultWithNameUncaughtExceptionHandler;
import net.minecraft.util.Util;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.embeddedt.modernfix.duck.ITimeTrackingServer;
import org.embeddedt.modernfix.world.ThreadDumper;

public class IntegratedWatchdog
extends Thread {
    private static final Logger LOGGER = LogManager.getLogger();
    private final WeakReference<MinecraftServer> server;
    private static final long MAX_TICK_DELTA = 40000L;

    public IntegratedWatchdog(MinecraftServer server) {
        this.server = new WeakReference<MinecraftServer>(server);
        this.setDaemon(true);
        this.setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new DefaultWithNameUncaughtExceptionHandler(LOGGER));
        this.setName("ModernFix integrated server watchdog");
    }

    private OptionalLong getLastTickStart() {
        MinecraftServer server = (MinecraftServer)this.server.get();
        if (server == null || !server.func_71278_l()) {
            return OptionalLong.empty();
        }
        return OptionalLong.of(((ITimeTrackingServer)server).mfix$getLastTickStartTime());
    }

    @Override
    public void run() {
        OptionalLong lastTickStart;
        while ((lastTickStart = this.getLastTickStart()).isPresent()) {
            if (lastTickStart.getAsLong() < 0L) continue;
            long curTime = Util.func_211177_b();
            long delta = curTime - lastTickStart.getAsLong();
            if (delta > 40000L) {
                LOGGER.error("A single server tick has taken {}, more than {} milliseconds", (Object)delta, (Object)40000L);
                LOGGER.error(ThreadDumper.obtainThreadDump());
            }
            try {
                Thread.sleep(40000L - delta);
            }
            catch (InterruptedException interruptedException) {
            }
        }
        return;
    }
}

