/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.file.FileNotFoundAction;
import com.electronwill.nightconfig.core.io.ParsingException;
import com.electronwill.nightconfig.core.io.WritingMode;
import com.google.common.collect.ImmutableSet;
import fuzs.puzzleslib.PuzzlesLib;
import fuzs.puzzleslib.config.option.ConfigOption;
import fuzs.puzzleslib.config.option.OptionsBuilder;
import fuzs.puzzleslib.config.serialization.EntryCollectionBuilder;
import fuzs.puzzleslib.element.AbstractElement;
import fuzs.puzzleslib.element.ElementRegistry;
import fuzs.puzzleslib.element.side.ISidedElement;
import fuzs.puzzleslib.json.JsonConfigFileUtil;
import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ConfigManager {
    private static void onModConfig(ModConfig modConfig, AbstractElement generalElement, Collection<AbstractElement> allElements, boolean isReloading) {
        ModConfig.Type type = modConfig.getType();
        ConfigManager.syncOptions(allElements, type, isReloading);
        ConfigManager.getAllOptions((Collection<AbstractElement>)ImmutableSet.of((Object)generalElement), type).forEach(ConfigOption::sync);
    }

    public static boolean load(AbstractElement generalElement, Collection<AbstractElement> allElements, boolean loadConfigEarly, ModContainer activeContainer, String[] configSubPath) {
        boolean successful = false;
        for (ModConfig.Type type : ModConfig.Type.values()) {
            if (type == ModConfig.Type.CLIENT && FMLEnvironment.dist.isDedicatedServer() || type == ModConfig.Type.SERVER && FMLEnvironment.dist.isClient()) continue;
            OptionsBuilder optionsBuilder = new OptionsBuilder(type);
            ConfigManager.create(optionsBuilder, generalElement, builder -> allElements.stream().filter(ISidedElement.getGeneralFilter(type)).forEach(element -> element.setupGeneralConfig((OptionsBuilder)builder)), new String[0]);
            for (AbstractElement element : allElements) {
                ISidedElement.setupConfig(optionsBuilder, type, element);
            }
            Optional<ForgeConfigSpec> optionalSpec = optionsBuilder.build();
            if (!optionalSpec.isPresent()) continue;
            successful = true;
            PuzzlesLib.LOGGER.info("Loading config type {} for mod {}...", (Object)type.extension(), (Object)activeContainer.getNamespace());
            ForgeConfigSpec spec = optionalSpec.get();
            ModConfig modConfig = new ModConfig(type, spec, activeContainer, ConfigManager.getFileName(activeContainer.getNamespace(), type, configSubPath));
            activeContainer.addConfig(modConfig);
            if (!loadConfigEarly || type == ModConfig.Type.SERVER) continue;
            ConfigManager.loadConfigEarly(modConfig, allElements);
        }
        FMLJavaModLoadingContext.get().getModEventBus().addListener(evt -> {
            if (!loadConfigEarly || evt instanceof ModConfig.Reloading) {
                ConfigManager.onModConfig(evt.getConfig(), generalElement, allElements, evt instanceof ModConfig.Reloading);
            }
        });
        return successful;
    }

    private static void loadConfigEarly(ModConfig modConfig, Collection<AbstractElement> allElements) {
        Path configPath = FMLPaths.CONFIGDIR.get().resolve(modConfig.getFileName());
        CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)configPath).sync().preserveInsertionOrder().autosave().onFileNotFound(FileNotFoundAction.CREATE_EMPTY).writingMode(WritingMode.REPLACE).build();
        try {
            configData.load();
        }
        catch (ParsingException e) {
            throw new RuntimeException("Failed loading config file " + modConfig.getFileName() + " of type " + modConfig.getType() + " for modid " + modConfig.getModId(), e);
        }
        modConfig.getSpec().setConfig((CommentedConfig)configData);
        ConfigManager.syncOptions(allElements, modConfig.getType(), false);
        configData.save();
    }

    public static void create(OptionsBuilder builder, AbstractElement element, Consumer<OptionsBuilder> setupConfig, String ... comment) {
        if (comment.length != 0) {
            builder.comment(comment);
        }
        builder.push(element);
        setupConfig.accept(builder);
        builder.pop(element);
    }

    public static void syncOptions(Collection<AbstractElement> allElements, ModConfig.Type type, boolean isReloading) {
        Collection<ConfigOption<?>> options = ConfigManager.getAllOptions(allElements, type);
        if (!options.isEmpty()) {
            if (isReloading) {
                PuzzlesLib.LOGGER.info("Reloading {} config options for {}", (Object)type.extension(), (Object)ElementRegistry.joinElementNames(allElements));
            }
            options.forEach(ConfigOption::sync);
        }
    }

    public static Collection<ConfigOption<?>> getAllOptions(Collection<AbstractElement> elements, ModConfig.Type type) {
        return elements.stream().flatMap(element -> element.getOptions().stream()).filter(option -> option.isType(type)).collect(Collectors.toSet());
    }

    public static String getFileName(String modId, ModConfig.Type type) {
        return String.format("%s-%s.toml", modId, type.extension());
    }

    public static String getFileName(String modId, ModConfig.Type type, String ... path) {
        String fileName = ConfigManager.getFileName(modId, type);
        if (path.length != 0) {
            String prefix = String.join((CharSequence)File.separator, path);
            JsonConfigFileUtil.mkdirs(prefix);
            return prefix + File.separator + fileName;
        }
        return fileName;
    }

    @SafeVarargs
    public static <T extends IForgeRegistryEntry<T>> List<String> getKeyList(T ... entries) {
        return Stream.of(entries).map(IForgeRegistryEntry::getRegistryName).filter(Objects::nonNull).map(ResourceLocation::toString).collect(Collectors.toList());
    }

    public static <T extends IForgeRegistryEntry<T>> Set<T> deserializeToSet(List<String> data, IForgeRegistry<T> registry) {
        return new EntryCollectionBuilder<T>(registry).buildEntrySet(data);
    }

    public static <T extends IForgeRegistryEntry<T>> Map<T, double[]> deserializeToMap(List<String> data, IForgeRegistry<T> registry) {
        return new EntryCollectionBuilder<T>(registry).buildEntryMap(data);
    }
}

