/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.registry.v2;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import fuzs.puzzleslib.util.NamespaceUtil;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.EntityType;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.potion.Effect;
import net.minecraft.potion.Potion;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public enum RegistryManager {
    INSTANCE;

    private final Map<String, ModRegistry> modToRegistry = Maps.newConcurrentMap();

    @SubscribeEvent
    public void onRegistryRegister(RegistryEvent.Register<?> evt) {
        this.getCurrentModRegistry().addAllToRegistry(evt.getRegistry());
    }

    public <T extends IForgeRegistryEntry<T>> void register(IForgeRegistry<T> registry, Supplier<T> entry) {
        this.register(registry, null, entry);
    }

    public <T extends IForgeRegistryEntry<T>> RegistryObject<T> register(IForgeRegistry<T> registry, @Nullable String path, Supplier<T> entry) {
        this.getCurrentModRegistry().register(registry, () -> {
            IForgeRegistryEntry e = (IForgeRegistryEntry)entry.get();
            Objects.requireNonNull(e, "Can't register null object");
            if (e.getRegistryName() == null) {
                Objects.requireNonNull(path, "Can't register object without name");
                e.setRegistryName(NamespaceUtil.locate(path));
            }
            return e;
        });
        if (path != null) {
            return RegistryObject.of((ResourceLocation)NamespaceUtil.locate(path), registry);
        }
        return null;
    }

    private ModRegistry getCurrentModRegistry() {
        return this.getModRegistry(NamespaceUtil.namespace());
    }

    private ModRegistry getModRegistry(String namespace) {
        return this.modToRegistry.computeIfAbsent(namespace, key -> {
            FMLJavaModLoadingContext.get().getModEventBus().register((Object)this);
            return new ModRegistry();
        });
    }

    public RegistryObject<Block> registerBlock(@Nullable String path, Supplier<Block> entry) {
        return this.register(ForgeRegistries.BLOCKS, path, entry);
    }

    public void registerBlockWithItem(@Nonnull String path, Supplier<Block> entry, ItemGroup creativeTab) {
        this.registerBlockWithItem(path, entry, new Item.Properties().func_200916_a(creativeTab));
    }

    public void registerBlockWithItem(@Nonnull String path, Supplier<Block> entry, Item.Properties properties) {
        this.registerBlock(path, entry);
        this.registerBlockItem(path, properties);
    }

    public RegistryObject<Fluid> registerFluid(@Nullable String path, Supplier<Fluid> entry) {
        return this.register(ForgeRegistries.FLUIDS, path, entry);
    }

    public RegistryObject<Item> registerItem(@Nullable String path, Supplier<Item> entry) {
        return this.register(ForgeRegistries.ITEMS, path, entry);
    }

    public RegistryObject<Item> registerBlockItem(@Nonnull String path, ItemGroup creativeTab) {
        return this.registerBlockItem(path, new Item.Properties().func_200916_a(creativeTab));
    }

    public RegistryObject<Item> registerBlockItem(@Nonnull String path, Item.Properties properties) {
        return this.registerItem(path, () -> {
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(NamespaceUtil.locate(path));
            Objects.requireNonNull(block, "Can't register item for null block");
            return new BlockItem(block, properties);
        });
    }

    public RegistryObject<Effect> registerEffect(@Nullable String path, Supplier<Effect> entry) {
        return this.register(ForgeRegistries.POTIONS, path, entry);
    }

    public RegistryObject<SoundEvent> registerSoundEvent(@Nullable String path, Supplier<SoundEvent> entry) {
        return this.register(ForgeRegistries.SOUND_EVENTS, path, entry);
    }

    public RegistryObject<Potion> registerPotion(@Nullable String path, Supplier<Potion> entry) {
        return this.register(ForgeRegistries.POTION_TYPES, path, entry);
    }

    public RegistryObject<Enchantment> registerEnchantment(@Nullable String path, Supplier<Enchantment> entry) {
        return this.register(ForgeRegistries.ENCHANTMENTS, path, entry);
    }

    public RegistryObject<EntityType<?>> registerRawEntityType(@Nonnull String path, Supplier<EntityType.Builder<?>> entry) {
        return this.registerEntityType(path, () -> ((EntityType.Builder)entry.get()).func_206830_a(path));
    }

    public RegistryObject<EntityType<?>> registerEntityType(@Nullable String path, Supplier<EntityType<?>> entry) {
        return this.register(ForgeRegistries.ENTITIES, path, entry);
    }

    public RegistryObject<TileEntityType<?>> registerRawTileEntityType(@Nullable String path, Supplier<TileEntityType.Builder<?>> entry) {
        return this.registerTileEntityType(path, () -> ((TileEntityType.Builder)entry.get()).func_206865_a(null));
    }

    public RegistryObject<TileEntityType<?>> registerTileEntityType(@Nullable String path, Supplier<TileEntityType<?>> entry) {
        return this.register(ForgeRegistries.TILE_ENTITIES, path, entry);
    }

    public RegistryObject<ContainerType<?>> registerRawContainerType(@Nullable String path, Supplier<ContainerType.IFactory<?>> entry) {
        return this.registerContainerType(path, () -> new ContainerType((ContainerType.IFactory)entry.get()));
    }

    public RegistryObject<ContainerType<?>> registerContainerType(@Nullable String path, Supplier<ContainerType<?>> entry) {
        return this.register(ForgeRegistries.CONTAINERS, path, entry);
    }

    private static class ModRegistry {
        private final Multimap<IForgeRegistry<? extends IForgeRegistryEntry<?>>, Supplier<? extends IForgeRegistryEntry<?>>> registryToFactory = ArrayListMultimap.create();

        private ModRegistry() {
        }

        public <T extends IForgeRegistryEntry<T>> void register(IForgeRegistry<T> registry, Supplier<T> entry) {
            this.registryToFactory.put(registry, entry);
        }

        public <T extends IForgeRegistryEntry<T>> void addAllToRegistry(IForgeRegistry<T> registry) {
            this.registryToFactory.get(registry).forEach(entry -> registry.register((IForgeRegistryEntry)entry.get()));
        }
    }
}

