/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.lib.lib.util;

import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class FluidTankWithListener
extends FluidTank {
    private boolean drainable = true;
    private IFluidTankListener listener;

    public FluidTankWithListener(int capacity) {
        super(capacity);
    }

    public FluidTankWithListener(int capacity, Predicate<FluidStack> validator) {
        super(capacity, validator);
    }

    @Nonnull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        if (!this.drainable) {
            return FluidStack.EMPTY;
        }
        FluidStack stack = super.drain(maxDrain, action);
        this.listener.onTankContentChanged();
        return stack;
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        int amount = super.fill(resource, action);
        this.listener.onTankContentChanged();
        return amount;
    }

    public void setDrainable(boolean drainable) {
        this.drainable = drainable;
    }

    public FluidTankWithListener setListener(IFluidTankListener listener) {
        this.listener = listener;
        return this;
    }

    protected void onContentsChanged() {
        if (this.listener != null) {
            this.listener.onTankContentChanged();
        }
    }

    public static interface IFluidTankListener {
        public void onTankContentChanged();
    }
}

