/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.advancements;

import com.google.gson.JsonObject;
import javax.annotation.Nonnull;
import net.minecraft.advancements.criterion.AbstractCriterionTrigger;
import net.minecraft.advancements.criterion.CriterionInstance;
import net.minecraft.advancements.criterion.EntityPredicate;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.loot.ConditionArrayParser;
import net.minecraft.loot.ConditionArraySerializer;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VampireActionTrigger
extends AbstractCriterionTrigger<Instance> {
    public static final ResourceLocation ID = new ResourceLocation("vampirism", "vampire_action");
    private static final Logger LOGGER = LogManager.getLogger();

    public static Instance builder(Action action) {
        return new Instance(action);
    }

    @Nonnull
    public ResourceLocation func_192163_a() {
        return ID;
    }

    public void trigger(ServerPlayerEntity player, Action action) {
        this.func_235959_a_(player, instance -> instance.test(action));
    }

    @Nonnull
    protected Instance createInstance(JsonObject json, @Nonnull EntityPredicate.AndPredicate entityPredicate, @Nonnull ConditionArrayParser conditionsParser) {
        Action action = Action.NONE;
        if (json.has("action")) {
            String name = json.get("action").getAsString();
            try {
                action = Action.valueOf(name.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                LOGGER.warn("Action {} does not exist", (Object)name);
            }
        } else {
            LOGGER.warn("Action not specified");
        }
        return new Instance(action);
    }

    static class Instance
    extends CriterionInstance {
        @Nonnull
        private final Action action;

        Instance(@Nonnull Action action) {
            super(ID, EntityPredicate.AndPredicate.field_234582_a_);
            this.action = action;
        }

        @Nonnull
        public JsonObject func_230240_a_(@Nonnull ConditionArraySerializer serializer) {
            JsonObject json = super.func_230240_a_(serializer);
            json.addProperty("action", this.action.name());
            return json;
        }

        boolean test(Action action) {
            return this.action == action;
        }
    }

    public static enum Action {
        SNIPED_IN_BAT,
        POISONOUS_BITE,
        PERFORM_RITUAL_INFUSION,
        BAT,
        SUCK_BLOOD,
        NONE,
        KILL_FROZEN_HUNTER;

    }
}

