/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.api.entity.player.task;

import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.util.ResourceLocation;

public class TaskRequirement {
    private final Map<Type, List<Requirement<?>>> requirements;
    private final int size;
    private final boolean hasStatBasedReq;

    public TaskRequirement(Map<Type, List<Requirement<?>>> requirements) {
        this.requirements = requirements;
        this.size = requirements.values().stream().mapToInt(List::size).sum();
        this.hasStatBasedReq = requirements.keySet().stream().anyMatch(Type::isStatBased);
    }

    public List<Requirement<?>> getAll() {
        return this.requirements.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    public boolean isHasStatBasedReq() {
        return this.hasStatBasedReq;
    }

    public void removeRequirement(IFactionPlayer<?> player) {
        for (Type type : this.requirements.keySet()) {
            for (Requirement<?> requirement : this.requirements.get((Object)type)) {
                requirement.removeRequirement(player);
            }
        }
    }

    public Map<Type, List<Requirement<?>>> requirements() {
        return this.requirements;
    }

    public int size() {
        return this.size;
    }

    public static interface Requirement<T> {
        default public int getAmount(IFactionPlayer<?> player) {
            return 1;
        }

        @Nonnull
        public ResourceLocation getId();

        @Nonnull
        public T getStat(IFactionPlayer<?> var1);

        @Nonnull
        default public Type getType() {
            return Type.BOOLEAN;
        }

        default public void removeRequirement(IFactionPlayer<?> player) {
        }
    }

    public static enum Type {
        STATS(true, "gui.vampirism.taskmaster.stat_req"),
        ITEMS(false, "gui.vampirism.taskmaster.item_req"),
        ENTITY(true, "gui.vampirism.taskmaster.entity_req"),
        ENTITY_TAG(true, "gui.vampirism.taskmaster.entity_tag_req"),
        BOOLEAN(false, "gui.vampirism.taskmaster.bool_req");

        private final boolean statBased;
        private final String translationKey;

        private Type(boolean statBased, String translationKey) {
            this.statBased = statBased;
            this.translationKey = translationKey;
        }

        public String getTranslationKey() {
            return this.translationKey;
        }

        public boolean isStatBased() {
            return this.statBased;
        }
    }
}

