/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.api.items;

import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.factions.IFactionPlayerHandler;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.items.OilRegistry;
import de.teamlapen.vampirism.api.items.oil.IApplicableOil;
import de.teamlapen.vampirism.api.items.oil.IOil;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;

public interface IFactionLevelItem<T extends IFactionPlayer<?>> {
    @OnlyIn(value=Dist.CLIENT)
    @Deprecated
    default public void addFactionLevelToolTip(@Nonnull ItemStack stack, @Nullable World worldIn, @Nonnull List<ITextComponent> tooltip, ITooltipFlag flagIn, @Nullable PlayerEntity player) {
        this.addFactionToolTips(stack, worldIn, tooltip, flagIn, player);
    }

    default public void addFactionToolTips(@Nonnull ItemStack stack, @Nullable World worldIn, @Nonnull List<ITextComponent> tooltip, ITooltipFlag flagIn, @Nullable PlayerEntity player) {
        ISkill requiredSkill;
        LazyOptional<IFactionPlayerHandler> playerHandler = player != null && player.func_70089_S() ? VampirismAPI.getFactionPlayerHandler(player) : LazyOptional.empty();
        this.addFactionLevelOilDescTooltip(stack, worldIn, tooltip, flagIn, player);
        tooltip.add(StringTextComponent.field_240750_d_);
        tooltip.add((ITextComponent)new TranslationTextComponent("text.vampirism.faction_specifics").func_240699_a_(TextFormatting.GRAY));
        TextFormatting color = TextFormatting.GRAY;
        IPlayableFaction<T> faction = this.getUsingFaction(stack);
        if (player != null) {
            color = VampirismAPI.factionRegistry().getFaction((Entity)player) == faction ? TextFormatting.DARK_GREEN : TextFormatting.DARK_RED;
        }
        tooltip.add((ITextComponent)new StringTextComponent(" ").func_230529_a_(faction.getName()).func_230529_a_((ITextComponent)new TranslationTextComponent("text.vampirism.faction_only")).func_240699_a_(color));
        boolean correctFaction = playerHandler.map(f -> f.isInFaction(this.getUsingFaction(stack))).orElse(false);
        int minLevel = this.getMinLevel(stack);
        if (minLevel > 1) {
            tooltip.add((ITextComponent)new TranslationTextComponent(" Required Level:").func_240702_b_(" ").func_240702_b_(String.valueOf(minLevel)).func_240699_a_(correctFaction ? TextFormatting.DARK_GREEN : TextFormatting.DARK_RED));
        }
        if ((requiredSkill = this.getRequiredSkill(stack)) != null) {
            tooltip.add((ITextComponent)new StringTextComponent(" ").func_230529_a_((ITextComponent)new TranslationTextComponent("text.vampirism.required_skill").func_230529_a_(requiredSkill.getName())).func_240699_a_(correctFaction && playerHandler.map(IFactionPlayerHandler::getCurrentFactionPlayer).flatMap(p -> p.map(d -> d.getSkillHandler().isSkillEnabled(requiredSkill))).orElse(false) != false ? TextFormatting.DARK_GREEN : TextFormatting.DARK_RED));
        }
    }

    default public void addFactionLevelOilDescTooltip(@Nonnull ItemStack stack, @Nullable World worldIn, @Nonnull List<ITextComponent> tooltip, ITooltipFlag flagIn, @Nullable PlayerEntity player) {
        if (!stack.func_77942_o()) {
            return;
        }
        CompoundNBT tag = stack.func_77978_p().func_74775_l("applied_oil");
        if (tag.func_74764_b("oil")) {
            IOil oil = (IOil)OilRegistry.getOilRegistry().getValue(new ResourceLocation(tag.func_74779_i("oil")));
            int duration = tag.func_74762_e("duration");
            if (oil instanceof IApplicableOil && duration > 0) {
                ((IApplicableOil)oil).getToolTipLine(stack, (IApplicableOil)oil, duration, flagIn).ifPresent(tooltip::add);
            }
        }
    }

    public int getMinLevel(@Nonnull ItemStack var1);

    @Nullable
    public ISkill getRequiredSkill(@Nonnull ItemStack var1);

    @Nullable
    public IPlayableFaction<T> getUsingFaction(@Nonnull ItemStack var1);
}

