/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.blocks;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.blocks.VampirismHorizontalBlock;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.Property;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class ChurchAltarBlock
extends VampirismHorizontalBlock {
    private static final VoxelShape SHAPEX = ChurchAltarBlock.makeShape();
    private static final VoxelShape SHAPEZ = UtilLib.rotateShape(SHAPEX, UtilLib.RotationAmount.NINETY);

    private static VoxelShape makeShape() {
        VoxelShape a = Block.func_208617_a((double)1.0, (double)0.0, (double)5.0, (double)15.0, (double)1.0, (double)12.0);
        VoxelShape b = Block.func_208617_a((double)7.0, (double)1.0, (double)7.0, (double)9.0, (double)12.0, (double)11.0);
        VoxelShape c = Block.func_208617_a((double)1.0, (double)9.0, (double)3.0, (double)15.0, (double)14.0, (double)13.0);
        VoxelShape r = VoxelShapes.func_197872_a((VoxelShape)a, (VoxelShape)b);
        return VoxelShapes.func_197872_a((VoxelShape)r, (VoxelShape)c);
    }

    public ChurchAltarBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d).func_200943_b(0.5f).func_226896_b_());
        this.func_180632_j((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH));
    }

    @Override
    @Nonnull
    public VoxelShape func_220053_a(BlockState blockState, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        Direction dir = (Direction)blockState.func_177229_b((Property)FACING);
        if (dir == Direction.NORTH || dir == Direction.SOUTH) {
            return SHAPEX;
        }
        return SHAPEZ;
    }

    @Override
    @Nullable
    public BlockState func_196258_a(BlockItemUseContext ctx) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)ctx.func_195992_f().func_176734_d());
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (!player.func_70089_S()) {
            return ActionResultType.PASS;
        }
        return FactionPlayerHandler.getOpt(player).map(handler -> {
            if (handler.isInFaction(VReference.VAMPIRE_FACTION)) {
                VampirismMod.proxy.displayRevertBackScreen();
                return ActionResultType.SUCCESS;
            }
            return ActionResultType.PASS;
        }).orElse(ActionResultType.PASS);
    }
}

