/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.blocks;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.blocks.VampirismBlock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class VampirismSplitBlock
extends VampirismBlock {
    public static final DirectionProperty FACING = BlockStateProperties.field_208157_J;
    public static final EnumProperty<Part> PART = EnumProperty.func_177709_a((String)"part", Part.class);
    private final VoxelShape NORTH1;
    private final VoxelShape EAST1;
    private final VoxelShape SOUTH1;
    private final VoxelShape WEST1;
    private final VoxelShape NORTH2;
    private final VoxelShape EAST2;
    private final VoxelShape SOUTH2;
    private final VoxelShape WEST2;
    private final boolean vertical;

    public VampirismSplitBlock(AbstractBlock.Properties properties, VoxelShape mainShape, VoxelShape subShape, boolean vertical) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a(PART, (Comparable)((Object)Part.MAIN)));
        this.NORTH1 = mainShape;
        this.EAST1 = UtilLib.rotateShape(this.NORTH1, UtilLib.RotationAmount.NINETY);
        this.SOUTH1 = UtilLib.rotateShape(this.NORTH1, UtilLib.RotationAmount.HUNDRED_EIGHTY);
        this.WEST1 = UtilLib.rotateShape(this.NORTH1, UtilLib.RotationAmount.TWO_HUNDRED_SEVENTY);
        this.NORTH2 = subShape;
        this.EAST2 = UtilLib.rotateShape(this.NORTH2, UtilLib.RotationAmount.NINETY);
        this.SOUTH2 = UtilLib.rotateShape(this.NORTH2, UtilLib.RotationAmount.HUNDRED_EIGHTY);
        this.WEST2 = UtilLib.rotateShape(this.NORTH2, UtilLib.RotationAmount.TWO_HUNDRED_SEVENTY);
        this.vertical = vertical;
    }

    @Nonnull
    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.DESTROY;
    }

    public BlockRenderType func_149645_b(BlockState p_149645_1_) {
        return p_149645_1_.func_177229_b(PART) == Part.MAIN ? BlockRenderType.MODEL : BlockRenderType.INVISIBLE;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        boolean main = state.func_177229_b(PART) == Part.MAIN;
        switch ((Direction)state.func_177229_b((Property)FACING)) {
            case NORTH: {
                return main ? this.NORTH1 : this.NORTH2;
            }
            case EAST: {
                return main ? this.EAST1 : this.EAST2;
            }
            case SOUTH: {
                return main ? this.SOUTH1 : this.SOUTH2;
            }
            case WEST: {
                return main ? this.WEST1 : this.WEST2;
            }
        }
        return this.NORTH1;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction enumfacing = context.func_195992_f();
        BlockPos blockpos = context.func_195995_a();
        BlockPos blockpos1 = blockpos.func_177972_a(this.vertical ? Direction.UP : enumfacing);
        return context.func_195991_k().func_180495_p(blockpos1).func_196953_a(context) ? (BlockState)this.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)enumfacing) : null;
    }

    public boolean func_196266_a(@Nonnull BlockState state, @Nonnull IBlockReader worldIn, @Nonnull BlockPos pos, PathType type) {
        return false;
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public void func_176208_a(World world, BlockPos blockPos, BlockState blockState, PlayerEntity player) {
        BlockPos blockpos;
        BlockState otherState;
        Part part;
        if (!world.field_72995_K && player.func_184812_l_() && (part = (Part)((Object)blockState.func_177229_b(PART))) == Part.SUB && (otherState = world.func_180495_p(blockpos = blockPos.func_177972_a(this.getOtherBlockDirection(blockState)))).func_177230_c() == this && otherState.func_177229_b(PART) == Part.MAIN) {
            world.func_180501_a(blockpos, Blocks.field_150350_a.func_176223_P(), 35);
            world.func_217378_a(player, 2001, blockpos, Block.func_196246_j((BlockState)otherState));
        }
        super.func_176208_a(world, blockPos, blockState, player);
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack itemStack) {
        super.func_180633_a(world, pos, state, placer, itemStack);
        if (!world.field_72995_K) {
            BlockPos blockpos = pos.func_177972_a(this.getOtherBlockDirection(state));
            BlockState otherState = (BlockState)state.func_206870_a(PART, (Comparable)((Object)Part.SUB));
            if (!this.vertical) {
                otherState = (BlockState)otherState.func_206870_a((Property)FACING, (Comparable)((Direction)otherState.func_177229_b((Property)FACING)).func_176734_d());
            }
            world.func_180501_a(blockpos, otherState, 3);
            world.func_230547_a_(pos, Blocks.field_150350_a);
            state.func_235734_a_((IWorld)world, pos, 3);
        }
    }

    @Nonnull
    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (facing == this.getOtherBlockDirection(stateIn)) {
            return facingState.func_177230_c() == this && facingState.func_177229_b(PART) != stateIn.func_177229_b(PART) ? this.updateFromOther(stateIn, facingState) : Blocks.field_150350_a.func_176223_P();
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, PART});
    }

    protected Direction getOtherBlockDirection(BlockState blockState) {
        if (this.vertical) {
            return blockState.func_177229_b(PART) == Part.MAIN ? Direction.UP : Direction.DOWN;
        }
        return (Direction)blockState.func_177229_b((Property)FACING);
    }

    protected BlockState updateFromOther(BlockState thisState, BlockState otherState) {
        return thisState;
    }

    public static enum Part implements IStringSerializable
    {
        MAIN("main"),
        SUB("sub");

        private final String name;

        private Part(String name) {
            this.name = name;
        }

        public String func_176610_l() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }
}

