/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.core;

import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.blocks.CoffinBlock;
import de.teamlapen.vampirism.blocks.TotemTopBlock;
import de.teamlapen.vampirism.client.render.tiles.AltarInfusionTESR;
import de.teamlapen.vampirism.client.render.tiles.CoffinTESR;
import de.teamlapen.vampirism.client.render.tiles.GarlicBeaconTESR;
import de.teamlapen.vampirism.client.render.tiles.PedestalTESR;
import de.teamlapen.vampirism.client.render.tiles.TotemTESR;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.core.ModFluids;
import de.teamlapen.vampirism.core.ModTiles;
import de.teamlapen.vampirism.tileentity.AlchemicalCauldronTileEntity;
import de.teamlapen.vampirism.tileentity.TotemTileEntity;
import java.util.Arrays;
import java.util.Comparator;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.item.DyeColor;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.registry.ClientRegistry;

@OnlyIn(value=Dist.CLIENT)
public class ModBlocksRender {
    public static final RenderMaterial[] COFFIN_TEXTURES = (RenderMaterial[])Arrays.stream(DyeColor.values()).sorted(Comparator.comparingInt(DyeColor::func_196059_a)).map(dye -> new RenderMaterial(PlayerContainer.field_226615_c_, new ResourceLocation("vampirism", "block/coffin/coffin_" + dye.func_176762_d()))).toArray(RenderMaterial[]::new);

    public static void register() {
        ModBlocksRender.registerTileRenderer();
        ModBlocksRender.registerRenderType();
    }

    public static void registerColorsUnsafe() {
        BlockColors colors = Minecraft.func_71410_x().func_184125_al();
        colors.func_186722_a((state, worldIn, pos, tintIndex) -> {
            if (tintIndex == 1) {
                return 0x9966FF;
            }
            return 0x8855FF;
        }, new Block[]{(Block)ModBlocks.ALCHEMICAL_FIRE.get()});
        colors.func_186722_a((state, worldIn, pos, tintIndex) -> {
            if (tintIndex == 255) {
                TileEntity tile;
                TileEntity tileEntity = tile = worldIn == null || pos == null ? null : worldIn.func_175625_s(pos);
                if (tile instanceof AlchemicalCauldronTileEntity) {
                    return ((AlchemicalCauldronTileEntity)tile).getLiquidColorClient();
                }
            }
            return 0xFFFFFF;
        }, new Block[]{(Block)ModBlocks.ALCHEMICAL_CAULDRON.get()});
        colors.func_186722_a((state, worldIn, pos, tintIndex) -> {
            if (tintIndex == 255) {
                IFaction<?> f;
                TileEntity tile;
                TileEntity tileEntity = tile = worldIn == null || pos == null ? null : worldIn.func_175625_s(pos);
                if (tile instanceof TotemTileEntity && (f = ((TotemTileEntity)tile).getControllingFaction()) != null) {
                    return f.getColor().getRGB();
                }
            }
            return 0xFFFFFF;
        }, (Block[])TotemTopBlock.getBlocks().toArray(new TotemTopBlock[0]));
        colors.func_186722_a((state, worldIn, pos, tintIndex) -> 0x1E1F1F, new Block[]{(Block)ModBlocks.DARK_SPRUCE_LEAVES.get()});
    }

    private static void registerTileRenderer() {
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)ModTiles.COFFIN.get()), CoffinTESR::new);
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)ModTiles.ALTAR_INFUSION.get()), AltarInfusionTESR::new);
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)ModTiles.BLOOD_PEDESTAL.get()), PedestalTESR::new);
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)ModTiles.TOTEM.get()), TotemTESR::new);
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)ModTiles.GARLIC_BEACON.get()), GarlicBeaconTESR::new);
    }

    private static void registerRenderType() {
        RenderType cutout = RenderType.func_228643_e_();
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.GARLIC_BEACON_WEAK.get()), (RenderType)cutout);
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.GARLIC_BEACON_IMPROVED.get()), (RenderType)cutout);
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.GARLIC_BEACON_NORMAL.get()), (RenderType)cutout);
        RenderTypeLookup.setRenderLayer((Fluid)((Fluid)ModFluids.IMPURE_BLOOD.get()), (RenderType)RenderType.func_228645_f_());
        RenderTypeLookup.setRenderLayer((Fluid)((Fluid)ModFluids.BLOOD.get()), (RenderType)RenderType.func_228645_f_());
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.ALCHEMICAL_CAULDRON.get()), (RenderType)cutout);
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.ALCHEMICAL_FIRE.get()), (RenderType)cutout);
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.ALTAR_INFUSION.get()), (RenderType)cutout);
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.ALTAR_INSPIRATION.get()), (RenderType)RenderType.func_228645_f_());
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.ALTAR_PILLAR.get()), (RenderType)cutout);
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.ALTAR_TIP.get()), (RenderType)cutout);
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.BLOOD_CONTAINER.get()), (RenderType)RenderType.func_228645_f_());
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.BLOOD_PEDESTAL.get()), (RenderType)cutout);
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.POTION_TABLE.get()), (RenderType)cutout);
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.BLOOD_SIEVE.get()), (RenderType)cutout);
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.CHURCH_ALTAR.get()), (RenderType)cutout);
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.FIRE_PLACE.get()), (RenderType)cutout);
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.SUNSCREEN_BEACON.get()), (RenderType)cutout);
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.TENT.get()), (RenderType)cutout);
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.TENT_MAIN.get()), (RenderType)cutout);
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.TOTEM_BASE.get()), (RenderType)cutout);
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.TOTEM_TOP.get()), (RenderType)cutout);
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.TOTEM_TOP_VAMPIRISM_HUNTER.get()), (RenderType)cutout);
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.TOTEM_TOP_VAMPIRISM_VAMPIRE.get()), (RenderType)cutout);
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.BLOOD_GRINDER.get()), (RenderType)cutout);
        CoffinBlock.COFFIN_BLOCKS.values().forEach(coffin -> RenderTypeLookup.setRenderLayer((Block)coffin, (RenderType)cutout));
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.HUNTER_TABLE.get()), (RenderType)cutout);
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.MED_CHAIR.get()), (RenderType)cutout);
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.WEAPON_TABLE.get()), (RenderType)cutout);
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.VAMPIRE_ORCHID.get()), (RenderType)cutout);
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.GARLIC.get()), (RenderType)cutout);
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.POTTED_VAMPIRE_ORCHID.get()), (RenderType)cutout);
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.DARK_SPRUCE_LEAVES.get()), (RenderType)RenderType.func_228641_d_());
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.DARK_SPRUCE_SAPLING.get()), (RenderType)cutout);
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.CHANDELIER.get()), (RenderType)cutout);
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.CANDELABRA.get()), (RenderType)cutout);
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.CANDELABRA_WALL.get()), (RenderType)cutout);
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.CROSS.get()), (RenderType)cutout);
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.TOMBSTONE1.get()), (RenderType)cutout);
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.TOMBSTONE2.get()), (RenderType)cutout);
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.TOMBSTONE3.get()), (RenderType)cutout);
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.GRAVE_CAGE.get()), (RenderType)cutout);
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.CURSED_ROOTS.get()), (RenderType)cutout);
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.CURSED_SPRUCE_SAPLING.get()), (RenderType)cutout);
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.CURSED_BARK.get()), (RenderType)cutout);
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.DARK_SPRUCE_DOOR.get()), (RenderType)cutout);
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.CURSED_SPRUCE_DOOR.get()), (RenderType)cutout);
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.DARK_SPRUCE_TRAPDOOR.get()), (RenderType)cutout);
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.CURSED_SPRUCE_TRAPDOOR.get()), (RenderType)cutout);
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.VAMPIRE_RACK.get()), (RenderType)cutout);
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.THRONE.get()), (RenderType)cutout);
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.ALCHEMY_TABLE.get()), (RenderType)cutout);
    }
}

